/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.contentassist;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.n4js.n4JS.JSXElement;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.resource.N4JSResourceDescriptionStrategy;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.types.DeclaredTypeWithAccessModifier;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMemberWithAccessModifier;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ui.contentassist.AbstractN4JSProposalProvider;
import org.eclipse.n4js.ui.contentassist.N4JSCandidateFilter;
import org.eclipse.n4js.ui.labeling.N4JSLabelProvider;
import org.eclipse.n4js.ui.proposals.imports.ImportsAwareReferenceProposalCreator;
import org.eclipse.n4js.ui.proposals.linkedEditing.N4JSCompletionProposal;
import org.eclipse.n4js.ui.utils.ConfigurableCompletionProposalExtensions;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.AbstractJavaBasedContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class N4JSProposalProvider
extends AbstractN4JSProposalProvider {
    private static final String KEY_SCANNED_SCOPES = String.valueOf(N4JSProposalProvider.class.getName()) + "_scannedScopes";
    @Inject
    private ImportsAwareReferenceProposalCreator importAwareReferenceProposalCreator;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private N4JSGrammarAccess n4jsGrammarAccess;
    @Inject
    private N4JSLabelProvider labelProvider;

    public void completeRuleCall(RuleCall ruleCall, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        AbstractRule calledRule = ruleCall.getRule();
        boolean _equals = "INT".equals(calledRule.getName());
        boolean bl = _not = !_equals;
        if (_not) {
            super.completeRuleCall(ruleCall, contentAssistContext, acceptor);
        }
    }

    protected void lookupCrossReference(CrossReference crossReference, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        N4JSCandidateFilter _n4JSCandidateFilter = new N4JSCandidateFilter();
        this.lookupCrossReference(crossReference, contentAssistContext, acceptor, _n4JSCandidateFilter);
    }

    protected void lookupCrossReference(CrossReference crossReference, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor, Predicate<IEObjectDescription> filter) {
        String _name;
        String featureName;
        boolean _equals;
        ParserRule _typeReferenceRule;
        boolean _tripleEquals;
        ParserRule containingParserRule = GrammarUtil.containingParserRule((EObject)crossReference);
        boolean bl = _tripleEquals = containingParserRule == (_typeReferenceRule = this.n4jsGrammarAccess.getTypeReferenceRule());
        if (_tripleEquals && (_equals = Objects.equal((Object)(featureName = GrammarUtil.containingAssignment((EObject)crossReference).getFeature()), (Object)(_name = TypeRefsPackage.eINSTANCE.getParameterizedTypeRef_DeclaredType().getName())))) {
            this.lookupCrossReference(crossReference, TypeRefsPackage.eINSTANCE.getParameterizedTypeRef_DeclaredType(), contentAssistContext, acceptor, filter);
        }
        super.lookupCrossReference(crossReference, contentAssistContext, acceptor, filter);
    }

    protected void lookupCrossReference(CrossReference crossReference, EReference reference, ContentAssistContext context, ICompletionProposalAcceptor acceptor, Predicate<IEObjectDescription> filter) {
        boolean _haveScannedScopeFor = this.haveScannedScopeFor(context.getCurrentModel(), reference);
        if (_haveScannedScopeFor) {
            return;
        }
        if (reference.getEReferenceType().isSuperTypeOf(TypesPackage.Literals.TYPE) || TypesPackage.Literals.TYPE.isSuperTypeOf(reference.getEReferenceType())) {
            String ruleName = null;
            AbstractElement _terminal = crossReference.getTerminal();
            if (_terminal instanceof RuleCall) {
                AbstractElement _terminal_1 = crossReference.getTerminal();
                ruleName = ((RuleCall)_terminal_1).getRule().getName();
            }
            Function<IEObjectDescription, ICompletionProposal> proposalFactory = this.getProposalFactory(ruleName, context);
            this.importAwareReferenceProposalCreator.lookupCrossReference(context.getCurrentModel(), reference, context, acceptor, filter, proposalFactory);
        } else {
            super.lookupCrossReference(crossReference, reference, context, acceptor, filter);
        }
    }

    private boolean haveScannedScopeFor(EObject context, EReference reference) {
        boolean _announceProcessing = this.announceProcessing(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{KEY_SCANNED_SCOPES, context, reference})));
        return !_announceProcessing;
    }

    protected Function<IEObjectDescription, ICompletionProposal> getProposalFactory(final String ruleName, final ContentAssistContext contentAssistContext) {
        BuiltInTypeScope builtInTypeScope = BuiltInTypeScope.get((ResourceSet)contentAssistContext.getResource().getResourceSet());
        TClassifier _objectType = builtInTypeScope.getObjectType();
        TClass _n4ObjectType = builtInTypeScope.getN4ObjectType();
        List secondaryTypes = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TClassifier[]{_objectType, _n4ObjectType}));
        Functions.Function1 _function = it -> it.getOwnedMembers();
        Functions.Function1 _function_1 = it -> EcoreUtil.getURI((EObject)it);
        final Set urisOfSecondaryMembers = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.flatMap(secondaryTypes, (Functions.Function1)_function), (Functions.Function1)_function_1));
        final IQualifiedNameConverter.DefaultImpl myConverter = new IQualifiedNameConverter.DefaultImpl();
        return new AbstractJavaBasedContentProposalProvider.DefaultProposalCreator((AbstractJavaBasedContentProposalProvider)this, contentAssistContext, ruleName, (IQualifiedNameConverter)myConverter){

            public ICompletionProposal apply(IEObjectDescription candidate) {
                if (candidate == null) {
                    return null;
                }
                ICompletionProposal result = null;
                String proposal = myConverter.toString(candidate.getName());
                if (this.valueConverter != null) {
                    try {
                        proposal = this.valueConverter.toString((Object)proposal);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof ValueConverterException) {
                            return null;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
                if (ruleName != null) {
                    try {
                        proposal = N4JSProposalProvider.this.getValueConverter().toString((Object)proposal, ruleName);
                    }
                    catch (Throwable _t_1) {
                        if (_t_1 instanceof ValueConverterException) {
                            return null;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t_1);
                    }
                }
                StyledString displayString = N4JSProposalProvider.this.getStyledDisplayString(candidate);
                Image image = N4JSProposalProvider.this.getImage(candidate);
                result = N4JSProposalProvider.this.createCompletionProposal(proposal, displayString, image, contentAssistContext);
                if (result instanceof ConfigurableCompletionProposal) {
                    Provider _function;
                    Provider provider = _function = () -> candidate.getEObjectOrProxy();
                    ((ConfigurableCompletionProposal)result).setProposalContextResource((Resource)contentAssistContext.getResource());
                    ((ConfigurableCompletionProposal)result).setAdditionalProposalInfo((Object)provider);
                    ((ConfigurableCompletionProposal)result).setHover(N4JSProposalProvider.this.getHover());
                    ConfigurableCompletionProposalExtensions.setSecondaryMember((ConfigurableCompletionProposal)result, urisOfSecondaryMembers.contains(candidate.getEObjectURI()));
                    ProposalBracketInfo bracketInfo = N4JSProposalProvider.this.computeProposalBracketInfo(candidate, contentAssistContext);
                    if (bracketInfo != null) {
                        ConfigurableCompletionProposalExtensions.setReplacementSuffix((ConfigurableCompletionProposal)result, bracketInfo.brackets);
                        ConfigurableCompletionProposalExtensions.setCursorOffset((ConfigurableCompletionProposal)result, bracketInfo.cursorOffset);
                    }
                }
                N4JSProposalProvider.this.getPriorityHelper().adjustCrossReferencePriority(result, contentAssistContext.getPrefix());
                return result;
            }
        };
    }

    public StyledString getStyledDisplayString(IEObjectDescription description) {
        QualifiedName name;
        int version = N4JSResourceDescriptionStrategy.getVersion((IEObjectDescription)description);
        QualifiedName qName = description.getQualifiedName();
        boolean _equals = Objects.equal((Object)qName, (Object)(name = description.getName()));
        if (_equals) {
            EObject eObj = description.getEObjectOrProxy();
            QualifiedName qnOfEObject = this.qualifiedNameProvider.getFullyQualifiedName(eObj);
            QualifiedName _elvis = null;
            _elvis = qnOfEObject != null ? qnOfEObject : qName;
            qName = _elvis;
        }
        StyledString sString = this.getStyledDisplayString(qName, name, version);
        return sString;
    }

    protected StyledString getStyledDisplayString(EObject element, String qualifiedNameString, String shortNameString) {
        int version = this.getTypeVersion(element);
        QualifiedName qualifiedName = this.qualifiedNameConverter.toQualifiedName(qualifiedNameString);
        QualifiedName shortName = this.qualifiedNameConverter.toQualifiedName(shortNameString);
        return this.getStyledDisplayString(qualifiedName, shortName, version);
    }

    protected StyledString getStyledDisplayString(QualifiedName qualifiedName, QualifiedName shortName, int version) {
        boolean _greaterThan;
        StyledString result = new StyledString();
        String shortNameString = shortName.toString();
        int _segmentCount = qualifiedName.getSegmentCount();
        boolean bl = _greaterThan = _segmentCount > 1;
        if (_greaterThan) {
            String _string = this.qualifiedNameConverter.toString(qualifiedName.skipLast(1));
            String dashName = " - " + _string;
            String lastSegment = qualifiedName.getLastSegment();
            String _xifexpression = null;
            if (version == 0) {
                _xifexpression = "";
            } else {
                String _valueOf = String.valueOf(version);
                _xifexpression = "#" + _valueOf;
            }
            String typeVersion = _xifexpression;
            String caption = null;
            String dashInfo = null;
            boolean _endsWith = shortNameString.endsWith(lastSegment);
            if (_endsWith) {
                caption = String.valueOf(lastSegment) + typeVersion;
                dashInfo = dashName;
            } else {
                caption = shortNameString;
                dashInfo = String.valueOf(dashName) + " alias for " + lastSegment + typeVersion;
            }
            result.append(caption);
            result.append(dashInfo, StyledString.QUALIFIER_STYLER);
        } else {
            result.append(shortNameString);
        }
        return result;
    }

    protected Image getImage(IEObjectDescription description) {
        EClass clazz = description.getEClass();
        EObject type = EcoreUtil.create((EClass)clazz);
        if (type instanceof TClass) {
            ((TClass)type).setDeclaredFinal(N4JSResourceDescriptionStrategy.getFinal((IEObjectDescription)description));
            ((TClass)type).setDeclaredAbstract(N4JSResourceDescriptionStrategy.getAbstract((IEObjectDescription)description));
        }
        if (type instanceof TExportableElement) {
            String _xifexpression = null;
            boolean _exported = N4JSResourceDescriptionStrategy.getExported((IEObjectDescription)description);
            _xifexpression = _exported ? " " : null;
            ((TExportableElement)type).setExportedName(_xifexpression);
        }
        if (type instanceof DeclaredTypeWithAccessModifier) {
            ((DeclaredTypeWithAccessModifier)type).setDeclaredTypeAccessModifier(N4JSResourceDescriptionStrategy.getTypeAccessModifier((IEObjectDescription)description));
        }
        if (type instanceof TFunction) {
            ((TFunction)type).setDeclaredTypeAccessModifier(N4JSResourceDescriptionStrategy.getTypeAccessModifier((IEObjectDescription)description));
        }
        if (type instanceof TMember) {
            EObject _eObjectOrProxy = description.getEObjectOrProxy();
            TMember member = (TMember)_eObjectOrProxy;
            ((TMember)type).setDeclaredFinal(member.isDeclaredFinal());
            if (type instanceof TMemberWithAccessModifier) {
                ((TMemberWithAccessModifier)type).setDeclaredMemberAccessModifier(member.getMemberAccessModifier());
            }
        }
        Image image = this.labelProvider.getImage(type);
        return image;
    }

    private int getTypeVersion(EObject element) {
        if (!element.eIsProxy() && element instanceof TClassifier && ((TClassifier)element).getDeclaredVersion() != 0) {
            return ((TClassifier)element).getDeclaredVersion();
        }
        return 0;
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _lessThan;
        boolean _not;
        if (context.getCurrentModel() instanceof ParameterizedPropertyAccessExpression || context.getPreviousModel() instanceof ParameterizedPropertyAccessExpression) {
            return;
        }
        if (context.getCurrentModel() instanceof JSXElement || context.getPreviousModel() instanceof JSXElement) {
            return;
        }
        boolean _isAlphabetic = Character.isAlphabetic(keyword.getValue().charAt(0));
        boolean bl = _not = !_isAlphabetic;
        if (_not) {
            return;
        }
        int _length = keyword.getValue().length();
        boolean bl2 = _lessThan = _length < 5;
        if (_lessThan) {
            return;
        }
        super.completeKeyword(keyword, context, acceptor);
    }

    protected ConfigurableCompletionProposal doCreateProposal(String proposal, StyledString displayString, Image image, int replacementOffset, int replacementLength) {
        int _length = proposal.length();
        return new N4JSCompletionProposal(proposal, replacementOffset, replacementLength, _length, image, displayString, null, null);
    }

    private ProposalBracketInfo computeProposalBracketInfo(IEObjectDescription proposedDescription, ContentAssistContext contentAssistContext) {
        EClass eClass = proposedDescription.getEClass();
        boolean _isSuperTypeOf = TypesPackage.eINSTANCE.getTFunction().isSuperTypeOf(eClass);
        if (_isSuperTypeOf) {
            return new ProposalBracketInfo("()", -1);
        }
        return null;
    }

    @Data
    private static final class ProposalBracketInfo {
        private final String brackets;
        private final int cursorOffset;

        public ProposalBracketInfo(String brackets, int cursorOffset) {
            this.brackets = brackets;
            this.cursorOffset = cursorOffset;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.brackets == null ? 0 : this.brackets.hashCode());
            return 31 * result + this.cursorOffset;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProposalBracketInfo other = (ProposalBracketInfo)obj;
            if (this.brackets == null ? other.brackets != null : !this.brackets.equals(other.brackets)) {
                return false;
            }
            return other.cursorOffset == this.cursorOffset;
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("brackets", (Object)this.brackets);
            b.add("cursorOffset", (Object)this.cursorOffset);
            return b.toString();
        }

        @Pure
        public String getBrackets() {
            return this.brackets;
        }

        @Pure
        public int getCursorOffset() {
            return this.cursorOffset;
        }
    }
}

