/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;

public abstract class RepositoryAction
extends AbstractHandler
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    private ISelection mySelection;
    protected final String commandId;
    protected IServiceLocator serviceLocator;
    private final RepositoryActionHandler handler;

    protected RepositoryAction(String commandId, RepositoryActionHandler handler) {
        this.commandId = commandId;
        this.handler = handler;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.serviceLocator = targetPart.getSite();
    }

    public void run(IAction action) {
        if (!this.shouldRunAction()) {
            return;
        }
        ExecutionEvent event = this.createExecutionEvent();
        try {
            this.handler.execute(event);
        }
        catch (ExecutionException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
    }

    protected ExecutionEvent createExecutionEvent() {
        Command command;
        IServiceLocator locator = this.getServiceLocator();
        ICommandService srv = CommonUtils.getService(locator, ICommandService.class);
        IHandlerService hsrv = CommonUtils.getService(locator, IHandlerService.class);
        ExecutionEvent event = hsrv.createExecutionEvent(command = srv.getCommand(this.commandId), null);
        if (event.getApplicationContext() instanceof IEvaluationContext) {
            ((IEvaluationContext)event.getApplicationContext()).addVariable("selection", (Object)this.mySelection);
        }
        return event;
    }

    protected IServiceLocator getServiceLocator() {
        if (this.serviceLocator == null) {
            this.serviceLocator = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        return this.serviceLocator;
    }

    public final void selectionChanged(IAction action, ISelection selection) {
        this.mySelection = selection;
        if (this.handler.alwaysCheckEnabled()) {
            this.handler.setSelection(this.mySelection);
            if (action != null) {
                action.setEnabled(this.isEnabled());
            }
        } else {
            IStructuredSelection selectionBefore = this.handler.getSelection();
            this.handler.setSelection(this.mySelection);
            if (action != null) {
                boolean equalSelection;
                IStructuredSelection selectionAfter = this.handler.getSelection();
                boolean bl = selectionBefore == null ? selectionAfter == null : (equalSelection = selectionBefore.equals(selectionAfter));
                if (!equalSelection) {
                    action.setEnabled(this.isEnabled());
                }
            }
        }
    }

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        if (!this.shouldRunAction()) {
            return null;
        }
        ICommandService srv = CommonUtils.getService(this.getServiceLocator(), ICommandService.class);
        Command command = srv.getCommand(this.commandId);
        try {
            return command.executeWithChecks(event);
        }
        catch (ExecutionException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        catch (NotDefinedException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        catch (NotEnabledException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        catch (NotHandledException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        return null;
    }

    public final boolean isEnabled() {
        return this.handler.isEnabled();
    }

    public void init(IWorkbenchWindow window) {
        this.serviceLocator = window;
    }

    protected boolean shouldRunAction() {
        return true;
    }
}

