/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.containers;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.ts.ui.navigation.URIBasedStorage;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseCore;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseProject;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseSourceContainer;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.impl.IToBeBuiltComputerContribution;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.resource.UriValidator;

@Singleton
public class N4JSToBeBuiltComputer
implements IToBeBuiltComputerContribution {
    @Inject
    private IBuilderState builderState;
    @Inject
    private IN4JSEclipseCore eclipseCore;
    @Inject
    private UriValidator uriValidator;

    public void removeProject(ToBeBuilt toBeBuilt, IProject project, IProgressMonitor monitor) {
    }

    public void updateProject(ToBeBuilt toBeBuilt, IProject project, IProgressMonitor monitor) throws CoreException {
    }

    public boolean updateStorage(ToBeBuilt toBeBuilt, IStorage storage, IProgressMonitor monitor) {
        IFile file;
        if (storage instanceof IFile && "package.json".equals((file = (IFile)storage).getName())) {
            IN4JSEclipseProject project = (IN4JSEclipseProject)this.eclipseCore.create(file.getProject()).orNull();
            if (project != null && project.exists()) {
                ImmutableList<? extends IN4JSEclipseSourceContainer> sourceContainers = project.getSourceContainers();
                Set toBeUpdated = toBeBuilt.getToBeUpdated();
                for (IN4JSEclipseSourceContainer sourceContainer : sourceContainers) {
                    Iterator iterator = sourceContainer.iterator();
                    while (iterator.hasNext()) {
                        URI uri = (URI)iterator.next();
                        if (!this.uriValidator.canBuild(uri, (IStorage)new URIBasedStorage(uri))) continue;
                        toBeUpdated.add(uri);
                    }
                }
            }
            IProject resourceProject = file.getProject();
            String projectName = resourceProject.getName();
            Set toBeDeleted = toBeBuilt.getToBeDeleted();
            for (IResourceDescription description : this.builderState.getAllResourceDescriptions()) {
                URI uri = description.getURI();
                if (!uri.isPlatformResource() || !projectName.equals(uri.segment(1))) continue;
                toBeDeleted.add(uri);
            }
            return false;
        }
        return false;
    }

    public boolean removeStorage(ToBeBuilt toBeBuilt, IStorage storage, IProgressMonitor monitor) {
        return false;
    }

    public boolean isPossiblyHandled(IStorage storage) {
        return false;
    }

    public boolean isRejected(IFolder folder) {
        if (folder.getName().equals("node_modules")) {
            return true;
        }
        Optional<? extends IN4JSSourceContainer> sourceContainerOpt = this.eclipseCore.create(folder);
        return !sourceContainerOpt.isPresent();
    }
}

