/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.n4js.scoping.members.ComposedMemberInfo;
import org.eclipse.n4js.scoping.members.MemberFactory;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.utils.TypeUtils;

abstract class MethodFactory
implements MemberFactory {
    final ComposedMemberInfo cma;
    final List<MethodFParFactory> fpas = new LinkedList<MethodFParFactory>();

    MethodFactory(ComposedMemberInfo cma) {
        this.cma = cma;
        List<ComposedMemberInfo.ComposedFParInfo> fpars = cma.getFParAggregates();
        int fparIdx = 0;
        while (fparIdx < fpars.size()) {
            ComposedMemberInfo.ComposedFParInfo curr = fpars.get(fparIdx);
            this.fpas.add(this.getFParFactory(curr));
            ++fparIdx;
        }
    }

    abstract MemberAccessModifier getAccessability();

    abstract MethodFParFactory getFParFactory(ComposedMemberInfo.ComposedFParInfo var1);

    abstract TypeRef getReturnTypeRefComposition();

    abstract TypeRef getFParTypeRefComposition(List<TypeRef> var1);

    @Override
    public boolean isValid() {
        if (this.cma.isEmpty()) {
            return false;
        }
        for (MethodFParFactory fpa : this.fpas) {
            if (fpa.isValid()) continue;
            return false;
        }
        return true;
    }

    public TMethod create(String name) {
        boolean variFparNecessary;
        TMethod method = TypesFactory.eINSTANCE.createTMethod();
        method.setComposed(true);
        method.setDeclaredMemberAccessModifier(this.getAccessability());
        method.setName(name);
        TypeUtils.setMemberTypeRef((TMember)method, (TypeRef)this.getReturnTypeRefComposition());
        if (!this.fpas.isEmpty() && (variFparNecessary = this.cma.isVariadicButLastFParIsDifferent())) {
            List<ComposedMemberInfo.ComposedFParInfo> fpAggrs = this.cma.getFParAggregates();
            ComposedMemberInfo.ComposedFParInfo lastFPAggr = fpAggrs.get(this.cma.getFParAggregates().size() - 1);
            List<TypeRef> variadicTypeRefs = lastFPAggr.getTypeRefsVariadicAccumulated();
            NewLastVariadicFPar varpar = new NewLastVariadicFPar(variadicTypeRefs);
            this.fpas.add(varpar);
        }
        for (MethodFParFactory currFparDesc : this.fpas) {
            TFormalParameter tFPar = currFparDesc.create();
            method.getFpars().add((Object)tFPar);
        }
        return method;
    }

    static abstract class FParFactory {
        FParFactory() {
        }

        abstract String getName();

        abstract List<TypeRef> getTypeRefs();

        abstract TypeRef getFParTypeRefComposition(List<TypeRef> var1);

        boolean isOptional() {
            return false;
        }

        boolean isValid() {
            return true;
        }

        boolean isVariadic() {
            return false;
        }

        TFormalParameter create() {
            TypeRef paramCompTR1;
            TFormalParameter fpar = TypesFactory.eINSTANCE.createTFormalParameter();
            fpar.setName(this.getName());
            List<TypeRef> typeRefsToUse = this.getTypeRefs();
            TypeRef paramCompTR = paramCompTR1 = this.getFParTypeRefComposition(typeRefsToUse);
            fpar.setTypeRef(paramCompTR);
            fpar.setVariadic(this.isVariadic());
            fpar.setHasInitializerAssignment(this.isOptional());
            return fpar;
        }
    }

    static class IntersectionMethodFactory
    extends MethodFactory {
        IntersectionMethodFactory(ComposedMemberInfo cma) {
            super(cma);
        }

        @Override
        MemberAccessModifier getAccessability() {
            return this.cma.getAccessabilityMax();
        }

        @Override
        MethodFParFactory getFParFactory(ComposedMemberInfo.ComposedFParInfo fpa) {
            return new IntersectionFPar(fpa);
        }

        @Override
        TypeRef getReturnTypeRefComposition() {
            List<TypeRef> typeRefs = this.cma.getMethodTypeRefsNonVoid();
            if (typeRefs.isEmpty()) {
                typeRefs.addAll(this.cma.getMethodTypeRefsVoid());
            }
            return this.cma.getTypeSystem().createSimplifiedIntersection(typeRefs, this.cma.getResource());
        }

        @Override
        protected TypeRef getFParTypeRefComposition(List<TypeRef> typeRefsToUse) {
            return this.cma.getTypeSystem().createSimplifiedUnion(typeRefsToUse, this.cma.getResource());
        }

        @Override
        public List<TMember> getConstituentMembers() {
            return this.cma.getConstituentMembers();
        }

        class IntersectionFPar
        extends MethodFParFactory {
            IntersectionFPar(ComposedMemberInfo.ComposedFParInfo fpa) {
                super(fpa);
            }

            @Override
            protected boolean isOptional() {
                if (this.isVariadic()) {
                    return false;
                }
                if (!this.fpa.allNonOptional()) {
                    return true;
                }
                MethodFParFactory prevFpar = this.getPrev();
                if (prevFpar != null) {
                    return prevFpar.isOptional();
                }
                return false;
            }
        }
    }

    abstract class MethodFParFactory
    extends FParFactory {
        final ComposedMemberInfo.ComposedFParInfo fpa;
        final int index;

        MethodFParFactory(ComposedMemberInfo.ComposedFParInfo fpa) {
            this.fpa = fpa;
            this.index = MethodFactory.this.cma.getFParAggregates().indexOf(fpa);
        }

        @Override
        abstract boolean isOptional();

        @Override
        TypeRef getFParTypeRefComposition(List<TypeRef> typeRefsToUse) {
            return MethodFactory.this.getFParTypeRefComposition(typeRefsToUse);
        }

        @Override
        String getName() {
            return this.fpa.getName();
        }

        @Override
        List<TypeRef> getTypeRefs() {
            LinkedList<TypeRef> typeRefsToUse = new LinkedList<TypeRef>();
            typeRefsToUse.addAll(this.fpa.getTypeRefs());
            typeRefsToUse.addAll(this.fpa.getTypeRefsVariadicAccumulated());
            return typeRefsToUse;
        }

        @Override
        boolean isValid() {
            if (this.fpa == null) {
                return false;
            }
            return !this.fpa.hasValidationProblem();
        }

        MethodFParFactory getPrev() {
            if (this.index <= 0) {
                return null;
            }
            return MethodFactory.this.fpas.get(this.index - 1);
        }

        MethodFParFactory getNext() {
            if (this.index + 1 >= MethodFactory.this.fpas.size()) {
                return null;
            }
            return MethodFactory.this.fpas.get(this.index + 1);
        }

        boolean isLast() {
            return this.index == MethodFactory.this.fpas.size() - 1;
        }

        @Override
        boolean isVariadic() {
            return this.isLast() && !this.fpa.getTypeRefsVariadicAccumulated().isEmpty();
        }
    }

    class NewLastVariadicFPar
    extends MethodFParFactory {
        private final String name = "vari";
        private final List<TypeRef> typeRefs;

        NewLastVariadicFPar(List<TypeRef> typeRefs) {
            super(null);
            this.name = "vari";
            this.typeRefs = typeRefs;
        }

        @Override
        String getName() {
            return "vari";
        }

        @Override
        List<TypeRef> getTypeRefs() {
            return this.typeRefs;
        }

        @Override
        boolean isOptional() {
            return false;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        boolean isVariadic() {
            return true;
        }
    }

    static class UnionMethodFactory
    extends MethodFactory {
        UnionMethodFactory(ComposedMemberInfo cma) {
            super(cma);
        }

        @Override
        MemberAccessModifier getAccessability() {
            return this.cma.getAccessabilityMin();
        }

        @Override
        MethodFParFactory getFParFactory(ComposedMemberInfo.ComposedFParInfo fpa) {
            return new UnionFPar(fpa);
        }

        @Override
        TypeRef getReturnTypeRefComposition() {
            List<TypeRef> typeRefs = this.cma.getMethodTypeRefsVoid();
            if (typeRefs.isEmpty()) {
                typeRefs.addAll(this.cma.getMethodTypeRefsNonVoid());
            }
            return this.cma.getTypeSystem().createSimplifiedUnion(typeRefs, this.cma.getResource());
        }

        @Override
        protected TypeRef getFParTypeRefComposition(List<TypeRef> typeRefsToUse) {
            return this.cma.getTypeSystem().createSimplifiedIntersection(typeRefsToUse, this.cma.getResource());
        }

        @Override
        public List<TMember> getConstituentMembers() {
            return this.cma.getConstituentMembers();
        }

        class UnionFPar
        extends MethodFParFactory {
            UnionFPar(ComposedMemberInfo.ComposedFParInfo fpa) {
                super(fpa);
            }

            @Override
            protected boolean isOptional() {
                if (this.isVariadic()) {
                    return false;
                }
                if (this.fpa.allOptional()) {
                    return true;
                }
                MethodFParFactory prevFpar = this.getPrev();
                if (prevFpar != null) {
                    return prevFpar.isOptional();
                }
                return false;
            }
        }
    }
}

