/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xpect.util.IJavaReflectAccess;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmIntAnnotationValue;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeReference;

public class JvmAnnotationUtil {
    private static Logger logger = Logger.getLogger(JvmAnnotationUtil.class);

    public static JvmAnnotationReference getAnnotation(JvmAnnotationTarget target, Class<? extends Annotation> ann) {
        if (target instanceof JvmDeclaredType) {
            return JvmAnnotationUtil.getAnnotation((JvmDeclaredType)target, ann);
        }
        for (JvmAnnotationReference ref : target.getAnnotations()) {
            JvmAnnotationType annotation = ref.getAnnotation();
            if (annotation == null || annotation.eIsProxy() || !annotation.getQualifiedName().equals(ann.getName())) continue;
            return ref;
        }
        return null;
    }

    public static JvmAnnotationReference getAnnotation(JvmDeclaredType type, Class<? extends Annotation> ann) {
        if (type == null || type.eIsProxy()) {
            return null;
        }
        HashSet visited = Sets.newHashSet((Object[])new JvmDeclaredType[]{type});
        Stack<JvmDeclaredType> unvisited = new Stack<JvmDeclaredType>();
        unvisited.push(type);
        while (!unvisited.isEmpty()) {
            JvmDeclaredType current = (JvmDeclaredType)unvisited.pop();
            for (JvmAnnotationReference ref : current.getAnnotations()) {
                JvmAnnotationType annotation = ref.getAnnotation();
                if (annotation == null || annotation.eIsProxy() || !annotation.getQualifiedName().equals(ann.getName())) continue;
                return ref;
            }
            for (JvmAnnotationReference ref : current.getSuperTypes()) {
                JvmDeclaredType t;
                if (!(ref.getType() instanceof JvmDeclaredType) || ref.getType().eIsProxy() || !visited.add(t = (JvmDeclaredType)ref.getType())) continue;
                unvisited.push(t);
            }
        }
        return null;
    }

    public static List<JvmDeclaredType> getAnnotationTypeValue(JvmAnnotationReference reference) {
        JvmTypeAnnotationValue value = JvmAnnotationUtil.getAnnotationValue(reference, null, JvmTypeAnnotationValue.class);
        ArrayList result = Lists.newArrayList();
        if (value != null) {
            for (JvmTypeReference ref : value.getValues()) {
                if (ref == null || ref.eIsProxy() || !(ref.getType() instanceof JvmDeclaredType) || ref.getType().eIsProxy()) continue;
                result.add((JvmDeclaredType)ref.getType());
            }
        }
        return result;
    }

    public static List<JvmDeclaredType> getAnnotationTypeValue(JvmAnnotationTarget target, Class<? extends Annotation> ann) {
        return JvmAnnotationUtil.getAnnotationTypeValue(JvmAnnotationUtil.getAnnotation(target, ann));
    }

    public static <A extends JvmAnnotationValue> A getAnnotationValue(JvmAnnotationReference reference, Class<A> c) {
        return JvmAnnotationUtil.getAnnotationValue(reference, null, c);
    }

    public static <A extends JvmAnnotationValue> A getAnnotationValue(JvmAnnotationReference reference, String n, Class<A> c) {
        if (reference != null && !reference.eIsProxy()) {
            for (JvmAnnotationValue value : reference.getValues()) {
                if (n != null && !n.equals(value.getValueName()) || !c.isInstance(value)) continue;
                return (A)value;
            }
        }
        return null;
    }

    public static <A extends JvmAnnotationValue> A getAnnotationValue(JvmAnnotationTarget type, Class<? extends Annotation> ann, Class<A> c) {
        return JvmAnnotationUtil.getAnnotationValue(type, ann, null, c);
    }

    public static <A extends JvmAnnotationValue> A getAnnotationValue(JvmAnnotationTarget t, Class<? extends Annotation> a, String n, Class<A> c) {
        return JvmAnnotationUtil.getAnnotationValue(JvmAnnotationUtil.getAnnotation(t, a), n, c);
    }

    public static Annotation getJavaAnnotation(final JvmAnnotationReference ref) {
        final Class<?> annotation = IJavaReflectAccess.INSTANCE.getRawType((JvmType)ref.getAnnotation());
        if (annotation == null) {
            return null;
        }
        return (Annotation)Proxy.newProxyInstance(annotation.getClassLoader(), new Class[]{annotation}, new InvocationHandler(){

            protected Object getValue(JvmAnnotationValue value) {
                if (value instanceof JvmStringAnnotationValue) {
                    return ((JvmStringAnnotationValue)value).getValues().get(0);
                }
                if (value instanceof JvmBooleanAnnotationValue) {
                    return ((JvmBooleanAnnotationValue)value).getValues().get(0);
                }
                if (value instanceof JvmIntAnnotationValue) {
                    return ((JvmIntAnnotationValue)value).getValues().get(0);
                }
                if (value instanceof JvmTypeAnnotationValue) {
                    return IJavaReflectAccess.INSTANCE.getRawType(((JvmTypeReference)((JvmTypeAnnotationValue)value).getValues().get(0)).getType());
                }
                if (value instanceof JvmEnumAnnotationValue) {
                    return this.getValue((JvmEnumAnnotationValue)value);
                }
                throw new RuntimeException("Unhandled annotation value type: " + value.eClass().getName());
            }

            private Object getValue(JvmEnumAnnotationValue annotationValue) {
                EList values = annotationValue.getValues();
                JvmTypeReference type = annotationValue.getOperation().getReturnType();
                if (type instanceof JvmGenericArrayTypeReference) {
                    JvmType componentType = ((JvmGenericArrayTypeReference)type).getComponentType().getType();
                    Class<?> rawType = IJavaReflectAccess.INSTANCE.getRawType(componentType);
                    Object[] result = (Object[])Array.newInstance(rawType, values.size());
                    int i = 0;
                    while (i < values.size()) {
                        result[i] = this.getValue((JvmEnumerationLiteral)values.get(i));
                        ++i;
                    }
                    return result;
                }
                if (values.isEmpty()) {
                    return null;
                }
                return this.getValue((JvmEnumerationLiteral)values.get(0));
            }

            private Object getValue(JvmEnumerationLiteral value) {
                Field field = IJavaReflectAccess.INSTANCE.getField((JvmField)value);
                if (field != null && field.isEnumConstant()) {
                    try {
                        return field.get(null);
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new RuntimeException();
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                for (JvmAnnotationValue value : ref.getValues()) {
                    if (!value.getValueName().equals(method.getName())) continue;
                    return this.getValue(value);
                }
                if ("toString".equals(method.getName())) {
                    return ref.toString();
                }
                if ("hashCode".equals(method.getName())) {
                    return ref.hashCode();
                }
                if ("equals".equals(method.getName())) {
                    return ref.equals(args[0]);
                }
                if ("annotationType".equals(method.getName())) {
                    return annotation;
                }
                throw new RuntimeException("method '" + method.getName() + "' not found in " + ref.getAnnotation().getIdentifier());
            }
        });
    }

    public static <T extends Annotation> T getJavaAnnotation(JvmAnnotationTarget type, Class<T> ann) {
        if (type == null || type.eIsProxy()) {
            return null;
        }
        for (JvmAnnotationReference ref : type.getAnnotations()) {
            JvmAnnotationType annotation = ref.getAnnotation();
            if (annotation == null || annotation.eIsProxy() || !ann.getName().equals(annotation.getQualifiedName())) continue;
            return (T)((Annotation)ann.cast(JvmAnnotationUtil.getJavaAnnotation(ref)));
        }
        return null;
    }

    public static List<? extends Annotation> getJavaAnnotationsViaMetaAnnotation(JvmAnnotationTarget type, Class<? extends Annotation> ann) {
        if (type == null || type.eIsProxy()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (JvmAnnotationReference ref : type.getAnnotations()) {
            Annotation param;
            JvmAnnotationReference metaAnnotation;
            JvmAnnotationType annotation = ref.getAnnotation();
            if (annotation == null || annotation.eIsProxy() || (metaAnnotation = JvmAnnotationUtil.getAnnotation((JvmDeclaredType)annotation, ann)) == null || metaAnnotation.eIsProxy() || (param = JvmAnnotationUtil.getJavaAnnotation(ref)) == null) continue;
            result.add(param);
        }
        return ImmutableList.copyOf((Collection)result);
    }

    public static boolean isAnnotatedWith(JvmAnnotationTarget target, Class<? extends Annotation> annotation) {
        for (JvmAnnotationReference ref : target.getAnnotations()) {
            JvmAnnotationType type = ref.getAnnotation();
            if (type == null || type.eIsProxy() || !type.getQualifiedName().equals(annotation.getName())) continue;
            return true;
        }
        return false;
    }

    public static <T> T newInstanceFromAnnotation(JvmAnnotationTarget type, Class<T> expected, Class<? extends Annotation> ann) {
        List<T> list = JvmAnnotationUtil.newInstancesViaAnnotation(type, expected, ann);
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    public static <T> List<T> newInstancesViaAnnotation(JvmAnnotationTarget type, Class<T> expected, Class<? extends Annotation> ann) {
        if (type == null || type.eIsProxy()) {
            return Collections.emptyList();
        }
        JvmTypeAnnotationValue value = JvmAnnotationUtil.getAnnotationValue(type, ann, JvmTypeAnnotationValue.class);
        if (value == null || value.getValues().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (JvmTypeReference ref : value.getValues()) {
            Class<?> adapter;
            if (ref == null || ref.eIsProxy() || ref.getType() == null || ref.getType().eIsProxy() || (adapter = IJavaReflectAccess.INSTANCE.getRawType(ref.getType())) == null) continue;
            try {
                Object instance = adapter.newInstance();
                if (!expected.isInstance(instance)) continue;
                result.add(instance);
            }
            catch (InstantiationException e) {
                logger.error((Object)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
            }
        }
        return result;
    }

    public static <T> List<T> newInstancesViaMetaAnnotation(JvmAnnotationTarget type, Class<T> expected, Class<? extends Annotation> ann) {
        if (type == null || type.eIsProxy()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        block6: for (JvmAnnotationReference ref : type.getAnnotations()) {
            JvmTypeAnnotationValue value;
            if (ref.getAnnotation() == null || ref.getAnnotation().eIsProxy() || (value = JvmAnnotationUtil.getAnnotationValue((JvmAnnotationTarget)ref.getAnnotation(), ann, JvmTypeAnnotationValue.class)) == null || value.getValues().isEmpty()) continue;
            block7: for (JvmTypeReference val : value.getValues()) {
                Class<?> adapter;
                if (val == null || val.eIsProxy() || val.getType() == null || val.getType().eIsProxy() || (adapter = IJavaReflectAccess.INSTANCE.getRawType(val.getType())) == null) continue;
                try {
                    Annotation param = JvmAnnotationUtil.getJavaAnnotation(ref);
                    if (param == null) {
                        logger.error((Object)("Coult not load " + ref));
                        continue block6;
                    }
                    Constructor<?>[] constructorArray = adapter.getConstructors();
                    int n = constructorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Constructor<?> cons = constructorArray[n2];
                        Class<?>[] parameterTypes = cons.getParameterTypes();
                        if (parameterTypes.length == 1 && parameterTypes[0].isInstance(param)) {
                            Object instance = cons.newInstance(param);
                            if (!expected.isInstance(instance)) continue block7;
                            result.add(instance);
                            continue block7;
                        }
                        ++n2;
                    }
                }
                catch (InstantiationException e) {
                    logger.error((Object)e);
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)e);
                }
                catch (SecurityException e) {
                    logger.error((Object)e);
                }
                catch (IllegalArgumentException e) {
                    logger.error((Object)e);
                }
                catch (InvocationTargetException e) {
                    logger.error((Object)e);
                }
            }
        }
        return result;
    }
}

