/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.n4js.ui.external.EclipseExternalIndexSynchronizer;
import org.eclipse.n4js.ui.external.ExternalLibraryBuilder;

public class ProjectStateChangeListener
implements IResourceChangeListener {
    private static final Logger logger = Logger.getLogger(ProjectStateChangeListener.class);
    @Inject
    private EclipseExternalIndexSynchronizer indexSynchronizer;
    @Inject
    private ExternalLibraryBuilder builder;
    private final Collection<IProject> projectsChanged = Sets.newLinkedHashSet();

    public void resourceChanged(IResourceChangeEvent event) {
        if (event == null || event.getDelta() == null) {
            return;
        }
        try {
            this.projectsChanged.clear();
            event.getDelta().accept(this::visit);
            if (!this.projectsChanged.isEmpty()) {
                Job job = new Job("Update locations of node_modules folders"){

                    protected IStatus run(IProgressMonitor monitor) {
                        ISchedulingRule rule = ProjectStateChangeListener.this.builder.getRule();
                        Job.getJobManager().beginRule(rule, monitor);
                        try {
                            ProjectStateChangeListener.this.indexSynchronizer.checkAndClearIndex(monitor);
                        }
                        finally {
                            Job.getJobManager().endRule(rule);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
        catch (CoreException e) {
            logger.error((Object)"Error while visiting resource change event.", (Throwable)e);
        }
    }

    boolean visit(IResourceDelta delta) {
        if (this.projectChanged(delta)) {
            IResource resource = delta.getResource();
            String name = resource.getName();
            if (resource instanceof IProject && !"RemoteSystemsTempFiles".equals(name)) {
                IProject project = (IProject)resource;
                this.projectsChanged.add(project);
            }
        }
        return true;
    }

    private boolean projectChanged(IResourceDelta delta) {
        int kind = delta.getKind();
        int flags = delta.getFlags();
        switch (kind) {
            case 1: 
            case 2: {
                return true;
            }
            case 4: {
                if ((flags & 0x4000) == 0) break;
                return true;
            }
        }
        return false;
    }
}

