/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.events;

import java.util.function.Consumer;
import org.eclipse.n4js.tester.domain.TestResult;
import org.eclipse.n4js.tester.domain.TestStatus;
import org.eclipse.n4js.tester.events.TestEndedEvent;
import org.eclipse.n4js.utils.ThrowingConsumer;

public final class TestEndedEventDispatcher<E extends Exception>
implements ThrowingConsumer<TestEndedEvent, E> {
    private final Consumer<TestEndedEvent> passed;
    private final Consumer<TestEndedEvent> skipped;
    private final Consumer<TestEndedEvent> notimplemented;
    private final Consumer<TestEndedEvent> precondition;
    private final Consumer<TestEndedEvent> ignore;
    private final Consumer<TestEndedEvent> fixmme;
    private final Consumer<TestEndedEvent> failed;
    private final Consumer<TestEndedEvent> error;
    private final ThrowingConsumer<TestEndedEvent, E> unhandled;

    public TestEndedEventDispatcher(Consumer<TestEndedEvent> passedConsumer, Consumer<TestEndedEvent> skippedConsumer, Consumer<TestEndedEvent> failedConsumer, ThrowingConsumer<TestEndedEvent, E> unhandled) {
        this.passed = passedConsumer;
        this.skipped = skippedConsumer;
        this.notimplemented = skippedConsumer;
        this.precondition = skippedConsumer;
        this.ignore = skippedConsumer;
        this.fixmme = skippedConsumer;
        this.failed = failedConsumer;
        this.error = failedConsumer;
        this.unhandled = unhandled;
    }

    public void accept(TestEndedEvent tee) throws E {
        TestResult result = tee.getResult();
        TestStatus status = result.getTestStatus();
        switch (status) {
            case PASSED: {
                this.passed.accept(tee);
                return;
            }
            case SKIPPED: {
                this.skipped.accept(tee);
                return;
            }
            case SKIPPED_NOT_IMPLEMENTED: {
                this.notimplemented.accept(tee);
                return;
            }
            case SKIPPED_PRECONDITION: {
                this.precondition.accept(tee);
                return;
            }
            case SKIPPED_IGNORE: {
                this.ignore.accept(tee);
                return;
            }
            case SKIPPED_FIXME: {
                this.fixmme.accept(tee);
                return;
            }
            case FAILED: {
                this.failed.accept(tee);
                return;
            }
            case ERROR: {
                this.error.accept(tee);
                return;
            }
        }
        this.unhandled.accept((Object)tee);
    }
}

