/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem.utils;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.GetterDeclaration;
import org.eclipse.n4js.n4JS.YieldExpression;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelperStrategy;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
class ExpectedTypeComputer
extends TypeSystemHelperStrategy {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private TypeSystemHelper tsh;

    ExpectedTypeComputer() {
    }

    public TypeRef getExpectedTypeOfReturnValueExpression(RuleEnvironment G, Expression returnValueExpr) {
        EObject _eContainer = null;
        if (returnValueExpr != null) {
            _eContainer = returnValueExpr.eContainer();
        }
        FunctionOrFieldAccessor fofa = (FunctionOrFieldAccessor)EcoreUtil2.getContainerOfType((EObject)_eContainer, FunctionOrFieldAccessor.class);
        RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(G);
        TypeRef myThisTypeRef = this.tsh.getThisTypeAtLocation(G, (EObject)returnValueExpr);
        RuleEnvironmentExtensions.addThisType(G2, myThisTypeRef);
        return this.getExpectedTypeOfFunctionOrFieldAccessor(G2, fofa);
    }

    public TypeRef getExpectedTypeOfFunctionOrFieldAccessor(RuleEnvironment G, FunctionOrFieldAccessor fofa) {
        RuleEnvironment _xifexpression = null;
        _xifexpression = G == null ? RuleEnvironmentExtensions.newRuleEnvironment((EObject)fofa) : G;
        RuleEnvironment G2 = _xifexpression;
        if (fofa instanceof FunctionDefinition) {
            boolean _isAsync = ((FunctionDefinition)fofa).isAsync();
            if (_isAsync) {
                return this.getExpectedTypeOfReturnValueExpressionForAsyncFunction(G2, (FunctionDefinition)fofa);
            }
            boolean _isGenerator = ((FunctionDefinition)fofa).isGenerator();
            if (_isGenerator) {
                return this.getExpectedTypeOfReturnValueExpressionForGeneratorFunction(G2, (FunctionDefinition)fofa);
            }
            TypeRef fType = this.ts.type(G2, (TypableElement)fofa);
            if (fType instanceof FunctionTypeExprOrRef) {
                return this.ts.substTypeVariables(G2, ((FunctionTypeExprOrRef)fType).getReturnTypeRef());
            }
        } else if (fofa instanceof GetterDeclaration) {
            TGetter _definedGetter = null;
            if ((GetterDeclaration)fofa != null) {
                _definedGetter = ((GetterDeclaration)fofa).getDefinedGetter();
            }
            TypeRef _declaredTypeRef = null;
            if (_definedGetter != null) {
                _declaredTypeRef = _definedGetter.getDeclaredTypeRef();
            }
            return _declaredTypeRef;
        }
        return null;
    }

    private TypeRef getExpectedTypeOfReturnValueExpressionForAsyncFunction(RuleEnvironment G, FunctionDefinition funDef) {
        boolean _tripleNotEquals;
        TypeArgument firstTypeArg;
        TypeRef actualReturnTypeRef;
        boolean _isPromise;
        Type tFun = funDef.getDefinedType();
        if (tFun instanceof TFunction && (_isPromise = TypeUtils.isPromise((TypeRef)(actualReturnTypeRef = ((TFunction)tFun).getReturnTypeRef()), (BuiltInTypeScope)RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope)) && (firstTypeArg = (TypeArgument)IterableExtensions.head((Iterable)actualReturnTypeRef.getTypeArgs())) != null) {
            return this.ts.upperBound(G, firstTypeArg);
        }
        TypeRef _returnTypeRef = funDef.getReturnTypeRef();
        boolean bl = _tripleNotEquals = _returnTypeRef != null;
        if (_tripleNotEquals) {
            return funDef.getReturnTypeRef();
        }
        return null;
    }

    private TypeRef getExpectedTypeOfReturnValueExpressionForGeneratorFunction(RuleEnvironment G, FunctionDefinition funDef) {
        boolean _tripleNotEquals;
        TypeRef actualReturnTypeRef;
        boolean _isGenerator;
        TFunction tFun = funDef.getDefinedFunction();
        if (tFun != null && (_isGenerator = TypeUtils.isGenerator((TypeRef)(actualReturnTypeRef = tFun.getReturnTypeRef()), (BuiltInTypeScope)RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope))) {
            return this.tsh.getGeneratorTReturn(G, actualReturnTypeRef);
        }
        TypeRef _returnTypeRef = funDef.getReturnTypeRef();
        boolean bl = _tripleNotEquals = _returnTypeRef != null;
        if (_tripleNotEquals) {
            return funDef.getReturnTypeRef();
        }
        return null;
    }

    public TypeRef getExpectedTypeOfYieldValueExpression(RuleEnvironment G, YieldExpression yieldExpr, TypeRef exprTypeRef) {
        BuiltInTypeScope scope;
        TypeRef actualReturnTypeRef;
        boolean _isGenerator;
        Expression expression = yieldExpr.getExpression();
        EObject _eContainer = null;
        if (expression != null) {
            _eContainer = expression.eContainer();
        }
        FunctionDefinition funDef = (FunctionDefinition)EcoreUtil2.getContainerOfType((EObject)_eContainer, FunctionDefinition.class);
        RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(G);
        TypeRef myThisTypeRef = this.tsh.getThisTypeAtLocation(G, (EObject)expression);
        RuleEnvironmentExtensions.addThisType(G2, myThisTypeRef);
        if (funDef == null || !funDef.isGenerator()) {
            return null;
        }
        TFunction tFun = funDef.getDefinedFunction();
        if (tFun != null && (_isGenerator = TypeUtils.isGenerator((TypeRef)(actualReturnTypeRef = tFun.getReturnTypeRef()), (BuiltInTypeScope)(scope = RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)G).builtInTypeScope)))) {
            TypeRef yieldTypeRef = this.tsh.getGeneratorTYield(G, actualReturnTypeRef);
            TypeRef yieldTypeRefCopy = (TypeRef)TypeUtils.copyWithProxies((EObject)yieldTypeRef);
            boolean _isMany = yieldExpr.isMany();
            if (_isMany) {
                boolean isGenerator = TypeUtils.isGenerator((TypeRef)exprTypeRef, (BuiltInTypeScope)scope);
                if (isGenerator) {
                    TypeRef nextTypeRef = this.tsh.getGeneratorTNext(G, actualReturnTypeRef);
                    TypeRef nextTypeRefCopy = (TypeRef)TypeUtils.copyWithProxies((EObject)nextTypeRef);
                    Wildcard superNext = TypeUtils.createWildcardSuper((TypeRef)nextTypeRefCopy);
                    Wildcard extendsYield = TypeUtils.createWildcardExtends((TypeRef)yieldTypeRefCopy);
                    ParameterizedTypeRef tReturn = scope.getAnyTypeRef();
                    ParameterizedTypeRef recursiveGeneratorSuperType = TypeUtils.createGeneratorTypeRef((BuiltInTypeScope)scope, (TypeArgument)extendsYield, (TypeArgument)tReturn, (TypeArgument)superNext);
                    return recursiveGeneratorSuperType;
                }
                ParameterizedTypeRef iterableTypeRef = RuleEnvironmentExtensions.iterableTypeRef(G, new TypeArgument[]{yieldTypeRefCopy});
                return iterableTypeRef;
            }
            return yieldTypeRefCopy;
        }
        return null;
    }
}

