/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysers;

import com.google.common.collect.Multimap;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.analysers.NullDereferenceResult;
import org.eclipse.n4js.flowgraphs.analysers.NullDerefernceFailed;
import org.eclipse.n4js.flowgraphs.dataflow.Assumption;
import org.eclipse.n4js.flowgraphs.dataflow.DataFlowVisitor;
import org.eclipse.n4js.flowgraphs.dataflow.EffectInfo;
import org.eclipse.n4js.flowgraphs.dataflow.EffectType;
import org.eclipse.n4js.flowgraphs.dataflow.PartialResult;
import org.eclipse.n4js.flowgraphs.dataflow.guards.Guard;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardAssertion;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardType;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.Symbol;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.NullLiteral;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;

public class NullDereferenceAnalyser
extends DataFlowVisitor {
    @Override
    public void visitEffect(EffectInfo effect, ControlFlowElement cfe) {
        Symbol tgtSymbol;
        if (this.isDereferencing(cfe) && (tgtSymbol = this.getSymbolFactory().create(cfe)) != null) {
            IsNotNull symbolNotNull = new IsNotNull(cfe, tgtSymbol);
            this.assume(symbolNotNull);
        }
    }

    @Override
    public void visitGuard(Guard guard) {
        if (guard.asserts != GuardAssertion.MayHolds && guard.type == GuardType.IsNull) {
            IsReasonableNullGuard isReasonableNullGuard = new IsReasonableNullGuard(guard);
            this.assume(isReasonableNullGuard);
        }
    }

    private boolean isDereferencing(ControlFlowElement cfe) {
        EObject parent = cfe.eContainer();
        if (parent instanceof ParameterizedPropertyAccessExpression) {
            ParameterizedPropertyAccessExpression ppae = (ParameterizedPropertyAccessExpression)parent;
            Expression target = ppae.getTarget();
            return cfe == target;
        }
        return false;
    }

    public Iterable<NullDereferenceResult> getNullDereferences() {
        HashSet<NullDereferenceResult> nullDerefs = new HashSet<NullDereferenceResult>();
        for (Assumption ass : this.failedAssumptions.values()) {
            IsNotNull inn = (IsNotNull)ass;
            ControlFlowElement astLocation = inn.creationSite;
            NullDereferenceResult ndr = new NullDereferenceResult(astLocation, inn);
            nullDerefs.add(ndr);
        }
        return nullDerefs;
    }

    class IsNotNull
    extends Assumption {
        IsNotNull(ControlFlowElement cfe, Symbol symbol) {
            super(cfe, symbol);
        }

        IsNotNull(IsNotNull copy) {
            super(copy);
        }

        @Override
        public Assumption copy() {
            return new IsNotNull(this);
        }

        @Override
        public PartialResult holdsOnDataflow(Symbol lhs, Symbol rSymbol, Expression rValue) {
            if (rSymbol != null) {
                if (rSymbol.isNullLiteral() && !this.guardsThatNeverHold.containsKey((Object)GuardType.IsNull)) {
                    return new NullDerefernceFailed(GuardType.IsNull, lhs);
                }
                if (rSymbol.isUndefinedLiteral() && !this.guardsThatNeverHold.containsKey((Object)GuardType.IsUndefined)) {
                    return new NullDerefernceFailed(GuardType.IsUndefined, lhs);
                }
            } else if (rValue != null) {
                return PartialResult.Passed;
            }
            return PartialResult.Unclear;
        }

        @Override
        public PartialResult holdsOnGuards(Multimap<GuardType, Guard> neverHolding, Multimap<GuardType, Guard> alwaysHolding) {
            if (alwaysHolding.containsKey((Object)GuardType.IsTruthy)) {
                return PartialResult.Passed;
            }
            if (neverHolding.containsKey((Object)GuardType.IsNull) && neverHolding.containsKey((Object)GuardType.IsUndefined)) {
                return PartialResult.Passed;
            }
            if (alwaysHolding.containsKey((Object)GuardType.IsNull)) {
                return new NullDerefernceFailed(GuardType.IsNull);
            }
            if (alwaysHolding.containsKey((Object)GuardType.IsUndefined)) {
                return new NullDerefernceFailed(GuardType.IsUndefined);
            }
            return PartialResult.Unclear;
        }
    }

    static class IsReasonableNullGuard
    extends Assumption {
        private boolean alwaysNullBefore = false;
        private boolean neverNullBefore = false;

        IsReasonableNullGuard(Guard guard) {
            this((ControlFlowElement)guard.condition, guard.getSymbol(), false, false);
        }

        IsReasonableNullGuard(ControlFlowElement cfe, Symbol symbol, boolean alwaysNullBefore, boolean alwaysNotNullBefore) {
            super(cfe, symbol);
            this.alwaysNullBefore = alwaysNullBefore;
            this.neverNullBefore = alwaysNotNullBefore;
        }

        IsReasonableNullGuard(IsReasonableNullGuard copy) {
            super(copy);
            this.alwaysNullBefore = copy.alwaysNullBefore;
            this.neverNullBefore = copy.neverNullBefore;
        }

        @Override
        public Assumption copy() {
            return new IsReasonableNullGuard(this);
        }

        @Override
        public void mergeClientData(Assumption assumption) {
            IsReasonableNullGuard irng = (IsReasonableNullGuard)assumption;
            this.alwaysNullBefore |= irng.alwaysNullBefore;
            this.neverNullBefore |= irng.neverNullBefore;
        }

        @Override
        public PartialResult holdsOnEffect(EffectInfo effect, ControlFlowElement cfe) {
            if (effect.type == EffectType.Write && cfe instanceof AssignmentExpression) {
                AssignmentExpression ae = (AssignmentExpression)cfe;
                if (ae.getRhs() instanceof NullLiteral) {
                    this.alwaysNullBefore = true;
                } else {
                    this.neverNullBefore = true;
                }
                return PartialResult.Passed;
            }
            return PartialResult.Unclear;
        }

        @Override
        public PartialResult holdsOnGuards(Multimap<GuardType, Guard> guardThatNeverHold, Multimap<GuardType, Guard> guardThatAlwaysHold) {
            return PartialResult.Unclear;
        }
    }
}

