/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.properties.section;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.common.ui.internal.viewers.ResourceFilter;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.dtd.core.internal.Entity;
import org.eclipse.wst.dtd.ui.internal.DTDPropertiesMessages;
import org.eclipse.wst.dtd.ui.internal.DTDUIPlugin;
import org.eclipse.wst.dtd.ui.internal.properties.section.AbstractSection;
import org.eclipse.wst.dtd.ui.internal.properties.section.DTDSelectIncludeFileWizard;

public class NewEntitySection
extends AbstractSection {
    private final String NAME = DTDPropertiesMessages._UI_LABEL_NAME;
    private final String ENTITY_TYPE = DTDPropertiesMessages._UI_LABEL_ENTITY_TYPE;
    private final String EXTERNAL_ENTITY = DTDPropertiesMessages._UI_LABEL_EXTERNAL_ENTITY;
    private final String PARAMETER = DTDPropertiesMessages._UI_LABEL_PARAMETER_ENTITY;
    private final String GENERAL = DTDPropertiesMessages._UI_LABEL_GENERAL_ENTITY;
    private final String VALUE = DTDPropertiesMessages._UI_LABEL_ENTITY_VALUE;
    private final String PUBLIC_ID = DTDPropertiesMessages._UI_LABEL_PUBLIC_ID;
    private final String SYSTEM_ID = DTDPropertiesMessages._UI_LABEL_SYSTEM_ID;
    private Text systemIdText;
    private Text publicIdText;
    private Text nameText;
    private Button wizardButton;
    private Text entityValueText;
    private Button checkBox;
    private CCombo typeCombo;
    private String[] typeComboValues = new String[]{this.PARAMETER, this.GENERAL};
    private PageBook pageBook;
    private Composite entityCommonComposite;
    private Composite internalEntityComposite;
    private Composite externalEntityComposite;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.createEntityCommonComposite(composite);
        this.pageBook = new PageBook(composite, 0x800000);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.entityCommonComposite, 0);
        data.bottom = new FormAttachment(100, 0);
        this.pageBook.setLayoutData((Object)data);
        this.createExternalEntityComposite((Composite)this.pageBook);
        this.createInternalEntityComposite((Composite)this.pageBook);
        this.pageBook.showPage((Control)this.externalEntityComposite);
    }

    private Composite createEntityCommonComposite(Composite parent) {
        this.entityCommonComposite = this.getWidgetFactory().createFlatFormComposite(parent);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        this.entityCommonComposite.setLayoutData((Object)data);
        CLabel nameLabel = this.getWidgetFactory().createCLabel(this.entityCommonComposite, this.NAME);
        Point p = nameLabel.computeSize(-1, -1, false);
        int labelWidth = Math.max(p.x, 98);
        data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        nameLabel.setLayoutData((Object)data);
        this.nameText = this.getWidgetFactory().createText(this.entityCommonComposite, "", 0);
        data = new FormData();
        data.left = new FormAttachment((Control)nameLabel, -5);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)nameLabel, 0, 0x1000000);
        this.nameText.setLayoutData((Object)data);
        this.nameText.addListener(24, (Listener)this);
        CLabel cLabel = this.getWidgetFactory().createCLabel(this.entityCommonComposite, this.ENTITY_TYPE);
        p = cLabel.computeSize(-1, -1, false);
        labelWidth = Math.max(p.x, 98);
        data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)nameLabel, 4);
        cLabel.setLayoutData((Object)data);
        this.checkBox = this.getWidgetFactory().createButton(this.entityCommonComposite, this.EXTERNAL_ENTITY, 32);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)cLabel, 0, 0x1000000);
        this.checkBox.setLayoutData((Object)data);
        this.checkBox.addSelectionListener((SelectionListener)this);
        this.typeCombo = this.getWidgetFactory().createCCombo(this.entityCommonComposite, 0x800008);
        data = new FormData();
        data.left = new FormAttachment((Control)cLabel, -7);
        data.right = new FormAttachment((Control)this.checkBox, -5);
        data.top = new FormAttachment((Control)cLabel, 0, 0x1000000);
        this.typeCombo.setLayoutData((Object)data);
        this.typeCombo.addSelectionListener((SelectionListener)this);
        this.typeCombo.setItems(this.typeComboValues);
        this.typeCombo.setText(this.PARAMETER);
        return this.entityCommonComposite;
    }

    private Composite createInternalEntityComposite(Composite parent) {
        this.internalEntityComposite = this.getWidgetFactory().createFlatFormComposite(parent);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.entityCommonComposite, -4);
        this.internalEntityComposite.setLayoutData((Object)data);
        CLabel entityValueLabel = this.getWidgetFactory().createCLabel(this.internalEntityComposite, this.VALUE);
        Point p = entityValueLabel.computeSize(-1, -1, false);
        int labelWidth = Math.max(p.x, 98);
        data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        entityValueLabel.setLayoutData((Object)data);
        this.entityValueText = this.getWidgetFactory().createText(this.internalEntityComposite, "", 0);
        data = new FormData();
        data.left = new FormAttachment((Control)entityValueLabel, -5);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)entityValueLabel, 0, 0x1000000);
        this.entityValueText.setLayoutData((Object)data);
        this.entityValueText.setEditable(true);
        this.entityValueText.addListener(24, (Listener)this);
        return this.internalEntityComposite;
    }

    private Composite createExternalEntityComposite(Composite parent) {
        this.externalEntityComposite = this.getWidgetFactory().createFlatFormComposite(parent);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.entityCommonComposite, -4);
        this.externalEntityComposite.setLayoutData((Object)data);
        CLabel publicIdLabel = this.getWidgetFactory().createCLabel(this.externalEntityComposite, this.PUBLIC_ID);
        Point p = publicIdLabel.computeSize(-1, -1, false);
        int labelWidth = Math.max(p.x, 98);
        data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        publicIdLabel.setLayoutData((Object)data);
        this.publicIdText = this.getWidgetFactory().createText(this.externalEntityComposite, "", 0);
        this.publicIdText.setEditable(true);
        data = new FormData();
        data.left = new FormAttachment((Control)publicIdLabel, -5);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)publicIdLabel, 0, 0x1000000);
        this.publicIdText.setLayoutData((Object)data);
        this.publicIdText.addListener(24, (Listener)this);
        CLabel systemIdLabel = this.getWidgetFactory().createCLabel(this.externalEntityComposite, this.SYSTEM_ID);
        p = systemIdLabel.computeSize(-1, -1, false);
        labelWidth = Math.max(p.x, 98);
        data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)publicIdLabel, 4);
        systemIdLabel.setLayoutData((Object)data);
        this.wizardButton = this.getWidgetFactory().createButton(this.externalEntityComposite, "", 0);
        this.wizardButton.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)DTDUIPlugin.getDefault().getBundle().getSymbolicName(), (String)"icons/browsebutton.gif").createImage());
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)systemIdLabel, 0, 0x1000000);
        this.wizardButton.setLayoutData((Object)data);
        this.wizardButton.addSelectionListener((SelectionListener)this);
        this.systemIdText = this.getWidgetFactory().createText(this.externalEntityComposite, "", 0);
        data = new FormData();
        data.left = new FormAttachment((Control)systemIdLabel, -5);
        data.right = new FormAttachment((Control)this.wizardButton, -5);
        data.top = new FormAttachment((Control)systemIdLabel, 0, 0x1000000);
        this.systemIdText.setLayoutData((Object)data);
        this.systemIdText.addListener(24, (Listener)this);
        return this.externalEntityComposite;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.typeCombo) {
            Object input = this.getInput();
            if (input instanceof Entity) {
                Entity node = (Entity)input;
                String selected = this.typeCombo.getText();
                if (this.PARAMETER.equals(selected)) {
                    node.setParameterEntity(true);
                } else {
                    node.setParameterEntity(false);
                }
            }
        } else if (e.widget == this.checkBox) {
            Object input = this.getInput();
            if (input instanceof Entity) {
                Entity node = (Entity)input;
                boolean selected = this.checkBox.getSelection();
                if (selected) {
                    node.setExternalEntity(true);
                    this.pageBook.showPage((Control)this.externalEntityComposite);
                } else {
                    node.setExternalEntity(false);
                    this.pageBook.showPage((Control)this.internalEntityComposite);
                }
            }
        } else if (e.widget == this.wizardButton) {
            Shell shell = Display.getCurrent().getActiveShell();
            IFile currentIFile = ((IFileEditorInput)NewEntitySection.getActiveEditor().getEditorInput()).getFile();
            ResourceFilter filter = new ResourceFilter(new String[]{".dtd"}, new IFile[]{currentIFile}, null);
            DTDSelectIncludeFileWizard fileSelectWizard = new DTDSelectIncludeFileWizard(DTDPropertiesMessages._UI_FILEDIALOG_SELECT_DTD, DTDPropertiesMessages._UI_FILEDIALOG_SELECT_DTD_DESC, (ViewerFilter)filter, (IStructuredSelection)this.fSelection);
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)fileSelectWizard);
            wizardDialog.create();
            wizardDialog.setBlockOnOpen(true);
            int result = wizardDialog.open();
            if (result == 0) {
                String value = this.systemIdText.getText();
                IFile selectedIFile = fileSelectWizard.getResultFile();
                String dtdFileString = value;
                if (selectedIFile != null) {
                    dtdFileString = URIHelper.getRelativeURI((IPath)selectedIFile.getFullPath(), (IPath)currentIFile.getFullPath());
                }
                this.systemIdText.setText(dtdFileString);
            }
        }
    }

    public void refresh() {
        this.setListenerEnabled(false);
        Object input = this.getInput();
        this.nameText.setText("");
        if (input != null && input instanceof Entity) {
            Entity entity = (Entity)input;
            this.nameText.setText(entity.getName());
            if (entity.isParameterEntity()) {
                this.typeCombo.setText(this.PARAMETER);
            } else {
                this.typeCombo.setText(this.GENERAL);
            }
            if (entity.isExternalEntity()) {
                this.checkBox.setSelection(true);
                this.pageBook.showPage((Control)this.externalEntityComposite);
                this.publicIdText.setText(entity.getPublicID());
                this.systemIdText.setText(entity.getSystemID());
            } else {
                this.checkBox.setSelection(false);
                this.pageBook.showPage((Control)this.internalEntityComposite);
                this.entityValueText.setText(entity.getValue());
            }
        }
        this.setListenerEnabled(true);
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void doHandleEvent(Event event) {
        if (event.widget == this.nameText) {
            Object input = this.getInput();
            String newValue = this.nameText.getText();
            if (newValue.length() > 0 && input instanceof Entity) {
                Entity entity = (Entity)input;
                entity.setName(newValue);
            }
        } else if (event.widget == this.entityValueText) {
            Object input = this.getInput();
            String newValue = this.entityValueText.getText();
            if (input instanceof Entity) {
                Entity entity = (Entity)input;
                entity.setValue(newValue);
            }
        } else if (event.widget == this.publicIdText) {
            Object input = this.getInput();
            String newValue = this.publicIdText.getText();
            if (input instanceof Entity) {
                Entity entity = (Entity)input;
                entity.setPublicID(newValue);
            }
        } else if (event.widget == this.systemIdText) {
            Object input = this.getInput();
            String newValue = this.systemIdText.getText();
            if (input instanceof Entity) {
                Entity entity = (Entity)input;
                entity.setSystemID(newValue);
            }
        }
    }
}

