/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.generator;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.scoping.N4JSScopeProvider;
import org.eclipse.n4js.scoping.imports.PlainAccessOfAliasedImportDescription;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ui.changes.IAtomicChange;
import org.eclipse.n4js.ui.changes.Replacement;
import org.eclipse.n4js.ui.organize.imports.ImportsRegionHelper;
import org.eclipse.n4js.ui.wizard.generator.ImportAnalysis;
import org.eclipse.n4js.ui.wizard.generator.ImportRequirement;
import org.eclipse.n4js.ui.wizard.model.ClassifierReference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class N4JSImportRequirementResolver {
    @Inject
    private N4JSScopeProvider scopeProvider;
    @Inject
    private ImportsRegionHelper hImportsRegion;

    public ImportAnalysis analyzeImportRequirements(List<ImportRequirement> demandedImports, XtextResource resource) {
        ArrayList<ImportRequirement> importRequirements = new ArrayList<ImportRequirement>(demandedImports);
        HashMap<URI, String> aliasBindings = new HashMap<URI, String>();
        Script script = N4JSImportRequirementResolver.getScript(resource);
        List resourceImportStatements = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)script.eAllContents(), ImportDeclaration.class));
        IScope typeScope = this.scopeProvider.getScope((EObject)script, TypeRefsPackage.Literals.PARAMETERIZED_TYPE_REF__DECLARED_TYPE);
        IScope scopeIdRef = this.scopeProvider.getScope((EObject)script, N4JSPackage.Literals.IDENTIFIER_REF__ID);
        int i = importRequirements.size() - 1;
        while (i >= 0) {
            ImportRequirement dependency = importRequirements.get(i);
            boolean fullfilled = false;
            IEObjectDescription typeScopeElement = typeScope.getSingleElement(QualifiedName.create((String)dependency.typeName));
            if (typeScopeElement instanceof IEObjectDescription && typeScopeElement.getEObjectURI().equals(dependency.typeUri) && !(typeScopeElement instanceof PlainAccessOfAliasedImportDescription)) {
                importRequirements.remove(i);
                fullfilled = true;
            }
            if (!fullfilled) {
                int j = resourceImportStatements.size() - 1;
                while (j >= 0 && !fullfilled) {
                    ImportDeclaration declaration = (ImportDeclaration)resourceImportStatements.get(j);
                    ImportSpecifier fulfillingSpecifier = this.findFulfillingImportSpecifier(declaration, dependency);
                    if (fulfillingSpecifier != null && fulfillingSpecifier instanceof NamedImportSpecifier) {
                        if (((NamedImportSpecifier)fulfillingSpecifier).getAlias() != null && !((NamedImportSpecifier)fulfillingSpecifier).getAlias().isEmpty()) {
                            aliasBindings.put(dependency.typeUri, ((NamedImportSpecifier)fulfillingSpecifier).getAlias());
                        }
                        importRequirements.remove(i);
                        fullfilled = true;
                    }
                    --j;
                }
            }
            --i;
        }
        Functions.Function1 _function = name -> {
            QualifiedName qualifiedName = QualifiedName.create((String)name);
            IEObjectDescription typeScopeElement = typeScope.getSingleElement(qualifiedName);
            if (typeScopeElement != null && typeScopeElement instanceof PlainAccessOfAliasedImportDescription) {
                return false;
            }
            IEObjectDescription idScopeElement = scopeIdRef.getSingleElement(qualifiedName);
            if (typeScopeElement == null && idScopeElement == null && !aliasBindings.containsValue(name)) {
                return false;
            }
            return true;
        };
        Map<URI, String> nameResolvingAliasBindings = this.resolveImportNameConflicts(importRequirements, (Functions.Function1<? super String, ? extends Boolean>)_function);
        aliasBindings.putAll(nameResolvingAliasBindings);
        return new ImportAnalysis(importRequirements, aliasBindings);
    }

    public Map<URI, String> resolveImportNameConflicts(Collection<ImportRequirement> importRequirements, Functions.Function1<? super String, ? extends Boolean> isUsedNamePredicate) {
        HashMap<String, Boolean> usedNames = new HashMap<String, Boolean>();
        HashMap<URI, String> aliasBindings = new HashMap<URI, String>();
        for (ImportRequirement requirement : importRequirements) {
            boolean _not;
            boolean _isEmpty = requirement.alias.isEmpty();
            if (!_isEmpty) continue;
            String alias = requirement.typeName;
            while (isUsedNamePredicate != null && ((Boolean)isUsedNamePredicate.apply((Object)alias)).booleanValue() || usedNames.containsKey(alias) || aliasBindings.containsValue(alias)) {
                alias = "Alias" + alias;
            }
            boolean _equals = requirement.typeName.equals(alias);
            boolean bl = _not = !_equals;
            if (_not) {
                requirement.alias = alias;
                aliasBindings.put(requirement.typeUri, alias);
                usedNames.put(alias, true);
                continue;
            }
            usedNames.put(requirement.typeName, true);
        }
        return aliasBindings;
    }

    private ImportSpecifier findFulfillingImportSpecifier(ImportDeclaration declaration, ImportRequirement requirement) {
        boolean _not;
        Object _xblockexpression = null;
        URI declarationModuleURI = this.toContainingModuleURI(EcoreUtil.getURI((EObject)declaration.getModule()));
        boolean _equals = declarationModuleURI.equals(this.toContainingModuleURI(requirement.typeUri));
        boolean bl = _not = !_equals;
        if (_not) {
            return null;
        }
        EList _importSpecifiers = declaration.getImportSpecifiers();
        for (ImportSpecifier specifier : _importSpecifiers) {
            boolean _equals_1;
            TExportableElement importedElement;
            if (!(specifier instanceof NamedImportSpecifier) || !((importedElement = ((NamedImportSpecifier)specifier).getImportedElement()) instanceof TClassifier) || !(_equals_1 = requirement.typeUri.equals(this.uriOfEObject((EObject)importedElement)))) continue;
            return specifier;
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    private URI uriOfEObject(EObject object) {
        return object.eResource().getURI().appendFragment(object.eResource().getURIFragment(object));
    }

    private URI toContainingModuleURI(URI uri) {
        return URI.createURI((String)uri.toString().split("#")[0]);
    }

    public IAtomicChange getImportStatementChanges(XtextResource resource, List<ImportRequirement> requirements) {
        boolean _not;
        Replacement _xblockexpression = null;
        String importStatements = this.generateImportStatements(requirements);
        boolean _isEmpty = importStatements.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            String _importStatements = importStatements;
            importStatements = String.valueOf(_importStatements) + "\n";
        }
        URI _uRI = resource.getURI();
        int _importStatementOffset = this.getImportStatementOffset(resource);
        _xblockexpression = new Replacement(_uRI, _importStatementOffset, 0, importStatements);
        return _xblockexpression;
    }

    public int getImportStatementOffset(XtextResource resource) {
        return this.hImportsRegion.getImportOffset(resource);
    }

    public String generateImportStatements(List<ImportRequirement> importRequirements) {
        Functions.Function1 _function = dep -> {
            boolean _not;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("import {");
            _builder.append(dep.typeName);
            boolean _isEmpty = dep.alias.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append(" as ");
                _builder.append(dep.alias);
            }
            _builder.append("} from \"");
            _builder.append(dep.moduleSpecifier);
            _builder.append("\"");
            return _builder.toString();
        };
        return IterableExtensions.join((Iterable)ListExtensions.map(importRequirements, (Functions.Function1)_function), (CharSequence)"\n");
    }

    private static Script getScript(XtextResource xtextResource) {
        EObject eo;
        boolean _not;
        boolean _isEmpty = xtextResource.getContents().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not && (eo = (EObject)xtextResource.getContents().get(0)) instanceof Script) {
            return (Script)eo;
        }
        return null;
    }

    public static List<ImportRequirement> classifierReferencesToImportRequirements(List<ClassifierReference> refs) {
        Functions.Function1 _function = ref -> N4JSImportRequirementResolver.classifierReferenceToImportRequirement(ref);
        return ListExtensions.map(refs, (Functions.Function1)_function);
    }

    public static ImportRequirement classifierReferenceToImportRequirement(ClassifierReference reference) {
        return new ImportRequirement(reference.classifierName, "", reference.classifierModuleSpecifier, reference.uri);
    }
}

