/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.SftpEventListener;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystem;

public abstract class Handle
implements Channel {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Path file;
    private final String handle;

    protected Handle(Path file, String handle) {
        this.file = Objects.requireNonNull(file, "No local file path");
        this.handle = ValidateUtils.checkNotNullAndNotEmpty((String)handle, (String)"No assigned handle for %s", (Object)file);
    }

    protected void signalHandleOpening(SftpSubsystem subsystem) throws IOException {
        SftpEventListener listener = subsystem.getSftpEventListenerProxy();
        ServerSession session = subsystem.getServerSession();
        listener.opening(session, this.handle, this);
    }

    protected void signalHandleOpen(SftpSubsystem subsystem) throws IOException {
        SftpEventListener listener = subsystem.getSftpEventListenerProxy();
        ServerSession session = subsystem.getServerSession();
        listener.open(session, this.handle, this);
    }

    public Path getFile() {
        return this.file;
    }

    public String getFileHandle() {
        return this.handle;
    }

    @Override
    public boolean isOpen() {
        return !this.closed.get();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.getAndSet(true)) {
            return;
        }
    }

    public String toString() {
        return Objects.toString(this.getFile());
    }
}

