/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.conversion;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.conversion.N4JSValueConverterWithValueException;
import org.eclipse.n4js.conversion.ValueConverterUtils;
import org.eclipse.n4js.regex.regularExpression.CharacterClassEscapeSequence;
import org.eclipse.n4js.regex.regularExpression.CharacterClassRange;
import org.eclipse.n4js.regex.regularExpression.ControlLetterEscapeSequence;
import org.eclipse.n4js.regex.regularExpression.DecimalEscapeSequence;
import org.eclipse.n4js.regex.regularExpression.RegularExpressionLiteral;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.conversion.ValueConverterWithValueException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.resource.IResourceServiceProvider;

@Singleton
public class RegExLiteralConverter
extends AbstractValueConverter<String> {
    public static final String ISSUE_CODE = "RegExLiteralConverter.bogus.regex";
    private IParser regexParser;
    private final IResourceServiceProvider.Registry serviceProviders;

    @Inject
    public RegExLiteralConverter(IResourceServiceProvider.Registry serviceProviders) {
        this.serviceProviders = serviceProviders;
    }

    public String toString(String value) {
        return value;
    }

    private IParser getRegexParser() {
        if (this.regexParser == null) {
            IResourceServiceProvider serviceProvider = this.serviceProviders.getResourceServiceProvider(URI.createURI((String)"a.regex"));
            this.regexParser = (IParser)serviceProvider.get(IParser.class);
        }
        return this.regexParser;
    }

    public String toValue(String string, INode node) {
        String escaped = RegExLiteralConverter.convertFromJS(string, node);
        IParseResult parseResult = this.getRegexParser().parse((Reader)new StringReader(escaped));
        Iterable syntaxErrors = parseResult.getSyntaxErrors();
        Iterator iterator = syntaxErrors.iterator();
        String issueMessage = null;
        boolean hasErrors = false;
        while (iterator.hasNext()) {
            INode syntaxError = (INode)iterator.next();
            String message = syntaxError.getSyntaxErrorMessage().getMessage();
            if (message.contains("'<EOF>' expecting '/'")) {
                hasErrors = true;
                break;
            }
            if (issueMessage != null) continue;
            issueMessage = message;
        }
        if (hasErrors) {
            throw new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_REGEX_INVALID(), "VCO_REGEX_INVALID", node, string, null);
        }
        if (issueMessage != null) {
            throw new BogusRegExLiteralException(issueMessage, node, string);
        }
        RegularExpressionLiteral literal = (RegularExpressionLiteral)parseResult.getRootASTElement();
        if (literal.getFlags().getFlags().contains((Object)"u")) {
            TreeIterator regExIterator = literal.eAllContents();
            while (regExIterator.hasNext()) {
                CharacterClassRange casted;
                EObject next = (EObject)regExIterator.next();
                if (next instanceof DecimalEscapeSequence) {
                    throw new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_REGEX_INVALID(), "VCO_REGEX_INVALID", node, string, null);
                }
                if (!(next instanceof ControlLetterEscapeSequence ? ((ControlLetterEscapeSequence)next).getSequence().length() <= 2 : next instanceof CharacterClassRange && ((casted = (CharacterClassRange)next).getLeft() instanceof CharacterClassEscapeSequence || casted.getRight() instanceof CharacterClassEscapeSequence))) continue;
                throw new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_REGEX_INVALID(), "VCO_REGEX_INVALID", node, string, null);
            }
        }
        return string;
    }

    private static String convertFromJS(String jsString, INode node) {
        ValueConverterUtils.StringConverterResult result = ValueConverterUtils.convertFromEscapedString(jsString, false, true, false, null);
        if (result.hasError()) {
            throw new N4JSValueConverterWithValueException(IssueCodes.getMessageForVCO_REGEX_ILLEGAL_ESCAP(jsString), "VCO_REGEX_ILLEGAL_ESCAP", node, result.getValue(), null);
        }
        return result.getValue();
    }

    public static class BogusRegExLiteralException
    extends ValueConverterWithValueException {
        private static final long serialVersionUID = 1L;

        public BogusRegExLiteralException(String message, INode node, String value) {
            super(message, node, (Object)value, null);
        }
    }
}

