/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.contentassist.jsdoc;

import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.n4js.jsdoc.ITagDefinition;
import org.eclipse.n4js.jsdoc.JSDocCharScanner;
import org.eclipse.n4js.jsdoc.JSDocCompletionHint;
import org.eclipse.n4js.jsdoc.JSDocletUtils;
import org.eclipse.n4js.jsdoc.N4JSDocletParser;
import org.eclipse.n4js.jsdoc.dom.Doclet;
import org.eclipse.n4js.jsdoc.dom.FullMemberReference;
import org.eclipse.n4js.jsdoc.dom.Tag;
import org.eclipse.n4js.jsdoc.tags.LineTagWithFullElementReference;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.scoping.IContentAssistScopeProvider;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ui.contentassist.jsdoc.JSDocContentAssistProcessor;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class JSDocCompletionProposalComputer
implements IUnitOfWork<ICompletionProposal[], XtextResource>,
ICompletionProposalAcceptor {
    private final JSDocContentAssistProcessor processor;
    private final ITextViewer viewer;
    private final int offset;

    public JSDocCompletionProposalComputer(JSDocContentAssistProcessor jsDocContentAssistProcessor, ITextViewer viewer, int offset) {
        this.processor = jsDocContentAssistProcessor;
        this.viewer = viewer;
        this.offset = offset;
    }

    public void accept(ICompletionProposal proposal) {
    }

    public boolean canAcceptMoreProposals() {
        return true;
    }

    public ICompletionProposal[] exec(XtextResource xtextResource) throws Exception {
        block15: {
            Tag tag;
            ContentAssistContext[] contexts = this.processor.getContextFactory().create(this.viewer, this.offset, xtextResource);
            if (contexts.length <= 0) break block15;
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
            ContentAssistContext contentAssistContext = contexts[contexts.length - 1];
            INode currentNode = contentAssistContext.getCurrentNode();
            String content = currentNode.getText();
            int offsetInNode = contentAssistContext.getOffset() - currentNode.getOffset() - contentAssistContext.getPrefix().length();
            N4JSDocletParser docletParser = this.processor.getDocletParser();
            Doclet doclet = docletParser.parse(content);
            Optional<String> lineTagPrefix = this.getLineTagTitlePrefix(content, offsetInNode);
            if (lineTagPrefix.isPresent()) {
                this.createLineTagProposal(lineTagPrefix.get(), docletParser, proposals);
            }
            if ((tag = JSDocletUtils.getTagAtOffset((Doclet)doclet, (int)offsetInNode)) != null) {
                ITagDefinition tagDef = tag.getTagDefinition();
                JSDocCharScanner scanner = new JSDocCharScanner(content);
                JSDocCharScanner.ScannerState state = scanner.saveState();
                scanner.setNextOffset(offsetInNode);
                JSDocCompletionHint completionHint = tagDef.completionHint(scanner);
                scanner.restoreState(state);
                if (completionHint.kind != JSDocCompletionHint.CompletionKind.NOCOMPLETION) {
                    int replacementOffset = this.offset - completionHint.prefix.length();
                    if (completionHint.isTypeModelRef()) {
                        FullMemberReference ref = completionHint.nodeAsFullMemberReference();
                        IContentAssistScopeProvider scopeProvider = (IContentAssistScopeProvider)this.processor.getScopeProvider();
                        IScope moduleSpecScope = scopeProvider.getScopeForContentAssist((EObject)xtextResource.getContents().get(0), N4JSPackage.Literals.IMPORT_DECLARATION__MODULE);
                        if (!completionHint.isModuleNameCompleted()) {
                            for (IEObjectDescription moduleDescr : moduleSpecScope.getAllElements()) {
                                CompletionProposal proposal;
                                int cursorPosition;
                                int replacementLength;
                                String moduleSpec = moduleDescr.getName().toString("/");
                                String moduleSimpleName = moduleDescr.getName().getLastSegment();
                                if (moduleSpec.startsWith("#") || !moduleSpec.startsWith(completionHint.prefix) && !moduleSimpleName.startsWith(completionHint.prefix)) continue;
                                if (moduleSpec.length() == completionHint.prefix.length()) {
                                    replacementLength = 0;
                                    cursorPosition = 1;
                                    proposal = new CompletionProposal(".", replacementOffset + completionHint.prefix.length(), replacementLength, cursorPosition);
                                    proposals.add((ICompletionProposal)proposal);
                                    continue;
                                }
                                replacementLength = completionHint.prefix.length();
                                cursorPosition = moduleSpec.length();
                                proposal = new CompletionProposal(moduleSpec, replacementOffset, replacementLength, cursorPosition);
                                proposals.add((ICompletionProposal)proposal);
                            }
                        } else {
                            QualifiedName moduleQN = QualifiedName.create((String[])ref.getModuleName().split("/"));
                            IEObjectDescription descr = moduleSpecScope.getSingleElement(moduleQN);
                            if (descr != null && descr.getEObjectOrProxy() instanceof TModule) {
                                TModule module = (TModule)descr.getEObjectOrProxy();
                                if (module.eIsProxy()) {
                                    module = (TModule)EcoreUtil.resolve((EObject)module, (Resource)xtextResource);
                                }
                                if (!completionHint.isTypeNameCompleted(false) && completionHint.kind != JSDocCompletionHint.CompletionKind.MODULESPEC) {
                                    String typePrefix = ref.getTypeName();
                                    for (Type t2 : module.getTopLevelTypes()) {
                                        String typeName = t2.getName();
                                        if (!typeName.startsWith(typePrefix)) continue;
                                        String completion = String.valueOf(module.getModuleSpecifier()) + "." + typeName;
                                        int replacementLength = completionHint.prefix.length();
                                        int cursorPosition = completion.length();
                                        CompletionProposal proposal = new CompletionProposal(completion, replacementOffset, replacementLength, cursorPosition);
                                        proposals.add((ICompletionProposal)proposal);
                                    }
                                } else {
                                    Type t3;
                                    Optional<Type> optType = module.getTopLevelTypes().stream().filter(t -> t.getName().equals(ref.getTypeName())).findAny();
                                    if (optType.isPresent() && (t3 = optType.get()) instanceof ContainerType) {
                                        String memberPrefix = ref.getMemberName();
                                        for (TMember m : ((ContainerType)t3).getOwnedMembers()) {
                                            String memberName = m.getName();
                                            if (!memberName.startsWith(memberPrefix)) continue;
                                            String completion = LineTagWithFullElementReference.createReferenceFromType((TMember)m).toString();
                                            int replacementLength = completionHint.prefix.length();
                                            int cursorPosition = completion.length();
                                            CompletionProposal proposal = new CompletionProposal(completion, replacementOffset, replacementLength, cursorPosition);
                                            proposals.add((ICompletionProposal)proposal);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ICompletionProposal[] result = new ICompletionProposal[proposals.size()];
            proposals.toArray(result);
            return result;
        }
        return null;
    }

    private void createLineTagProposal(String prefix, N4JSDocletParser docletParser, ArrayList<ICompletionProposal> proposals) {
        int replacementOffset = this.offset - prefix.length();
        for (ITagDefinition td : docletParser.getLineTagDictionary().getTagDefinitions()) {
            String tagString = String.valueOf('@') + td.getTitle() + ' ';
            if (!tagString.startsWith(prefix)) continue;
            int replacementLength = prefix.length();
            int cursorPosition = tagString.length();
            CompletionProposal proposal = new CompletionProposal(tagString, replacementOffset, replacementLength, cursorPosition);
            proposals.add((ICompletionProposal)proposal);
        }
    }

    private Optional<String> getLineTagTitlePrefix(String content, int offsetInNode) {
        int p = offsetInNode - 1;
        if (p <= 0) {
            return Optional.of("");
        }
        char c = '\u0000';
        do {
            if ((c = content.charAt(p)) != '@') continue;
            --p;
            break;
        } while (Character.isLetter(c) && --p > 0);
        String prefix = content.substring(p + 1, offsetInNode);
        if (!prefix.isEmpty() && c != '@') {
            return Optional.empty();
        }
        while ((c = content.charAt(p)) != '\n' && c != '\r' && (Character.isWhitespace(c) || c == '*') && --p > 0) {
        }
        if (p == 0 || c == '\n' || c == '\r') {
            return Optional.of(prefix);
        }
        return Optional.empty();
    }
}

