/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.internal;

import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.n4js.N4JSRuntimeModule;
import org.eclipse.n4js.ui.N4JSUiModule;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtext.ui.shared.SharedStateModule;
import org.eclipse.xtext.util.Modules2;
import org.osgi.framework.BundleContext;

public class N4JSActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.n4js.ui";
    public static final String ORG_ECLIPSE_N4JS_N4JS = "org.eclipse.n4js.N4JS";
    private static final Logger logger = Logger.getLogger(N4JSActivator.class);
    private static N4JSActivator INSTANCE;
    private Map<String, Injector> injectors = Collections.synchronizedMap(Maps.newHashMapWithExpectedSize((int)1));

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
    }

    public void stop(BundleContext context) throws Exception {
        this.injectors.clear();
        INSTANCE = null;
        super.stop(context);
    }

    public static N4JSActivator getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Injector getInjector(String language) {
        Map<String, Injector> map = this.injectors;
        synchronized (map) {
            Injector injector = this.injectors.get(language);
            if (injector == null) {
                injector = this.createInjector(language);
                this.injectors.put(language, injector);
            }
            return injector;
        }
    }

    protected Injector createInjector(String language) {
        try {
            Module runtimeModule = this.getRuntimeModule(language);
            Module sharedStateModule = this.getSharedStateModule();
            Module uiModule = this.getUiModule(language);
            Module mergedModule = Modules2.mixin((Module[])new Module[]{runtimeModule, sharedStateModule, uiModule});
            return Guice.createInjector((Module[])new Module[]{mergedModule});
        }
        catch (Exception e) {
            logger.error((Object)("Failed to create injector for " + language));
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException("Failed to create injector for " + language, e);
        }
    }

    protected Module getRuntimeModule(String grammar) {
        if (ORG_ECLIPSE_N4JS_N4JS.equals(grammar)) {
            return new N4JSRuntimeModule();
        }
        throw new IllegalArgumentException(grammar);
    }

    protected Module getUiModule(String grammar) {
        if (ORG_ECLIPSE_N4JS_N4JS.equals(grammar)) {
            return new N4JSUiModule(this);
        }
        throw new IllegalArgumentException(grammar);
    }

    protected Module getSharedStateModule() {
        return new SharedStateModule();
    }
}

