/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.internal;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.ExternalProject;
import org.eclipse.n4js.internal.N4JSModel;
import org.eclipse.n4js.internal.N4JSProject;
import org.eclipse.n4js.ui.internal.N4JSEclipseModel;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseProject;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseSourceContainer;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.xtext.ui.XtextProjectHelper;

public class N4JSEclipseProject
extends N4JSProject
implements IN4JSEclipseProject {
    private final IProject project;

    N4JSEclipseProject(IProject project, URI location, N4JSEclipseModel model) {
        super(location, project instanceof ExternalProject, (N4JSModel)model);
        this.project = project;
    }

    protected boolean checkExists() {
        if (XtextProjectHelper.hasNature((IProject)this.project)) {
            return this.project.getFile("package.json").exists();
        }
        return false;
    }

    protected N4JSEclipseModel getModel() {
        return (N4JSEclipseModel)super.getModel();
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public Path getLocationPath() {
        return this.project.getLocation().toFile().toPath();
    }

    public Optional<URI> getProjectDescriptionLocation() {
        if (this.checkExists() && (this.getLocation().isPlatformResource() && URIUtils.isPlatformResourceUriPointingToProject((URI)this.getLocation()) || this.isExternal())) {
            return Optional.fromNullable((Object)this.getLocation().appendSegment("package.json"));
        }
        return Optional.absent();
    }

    @Override
    public ImmutableList<? extends IN4JSEclipseProject> getDependencies() {
        if (!this.exists()) {
            return ImmutableList.of();
        }
        return this.getModel().getDependencies(this, false);
    }

    @Override
    public ImmutableList<? extends IN4JSEclipseProject> getDependenciesAndImplementedApis() {
        return this.getDependenciesAndImplementedApis(false);
    }

    @Override
    public ImmutableList<? extends IN4JSEclipseProject> getDependenciesAndImplementedApis(boolean includeAbsentProjects) {
        if (!this.exists()) {
            return ImmutableList.of();
        }
        return this.getModel().getDependenciesAndImplementedApis(this, includeAbsentProjects);
    }

    public ImmutableList<? extends IN4JSEclipseProject> getImplementedProjects() {
        if (!this.exists()) {
            return ImmutableList.of();
        }
        return this.getModel().getImplementedProjects(this);
    }

    @Override
    public ImmutableList<? extends IN4JSEclipseSourceContainer> getSourceContainers() {
        if (!this.exists()) {
            return ImmutableList.of();
        }
        return this.getModel().getN4JSSourceContainers(this);
    }
}

