/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.components;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.n4js.ui.dialog.InterfacesSelectionDialog;
import org.eclipse.n4js.ui.wizard.components.DotPathUtils;
import org.eclipse.n4js.ui.wizard.components.WizardComponent;
import org.eclipse.n4js.ui.wizard.components.WizardComponentContainer;
import org.eclipse.n4js.ui.wizard.components.WizardComponentDataConverters;
import org.eclipse.n4js.ui.wizard.components.WizardComponentUtils;
import org.eclipse.n4js.ui.wizard.model.ClassifierReference;
import org.eclipse.n4js.ui.wizard.model.InterfacesContainingModel;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xtext.resource.IEObjectDescription;

public class InterfacesComponentProvider {
    @Inject
    private Provider<InterfacesSelectionDialog> interfacesSelectionDialogProvider;

    public InterfacesComponent create(InterfacesContainingModel interfacesContainingModel, WizardComponentContainer container) {
        return new InterfacesComponent(interfacesContainingModel, container);
    }

    public class InterfacesComponent
    extends WizardComponent {
        private final Table interfacesTable;
        private final Button interfacesAddButton;
        private final Button interfacesRemoveButton;
        private final InterfacesContainingModel model;

        public InterfacesComponent(InterfacesContainingModel interfacesContainingModel, WizardComponentContainer container) {
            super(container);
            this.model = interfacesContainingModel;
            Composite parent = this.getParentComposite();
            Label interfacesLabel = new Label(parent, 0);
            GridData interfacesLabelGridData = WizardComponentUtils.fillLabelDefaults();
            interfacesLabelGridData.verticalAlignment = 128;
            interfacesLabel.setLayoutData((Object)interfacesLabelGridData);
            interfacesLabel.setText("Interfaces:");
            this.interfacesTable = new Table(parent, 0x10010800);
            this.interfacesTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            Composite interfacesButtonsComposite = new Composite(parent, 0);
            interfacesButtonsComposite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
            interfacesButtonsComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).margins(0, 0).create());
            this.interfacesAddButton = new Button(interfacesButtonsComposite, 0);
            this.interfacesAddButton.setText("Add...");
            this.interfacesAddButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
            this.interfacesRemoveButton = new Button(interfacesButtonsComposite, 0);
            this.interfacesRemoveButton.setText("Remove");
            this.interfacesRemoveButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
            this.setupBindings();
        }

        private void setupBindings() {
            if (this.interfacesTable == null || this.interfacesAddButton == null || this.interfacesRemoveButton == null) {
                return;
            }
            IObservableList interfacesValue = BeanProperties.list(InterfacesContainingModel.class, (String)"interfaces").observe((Object)this.model);
            interfacesValue.addListChangeListener((IListChangeListener)new IListChangeListener<ClassifierReference>(){

                public void handleListChange(ListChangeEvent<? extends ClassifierReference> event) {
                    int itemCount = event.getObservableList().size();
                    InterfacesComponent.this.interfacesTable.setItemCount(itemCount);
                    int minIndex = itemCount - 1;
                    ListDiffEntry[] listDiffEntryArray = event.diff.getDifferences();
                    int n = listDiffEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ListDiffEntry entry = listDiffEntryArray[n2];
                        if (minIndex > entry.getPosition()) {
                            minIndex = entry.getPosition();
                        }
                        ++n2;
                    }
                    if (itemCount > 0) {
                        InterfacesComponent.this.interfacesTable.clear(minIndex, itemCount - 1);
                    }
                    listDiffEntryArray = event.diff.getDifferences();
                    n = listDiffEntryArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        ListDiffEntry diff = listDiffEntryArray[n2];
                        InterfacesComponent.this.interfacesTable.clear(diff.getPosition(), itemCount - 1);
                        ++n2;
                    }
                    if (itemCount < 1) {
                        InterfacesComponent.this.interfacesRemoveButton.setEnabled(false);
                    }
                }
            });
            this.interfacesTable.addListener(36, new Listener(){

                public void handleEvent(Event event) {
                    TableItem item = (TableItem)event.item;
                    int index = InterfacesComponent.this.interfacesTable.indexOf(item);
                    if (index < InterfacesComponent.this.model.getInterfaces().size()) {
                        item.setText(InterfacesComponent.this.model.getInterfaces().get(index).getFullSpecifier());
                    } else {
                        item.setText("");
                    }
                }
            });
            this.interfacesRemoveButton.setEnabled(false);
            TableEditor editor = new TableEditor(this.interfacesTable);
            editor.horizontalAlignment = 16384;
            editor.grabHorizontal = true;
            editor.minimumWidth = 50;
            this.interfacesTable.addMouseListener((MouseListener)new InterfacesTableMouseListener(editor));
            this.interfacesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InterfacesComponent.this.interfacesRemoveButton.setEnabled(InterfacesComponent.this.interfacesTable.getSelectionIndex() != -1 && InterfacesComponent.this.interfacesTable.getSelectionIndex() < InterfacesComponent.this.model.getInterfaces().size());
                }
            });
            this.interfacesRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int selectionIndex = InterfacesComponent.this.interfacesTable.getSelectionIndex();
                    if (selectionIndex == -1) {
                        return;
                    }
                    ClassifierReference itemToRemove = InterfacesComponent.this.model.getInterfaces().get(selectionIndex);
                    if (itemToRemove == null) {
                        return;
                    }
                    InterfacesComponent.this.model.removeInterfaces(itemToRemove);
                    InterfacesComponent.this.interfacesRemoveButton.setEnabled(InterfacesComponent.this.interfacesTable.getSelectionIndex() != -1);
                }
            });
            this.interfacesAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object[] results;
                    InterfacesSelectionDialog dialog = (InterfacesSelectionDialog)((Object)InterfacesComponentProvider.this.interfacesSelectionDialogProvider.get());
                    dialog.open();
                    if (dialog.getReturnCode() == 1) {
                        return;
                    }
                    Object[] objectArray = results = dialog.getResult();
                    int n = results.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object result = objectArray[n2];
                        if (result instanceof IEObjectDescription) {
                            IEObjectDescription objectDescription = (IEObjectDescription)result;
                            URI objectUri = ((IEObjectDescription)result).getEObjectURI();
                            InterfacesComponent.this.model.addInterfaces(new ClassifierReference(objectDescription.getQualifiedName(), objectUri));
                        }
                        ++n2;
                    }
                }
            });
        }

        @Override
        public void setFocus() {
            this.interfacesAddButton.setFocus();
        }

        private final class InterfacesTableMouseListener
        implements MouseListener {
            private final TableEditor editor;

            private InterfacesTableMouseListener(TableEditor editor) {
                this.editor = editor;
            }

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (this.editor.getItem() != null && this.editor.getItem() != InterfacesComponent.this.interfacesTable.getItem(new Point(e.x, e.y))) {
                    this.editor.getEditor().dispose();
                    InterfacesComponent.this.interfacesTable.setItemCount(InterfacesComponent.this.model.getInterfaces().size());
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                Control oldEditor;
                TableItem item = InterfacesComponent.this.interfacesTable.getItem(new Point(e.x, e.y));
                if (item == null) {
                    InterfacesComponent.this.interfacesTable.setItemCount(InterfacesComponent.this.interfacesTable.getItemCount() + 1);
                    item = InterfacesComponent.this.interfacesTable.getItem(InterfacesComponent.this.interfacesTable.getItemCount() - 1);
                }
                if ((oldEditor = this.editor.getEditor()) != null) {
                    oldEditor.dispose();
                }
                final Text newEditor = new Text((Composite)InterfacesComponent.this.interfacesTable, 0);
                newEditor.setText(item.getText(0));
                newEditor.setToolTipText("Enter the interface specifier");
                newEditor.addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent event) {
                        event.doit = false;
                    }
                });
                final int fSelectionIndex = InterfacesComponent.this.interfacesTable.indexOf(item);
                if (fSelectionIndex < InterfacesComponent.this.model.getInterfaces().size()) {
                    newEditor.addKeyListener(new KeyListener(){

                        public void keyReleased(KeyEvent event) {
                            if (event.keyCode == 13) {
                                ArrayList<ClassifierReference> interfaces = new ArrayList<ClassifierReference>(InterfacesComponent.this.model.getInterfaces());
                                ClassifierReference ref = interfaces.get(fSelectionIndex);
                                if (newEditor.getText().isEmpty()) {
                                    InterfacesComponent.this.model.removeInterfaces(ref);
                                    newEditor.dispose();
                                    return;
                                }
                                ClassifierReference editedRef = new WizardComponentDataConverters.StringToClassifierReferenceConverter().convert(newEditor.getText());
                                interfaces.set(fSelectionIndex, editedRef);
                                newEditor.dispose();
                                InterfacesComponent.this.interfacesTable.clear(fSelectionIndex);
                                InterfacesComponent.this.model.setInterfaces(interfaces);
                            } else if (event.keyCode == 27) {
                                newEditor.dispose();
                            }
                        }

                        public void keyPressed(KeyEvent event) {
                        }
                    });
                } else {
                    newEditor.addKeyListener(new KeyListener(){

                        public void keyReleased(KeyEvent event) {
                            if (event.keyCode == 13) {
                                String userInput = newEditor.getText();
                                InterfacesComponent.this.model.addInterfaces(new ClassifierReference(DotPathUtils.frontDotSegments(userInput), DotPathUtils.lastDotSegment(userInput)));
                                newEditor.dispose();
                            } else if (event.keyCode == 27) {
                                newEditor.dispose();
                                InterfacesComponent.this.interfacesTable.setItemCount(InterfacesComponent.this.model.getInterfaces().size());
                            }
                        }

                        public void keyPressed(KeyEvent event) {
                        }
                    });
                }
                newEditor.selectAll();
                newEditor.setFocus();
                this.editor.grabHorizontal = true;
                this.editor.setEditor((Control)newEditor, item, 0);
            }
        }
    }
}

