/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types;

import org.eclipse.n4js.ts.types.TMember;

public class NameAndAccess {
    private final String name;
    private final boolean writeAccess;
    private final boolean staticAccess;

    public static NameAndAccess[] of(TMember member) {
        if (member.isReadable() && member.isWriteable()) {
            return new NameAndAccess[]{new NameAndAccess(member.getName(), false, member.isStatic()), new NameAndAccess(member.getName(), true, member.isStatic())};
        }
        return new NameAndAccess[]{new NameAndAccess(member.getName(), member.isWriteable(), member.isStatic())};
    }

    public NameAndAccess(String name, boolean writeAccess, boolean staticAccess) {
        this.name = name;
        this.writeAccess = writeAccess;
        this.staticAccess = staticAccess;
    }

    public String getName() {
        return this.name;
    }

    public boolean isWriteAccess() {
        return this.writeAccess;
    }

    public boolean isStaticAccess() {
        return this.staticAccess;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.staticAccess ? 1231 : 1237);
        result = 31 * result + (this.writeAccess ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NameAndAccess other = (NameAndAccess)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.staticAccess != other.staticAccess) {
            return false;
        }
        return this.writeAccess == other.writeAccess;
    }

    public String toString() {
        return "NameAndAccess [name=" + this.name + ", writeAccess=" + this.writeAccess + ", staticAccess=" + this.staticAccess + "]";
    }
}

