/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.events;

import java.util.function.Consumer;
import org.eclipse.n4js.tester.events.SessionEndedEvent;
import org.eclipse.n4js.tester.events.SessionFailedEvent;
import org.eclipse.n4js.tester.events.SessionFinishedEvent;
import org.eclipse.n4js.tester.events.SessionPingedEvent;
import org.eclipse.n4js.tester.events.SessionStartedEvent;
import org.eclipse.n4js.tester.events.TestEndedEvent;
import org.eclipse.n4js.tester.events.TestEvent;
import org.eclipse.n4js.tester.events.TestPingedEvent;
import org.eclipse.n4js.tester.events.TestStartedEvent;
import org.eclipse.n4js.utils.ThrowingConsumer;

public final class TestEventDispatcher<E extends Exception>
implements ThrowingConsumer<TestEvent, E> {
    private final Consumer<SessionPingedEvent> sessionPinged;
    private final Consumer<SessionFailedEvent> sessionFailed;
    private final Consumer<SessionFinishedEvent> sessionFinished;
    private final Consumer<SessionEndedEvent> sesionEnded;
    private final Consumer<SessionStartedEvent> sessionStarted;
    private final Consumer<TestPingedEvent> testPinged;
    private final ThrowingConsumer<TestEndedEvent, E> testEnded;
    private final Consumer<TestStartedEvent> testStarted;
    private final ThrowingConsumer<TestEvent, E> unhandled;

    public TestEventDispatcher(Consumer<SessionStartedEvent> sessionStarted, Consumer<SessionFinishedEvent> sessionFinished, Consumer<SessionFailedEvent> sessionFailed, Consumer<SessionPingedEvent> sessionPinged, Consumer<SessionEndedEvent> sesionEnded, Consumer<TestPingedEvent> testPinged, Consumer<TestStartedEvent> testStarted, ThrowingConsumer<TestEndedEvent, E> testEnded, ThrowingConsumer<TestEvent, E> unhandled) {
        this.sessionPinged = sessionPinged;
        this.sessionFailed = sessionFailed;
        this.sessionFinished = sessionFinished;
        this.sesionEnded = sesionEnded;
        this.sessionStarted = sessionStarted;
        this.testPinged = testPinged;
        this.testStarted = testStarted;
        this.testEnded = testEnded;
        this.unhandled = unhandled;
    }

    public void accept(TestEvent event) throws E {
        if (event instanceof TestStartedEvent) {
            this.testStarted.accept((TestStartedEvent)event);
            return;
        }
        if (event instanceof TestEndedEvent) {
            this.testEnded.accept((Object)((TestEndedEvent)event));
            return;
        }
        if (event instanceof TestPingedEvent) {
            this.testPinged.accept((TestPingedEvent)event);
            return;
        }
        if (event instanceof SessionStartedEvent) {
            this.sessionStarted.accept((SessionStartedEvent)event);
            return;
        }
        if (event instanceof SessionEndedEvent) {
            this.sesionEnded.accept((SessionEndedEvent)event);
            return;
        }
        if (event instanceof SessionFinishedEvent) {
            this.sessionFinished.accept((SessionFinishedEvent)event);
            return;
        }
        if (event instanceof SessionFailedEvent) {
            this.sessionFailed.accept((SessionFailedEvent)event);
            return;
        }
        if (event instanceof SessionPingedEvent) {
            this.sessionPinged.accept((SessionPingedEvent)event);
            return;
        }
        this.unhandled.accept((Object)event);
    }
}

