/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.setup.workspace;

import java.io.IOException;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.xpect.setup.XpectSetupComponent;
import org.eclipse.xpect.xtext.lib.setup.FileSetupContext;
import org.eclipse.xpect.xtext.lib.setup.workspace.Container;
import org.eclipse.xpect.xtext.lib.setup.workspace.IResourceFactory;
import org.eclipse.xpect.xtext.lib.setup.workspace.Workspace;

@XpectSetupComponent
public class Project
extends Container<IProject>
implements IResourceFactory<IProject, IWorkspaceRoot> {
    private final ProjectDescription description = this.createDescription();

    public Project() {
        this("general_project");
    }

    public Project(String name) {
        this.description.setName(name);
        this.addNature("org.eclipse.xtext.ui.shared.xtextNature");
        this.addBuilder("org.eclipse.xtext.ui.shared.xtextBuilder");
    }

    @Override
    public IProject create(FileSetupContext ctx, IWorkspaceRoot container, Workspace.Instance instance) throws CoreException, IOException {
        IProject project = container.getProject(this.description.getName());
        project.create((IProjectDescription)this.description, (IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
        this.configure(ctx, project);
        this.createMembers(ctx, project, instance);
        return project;
    }

    protected ProjectDescription createDescription() {
        return new ProjectDescription();
    }

    public void addNature(String nature) {
        String[] natures = this.description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = nature;
        this.description.setNatureIds(newNatures);
    }

    public void addBuilder(String builder) {
        ICommand[] specs = this.description.getBuildSpec();
        ICommand command = this.description.newCommand();
        command.setBuilderName(builder);
        ICommand[] specsModified = new ICommand[specs.length + 1];
        System.arraycopy(specs, 0, specsModified, 0, specs.length);
        specsModified[specs.length] = command;
        this.description.setBuildSpec(specsModified);
    }

    protected ProjectDescription getDescription() {
        return this.description;
    }

    public String getName() {
        return this.description.getName();
    }
}

