/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.navigator.internal;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.internal.AssignWorkingSetsAction;
import org.eclipse.n4js.ui.workingsets.internal.N4JSProjectActionGroup;
import org.eclipse.n4js.ui.workingsets.internal.N4JSWorkingSetActionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class N4JSNavigatorActionProvider
extends CommonActionProvider {
    private N4JSProjectActionGroup projectGroup;
    private N4JSWorkingSetActionProvider workingSetActionProvider;
    @Inject
    private AssignWorkingSetsAction assignWorkingSetsAction;
    private boolean selectionContainsWorkingSet = false;

    public void init(ICommonActionExtensionSite site) {
        ICommonViewerWorkbenchSite workbenchSite = null;
        if (site.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            workbenchSite = (ICommonViewerWorkbenchSite)site.getViewSite();
        }
        if (workbenchSite != null && workbenchSite.getPart() != null && workbenchSite.getPart() instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)workbenchSite.getPart();
            this.projectGroup = new N4JSProjectActionGroup(viewPart);
            this.workingSetActionProvider = new N4JSWorkingSetActionProvider();
            this.workingSetActionProvider.init(site);
            this.assignWorkingSetsAction.init(site);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        this.projectGroup.fillContextMenu(menu);
        if (this.selectionContainsWorkingSet) {
            this.workingSetActionProvider.fillContextMenu(menu);
        }
        if (this.assignWorkingSetsAction.isEnabled()) {
            menu.appendToGroup("group.build", (IAction)this.assignWorkingSetsAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        this.projectGroup.fillActionBars(actionBars);
        if (this.selectionContainsWorkingSet) {
            this.workingSetActionProvider.fillActionBars(actionBars);
        }
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        this.projectGroup.setContext(context);
        if (context != null) {
            StructuredSelection selection = (StructuredSelection)context.getSelection();
            List<Object> selectedElements = Arrays.asList(selection.toArray());
            this.selectionContainsWorkingSet = selectedElements.stream().anyMatch(element -> element instanceof WorkingSet);
            if (this.selectionContainsWorkingSet) {
                this.workingSetActionProvider.setContext(context);
            }
            this.assignWorkingSetsAction.selectionChanged((IStructuredSelection)selection);
        }
    }

    public void dispose() {
        this.projectGroup.dispose();
        this.workingSetActionProvider.dispose();
        super.dispose();
    }
}

