/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.generator;

import org.eclipse.n4js.utils.RecursionGuard;

public enum GeneratorOption {
    AsyncAwait,
    TemplateStringLiterals,
    ArrowFunctions,
    Destructuring,
    RestParameters,
    ES5plus(AsyncAwait, TemplateStringLiterals, ArrowFunctions, Destructuring, RestParameters),
    NodeCurrent;

    public static final GeneratorOption[] DEFAULT_OPTIONS;
    public static final GeneratorOption[] MAX_TRANSPILE_OPTIONS;
    private final GeneratorOption[] includedOptions;

    static {
        DEFAULT_OPTIONS = new GeneratorOption[]{NodeCurrent};
        MAX_TRANSPILE_OPTIONS = new GeneratorOption[]{ES5plus};
    }

    private GeneratorOption() {
        this.includedOptions = new GeneratorOption[0];
    }

    private GeneratorOption(GeneratorOption ... includedOptions) {
        this.includedOptions = includedOptions;
    }

    public boolean isActiveIn(GeneratorOption ... activeOptions) {
        return GeneratorOption.isActiveIn(this, activeOptions);
    }

    public static final boolean isActiveIn(GeneratorOption optionToTest, GeneratorOption ... activeOptions) {
        return GeneratorOption.isActiveIn((RecursionGuard<GeneratorOption>)new RecursionGuard(), optionToTest, activeOptions);
    }

    private static final boolean isActiveIn(RecursionGuard<GeneratorOption> guard, GeneratorOption optionToTest, GeneratorOption[] activeOptions) {
        int i = 0;
        while (i < activeOptions.length) {
            GeneratorOption activeOption = activeOptions[i];
            if (guard.tryNext((Object)activeOption) && (optionToTest == activeOption || GeneratorOption.isActiveIn(guard, optionToTest, activeOption.includedOptions))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

