/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.N4JSModel;
import org.eclipse.n4js.internal.N4JSProject;
import org.eclipse.n4js.projectDescription.ModuleFilter;
import org.eclipse.n4js.projectDescription.ModuleFilterSpecifier;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;

public class WildcardPathFilterHelper {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private N4JSModel n4jsModel;

    public boolean isPathContainedByFilter(URI location, ModuleFilter filter) {
        for (ModuleFilterSpecifier spec : filter.getModuleSpecifiers()) {
            boolean isContained;
            String prjRelativeLocation = this.getProjectRelativeLocation(location, spec);
            if (prjRelativeLocation == null || !(isContained = this.locationMatchesGlobSpecifier(spec, prjRelativeLocation))) continue;
            return true;
        }
        return false;
    }

    public boolean isPathContainedByFilter(URI location, ModuleFilterSpecifier spec) {
        String prjRelativeLocation = this.getProjectRelativeLocation(location, spec);
        if (prjRelativeLocation != null) {
            return this.locationMatchesGlobSpecifier(spec, prjRelativeLocation);
        }
        return false;
    }

    private String getProjectRelativeLocation(URI location, ModuleFilterSpecifier spec) {
        IN4JSSourceContainer sourceContainer = (IN4JSSourceContainer)this.n4jsCore.findN4JSSourceContainer(location).orNull();
        if (sourceContainer == null) {
            return null;
        }
        N4JSProject project = (N4JSProject)sourceContainer.getProject();
        Path prjLocationPath = Paths.get(project.getLocation().toString(), new String[0]);
        Path locationPath = Paths.get(location.toString(), new String[0]);
        Preconditions.checkState((boolean)locationPath.startsWith(prjLocationPath));
        Path prjRelativeLocationPath = prjLocationPath.relativize(locationPath);
        String filterSrcCont = spec.getSourcePath();
        if (filterSrcCont == null) {
            for (IN4JSSourceContainer srcCont : this.n4jsModel.getN4JSSourceContainers(project)) {
                Path srcContLocationPath = Paths.get(srcCont.getRelativeLocation(), new String[0]);
                if (!prjRelativeLocationPath.startsWith(srcContLocationPath)) continue;
                Path srcRelativeLocationPath = srcContLocationPath.relativize(prjRelativeLocationPath);
                return srcRelativeLocationPath.toString();
            }
        } else if (filterSrcCont.equals(sourceContainer.getRelativeLocation())) {
            Path srcContLocationPath = Paths.get(sourceContainer.getRelativeLocation(), new String[0]);
            Preconditions.checkState((boolean)prjRelativeLocationPath.startsWith(srcContLocationPath));
            Path srcRelativeLocationPath = srcContLocationPath.relativize(prjRelativeLocationPath);
            return srcRelativeLocationPath.toString();
        }
        return null;
    }

    private boolean locationMatchesGlobSpecifier(ModuleFilterSpecifier spec, String prjRelativeLocation) {
        String pathsToFind = spec.getModuleSpecifierWithWildcard();
        if (pathsToFind == null) {
            return false;
        }
        boolean matches = prjRelativeLocation.startsWith(pathsToFind);
        if (!matches) {
            PathMatcher pathMatcher = WildcardPathFilterHelper.createPathMatcher(pathsToFind);
            Path path = Paths.get(prjRelativeLocation, new String[0]);
            matches = pathMatcher.matches(path);
        }
        return matches;
    }

    public static PathMatcher createPathMatcher(String pattern) {
        pattern = pattern.replace("\\", "\\\\");
        pattern = pattern.replace("{", "\\{").replace("}", "\\}");
        pattern = pattern.replace("[", "\\[").replace("]", "\\]");
        return FileSystems.getDefault().getPathMatcher("glob:" + pattern);
    }
}

