/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.results;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.n4js.xpect.ui.results.XpectConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;

public class ConsoleDisplayMgr {
    private static Map<String, XpectConsole> map = new HashMap<String, XpectConsole>();

    public static XpectConsole getOrCreate(String name) {
        XpectConsole console = map.get(name);
        if (console != null) {
            return console;
        }
        MessageConsole lkpMessageConsole = ConsoleDisplayMgr.findMessageConsole(name);
        console = lkpMessageConsole == null ? new XpectConsole(ConsoleDisplayMgr.createMessageConsoleStream(name)) : new XpectConsole(lkpMessageConsole);
        map.put(name, console);
        return console;
    }

    private static MessageConsole findMessageConsole(String title) {
        IConsole[] consoles;
        IConsole[] iConsoleArray = consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole iConsole = iConsoleArray[n2];
            if (iConsole.getName().equals(title)) {
                return (MessageConsole)iConsole;
            }
            ++n2;
        }
        return null;
    }

    private static MessageConsole createMessageConsoleStream(String title) {
        MessageConsole messageConsole = new MessageConsole(title, null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{messageConsole});
        return messageConsole;
    }
}

