/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.sourcemap;

public final class Base64VLQ {
    private static final char[] BASE64_CHARSET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public static String encode(int ... decimals) {
        StringBuilder base64EncodedBytes = new StringBuilder();
        int numIndex = 0;
        while (numIndex < decimals.length) {
            long n;
            int sign = (n = (long)decimals[numIndex++]) < 0L ? 1 : 0;
            n = Math.abs(n);
            byte b = (byte)((n & 0xFL) << 1 | (long)sign);
            n >>= 4;
            while (n > 0L) {
                b = (byte)(b | 0x20);
                base64EncodedBytes.append(Base64VLQ.byteToBase64(b));
                b = (byte)(n & 0x1FL);
                n >>= 5;
            }
            base64EncodedBytes.append(Base64VLQ.byteToBase64(b));
        }
        return base64EncodedBytes.toString();
    }

    public static int[] decode(CharSequence s) {
        if (s == null || s.length() == 0) {
            return new int[0];
        }
        int stringLength = s.length();
        int numCount = 0;
        int i = 0;
        while (i < stringLength) {
            char c = s.charAt(i);
            byte b = Base64VLQ.base64ToByte(c);
            if ((b & 0x20) == 0) {
                ++numCount;
            }
            ++i;
        }
        int[] integers = new int[numCount];
        int charIndex = 0;
        int numIndex = 0;
        while (charIndex < stringLength) {
            char c;
            byte b;
            boolean sign = (byte)((b = Base64VLQ.base64ToByte(c = s.charAt(charIndex++))) & 1) > 0;
            long n = (b & 0x1E) >> 1;
            int shift = 4;
            while ((b & 0x20) > 0) {
                if (charIndex >= stringLength) {
                    throw new IllegalArgumentException("Continuous bit set at last character of string");
                }
                c = s.charAt(charIndex++);
                b = Base64VLQ.base64ToByte(c);
                n += (long)((b & 0x1F) << shift);
                shift = (byte)(shift + 5);
            }
            if (n < Integer.MIN_VALUE || n > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Number exceeds integer range");
            }
            integers[numIndex++] = (int)(sign ? -n : n);
        }
        return integers;
    }

    static char byteToBase64(byte b) {
        return BASE64_CHARSET[b];
    }

    static byte base64ToByte(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (byte)(c - 65);
        }
        if (c >= 'a' && c <= 'z') {
            return (byte)(26 + c - 97);
        }
        if (c >= '0' && c <= '9') {
            return (byte)(52 + c - 48);
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        throw new IllegalArgumentException("Character '" + c + "' is not not in the BASE64 charset.");
    }
}

