/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.fileextensions.FileExtensionType;
import org.eclipse.n4js.fileextensions.FileExtensionsRegistry;
import org.eclipse.n4js.generator.AbstractSubGenerator;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.runner.IExecutor;
import org.eclipse.n4js.runner.IRunner;
import org.eclipse.n4js.runner.RunConfiguration;
import org.eclipse.n4js.runner.RunnerHelper;
import org.eclipse.n4js.runner.RuntimeEnvironmentsHelper;
import org.eclipse.n4js.runner.SystemLoaderInfo;
import org.eclipse.n4js.runner.extension.IRunnerDescriptor;
import org.eclipse.n4js.runner.extension.RunnerRegistry;
import org.eclipse.n4js.runner.extension.RuntimeEnvironment;
import org.eclipse.n4js.utils.ResourceNameComputer;

@Singleton
public class RunnerFrontEnd {
    @Inject
    private IN4JSCore in4jscore;
    @Inject
    private ResourceNameComputer resourceNameComputer;
    @Inject
    private RunnerHelper runnerHelper;
    @Inject
    private RuntimeEnvironmentsHelper hRuntimeEnvironments;
    @Inject
    private RunnerRegistry runnerRegistry;
    @Inject
    private FileExtensionsRegistry fileExtensionsRegistry;

    public boolean canRun(String runnerId, URI moduleToRun) {
        throw new UnsupportedOperationException();
    }

    public RunConfiguration createConfiguration(String runnerId, URI moduleToRun) {
        return this.createConfiguration(runnerId, null, moduleToRun);
    }

    public RunConfiguration createConfiguration(String runnerId, String implementationId, URI moduleToRun) {
        return this.createConfiguration(runnerId, implementationId, null, moduleToRun);
    }

    public RunConfiguration createConfiguration(String runnerId, String implementationId, String systemLoader, URI moduleToRun) {
        IRunnerDescriptor runnerDesc = this.runnerRegistry.getDescriptor(runnerId);
        IRunner runner = runnerDesc.getRunner();
        RunConfiguration config = runner.createConfiguration();
        config.setName(this.runnerHelper.computeConfigurationName(runnerId, moduleToRun));
        config.setRunnerId(runnerId);
        config.setRuntimeEnvironment(runnerDesc.getEnvironment());
        config.setImplementationId(implementationId);
        config.setUserSelection(moduleToRun);
        if (SystemLoaderInfo.fromString(systemLoader) != null) {
            config.setSystemLoader(systemLoader);
        }
        this.computeDerivedValues(config);
        return config;
    }

    public RunConfiguration createConfiguration(String runnerId, String implementationId, String systemLoader, URI moduleToRun, String additionalPath) {
        RunConfiguration runConfig = this.createConfiguration(runnerId, implementationId, systemLoader, moduleToRun);
        runConfig.addAdditionalPath(additionalPath);
        return runConfig;
    }

    public RunConfiguration createConfiguration(Map<String, Object> values) {
        String runnerId = RunConfiguration.getString(values, "RUNNER_ID", false);
        IRunner runner = this.runnerRegistry.getRunner(runnerId);
        RunConfiguration config = runner.createConfiguration();
        config.writePersistentValues(values);
        this.computeDerivedValues(config);
        return config;
    }

    public RunConfiguration createXpectOutputTestConfiguration(String runnerId, String userSelectionNodePathResolvableTargetFileName, SystemLoaderInfo systemLoader, Path additionalProjectPath, String additionalProjectName) {
        IRunnerDescriptor runnerDesc = this.runnerRegistry.getDescriptor(runnerId);
        IRunner runner = runnerDesc.getRunner();
        RunConfiguration config = runner.createConfiguration();
        config.setName(String.valueOf(runnerId) + "__" + userSelectionNodePathResolvableTargetFileName);
        config.setRuntimeEnvironment(runnerDesc.getEnvironment());
        config.setImplementationId(null);
        config.setRunnerId(runnerId);
        config.setSystemLoader(systemLoader.getId());
        config.setUseCustomBootstrap(true);
        config.setCoreProjectPaths((Map<Path, String>)ImmutableMap.of((Object)additionalProjectPath, (Object)additionalProjectName));
        config.setExecutionData("userSelection", userSelectionNodePathResolvableTargetFileName);
        config.setExecutionData("initModules", config.getInitModules());
        IRunner preparedRunner = this.runnerRegistry.getRunner(config);
        preparedRunner.prepareConfiguration(config);
        return config;
    }

    public void computeDerivedValues(RunConfiguration config) {
        this.computeDerivedValues(config, true);
    }

    public void computeDerivedValues(RunConfiguration config, boolean delegateToRunnerCustomization) {
        this.configureDependenciesAndPaths(config);
        this.configureRuntimeEnvironment(config);
        this.configureNeedsCustomBootstrap(config);
        this.configureExecutionData(config);
        if (delegateToRunnerCustomization) {
            IRunner runner = this.runnerRegistry.getRunner(config);
            runner.prepareConfiguration(config);
        }
    }

    private void configureDependenciesAndPaths(RunConfiguration config) {
        RunnerHelper.ApiUsage apiUsage = this.runnerHelper.getProjectExtendedDepsAndApiImplMapping(config.getRuntimeEnvironment(), config.getUserSelection(), config.getImplementationId(), true);
        List<IN4JSProject> deps = apiUsage.projects;
        Map<IN4JSProject, IN4JSProject> apiImplProjectMapping = apiUsage.concreteApiImplProjectMapping;
        config.setApiImplProjectMappingFromProjects(apiImplProjectMapping);
        Set depsImpl = deps.stream().map(p -> {
            IN4JSProject p2 = (IN4JSProject)apiImplProjectMapping.get(p);
            IN4JSProject p3 = p2 != null ? p2 : p;
            return p3;
        }).collect(Collectors.toCollection(() -> Sets.newLinkedHashSet()));
        Map<Path, String> coreProjectPaths = this.runnerHelper.getCoreProjectPaths(depsImpl);
        config.setCoreProjectPaths(coreProjectPaths);
    }

    private void configureExecutionData(RunConfiguration config) {
        URI userSelection = config.getUserSelection();
        if (userSelection != null && this.hasValidFileExtension(userSelection.toString())) {
            String userSelection_targetFileName = this.resourceNameComputer.generateFileDescriptor(userSelection, null);
            IN4JSProject project = this.resolveProject(userSelection);
            String base = AbstractSubGenerator.calculateProjectBasedOutputDirectory((IN4JSProject)project);
            config.setExecutionData("userSelection", String.valueOf(base) + "/" + userSelection_targetFileName);
        } else {
            config.setExecutionData("userSelection", null);
        }
        config.setExecutionData("initModules", config.getInitModules());
        config.setExecutionData("projectNameMapping", config.getApiImplProjectMapping());
    }

    private IN4JSProject resolveProject(URI n4jsSourceURI) {
        Optional optionalProject = this.in4jscore.findProject(n4jsSourceURI);
        if (!optionalProject.isPresent()) {
            throw new RuntimeException("Cannot handle resource without containing project. Resource URI was: " + n4jsSourceURI + ".");
        }
        return (IN4JSProject)optionalProject.get();
    }

    private void configureNeedsCustomBootstrap(RunConfiguration config) {
        boolean useDefaultBootstrap = config.getInitModules().isEmpty() && (config.getExecModule() == null || config.getExecModule().isEmpty());
        config.setUseCustomBootstrap(useDefaultBootstrap);
    }

    private boolean hasValidFileExtension(String fileName) {
        for (String fileExtension : this.fileExtensionsRegistry.getFileExtensions(FileExtensionType.RUNNABLE_FILE_EXTENSION)) {
            if (!fileName.endsWith("." + fileExtension)) continue;
            return true;
        }
        return false;
    }

    private void configureRuntimeEnvironment(RunConfiguration config) {
        this.configureRuntimeEnvironment(config, this.getAllWorkspaceProjects());
    }

    public void configureRuntimeEnvironment(RunConfiguration config, Iterable<IN4JSProject> projects) {
        RuntimeEnvironment runtimeEnvironment = config.getRuntimeEnvironment();
        Optional<IN4JSProject> findRuntimeEnvironmentProject = this.hRuntimeEnvironments.findRuntimeEnvironmentProject(runtimeEnvironment, projects);
        if (findRuntimeEnvironmentProject.isPresent()) {
            IN4JSProject runtimeEnvironmentProject = (IN4JSProject)findRuntimeEnvironmentProject.get();
            List<String> initModulePaths = this.getInitModulesPathsFrom(runtimeEnvironmentProject);
            config.setInitModules(initModulePaths);
            Optional<String> executionModule = this.getExecModulePathFrom(runtimeEnvironmentProject);
            if (executionModule.isPresent()) {
                config.setExecModule((String)executionModule.get());
            }
        }
    }

    private Iterable<IN4JSProject> getAllWorkspaceProjects() {
        return this.in4jscore.findAllProjects();
    }

    private List<String> getInitModulesPathsFrom(IN4JSProject runtimeEnvironment) {
        Set<IN4JSProject> environemntWithAncestors = this.hRuntimeEnvironments.getRuntimeEnvironmentAndAllExtendedEnvironments(runtimeEnvironment);
        return this.runnerHelper.getInitModulePaths(new ArrayList<IN4JSProject>(environemntWithAncestors));
    }

    private Optional<String> getExecModulePathFrom(IN4JSProject runtimeEnvironment) {
        return this.runnerHelper.getExecModuleURI(Arrays.asList(runtimeEnvironment));
    }

    public Process run(String runnerId, String implementationId, URI moduleToRun) {
        return this.run(this.createConfiguration(runnerId, implementationId, moduleToRun));
    }

    public Process run(String runnerId, String implementationId, String systemLoader, URI moduleToRun) {
        return this.run(this.createConfiguration(runnerId, implementationId, systemLoader, moduleToRun));
    }

    public Process run(RunConfiguration config) {
        return this.run(config, this.createDefaultExecutor());
    }

    public Process run(RunConfiguration config, IExecutor executor) {
        return this.runnerRegistry.getRunner(config).run(config, executor);
    }

    public IExecutor createDefaultExecutor() {
        return new IExecutor(){

            @Override
            public Process exec(String[] cmdLine, File workingDirectory, Map<String, String> envp) throws ExecutionException {
                ProcessBuilder pb = new ProcessBuilder(cmdLine);
                pb.environment().putAll(envp);
                pb.directory(workingDirectory);
                pb.inheritIO();
                String errFile = System.getProperty("org.eclipse.n4js.runner.RunnerFrontEnd.ERRORFILE", "");
                String outFile = System.getProperty("org.eclipse.n4js.runner.RunnerFrontEnd.OUTPUTFILE", "");
                if (errFile != null && errFile.length() > 0) {
                    pb.redirectError(ProcessBuilder.Redirect.to(new File(errFile)));
                }
                if (outFile != null && outFile.length() > 0) {
                    pb.redirectOutput(ProcessBuilder.Redirect.to(new File(outFile)));
                }
                try {
                    return pb.start();
                }
                catch (IOException e) {
                    throw new ExecutionException(e);
                }
            }
        };
    }
}

