/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.util;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xpect.expectation.IStringDiffExpectation;
import org.eclipse.xpect.text.StringEndsSimilarityFunction;
import org.eclipse.xpect.text.WhitespaceTokenizer;
import org.eclipse.xpect.util.IDifferencer;
import org.eclipse.xpect.xtext.lib.util.FormattingSequenceAcceptor;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting.IFormatter;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.ISequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.ISyntacticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.TokenStreamSequenceAdapter;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.sequencer.IContextFinder;
import org.eclipse.xtext.serializer.sequencer.IHiddenTokenSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ISyntacticSequencer;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.validation.IConcreteSyntaxValidator;

public class TokenSerializer {
    @Inject
    protected IContextFinder contextFinder;
    @Inject
    protected IFormatter formatter;
    @Inject
    protected IGrammarAccess grammar;
    @Inject
    protected Provider<IHiddenTokenSequencer> hiddenTokenSequencerProvider;
    @Inject
    protected Provider<ISemanticSequencer> semanticSequencerProvider;
    @Inject
    protected Provider<ISyntacticSequencer> syntacticSequencerProvider;
    @Inject
    protected IConcreteSyntaxValidator validator;

    protected ISerializationContext getContext(EObject semanticObject) {
        Iterator contexts = this.contextFinder.findByContentsAndContainer(semanticObject, null).iterator();
        if (!contexts.hasNext()) {
            throw new RuntimeException("No Context for " + EmfFormatter.objPath((EObject)semanticObject) + " could be found");
        }
        return (ISerializationContext)contexts.next();
    }

    public Iterable<ILeafNode> getParsedLeafNodes(XtextResource resource) {
        return resource.getParseResult().getRootNode().getLeafNodes();
    }

    public List<Token> serialize(EObject obj) {
        return this.serialize(obj, SaveOptions.defaultOptions());
    }

    protected void serialize(EObject semanticObject, ISerializationContext context, ISequenceAcceptor tokens, ISerializationDiagnostic.Acceptor errors) {
        ISemanticSequencer semantic = (ISemanticSequencer)this.semanticSequencerProvider.get();
        ISyntacticSequencer syntactic = (ISyntacticSequencer)this.syntacticSequencerProvider.get();
        IHiddenTokenSequencer hidden = (IHiddenTokenSequencer)this.hiddenTokenSequencerProvider.get();
        semantic.init((ISemanticSequenceAcceptor)syntactic, errors);
        syntactic.init(context, semanticObject, (ISyntacticSequenceAcceptor)hidden, errors);
        hidden.init(context, semanticObject, tokens, errors);
        if (tokens instanceof TokenStreamSequenceAdapter) {
            ((TokenStreamSequenceAdapter)tokens).init(context);
        }
        semantic.createSequence(context, semanticObject);
    }

    public List<Token> serialize(EObject obj, SaveOptions options) {
        Acceptor tokenStream = new Acceptor();
        ISerializationDiagnostic.Acceptor errors = ISerializationDiagnostic.EXCEPTION_THROWING_ACCEPTOR;
        FormattingSequenceAcceptor formatterAcceptor = new FormattingSequenceAcceptor(obj, this.formatter, this.grammar.getGrammar(), errors, !options.isFormatting(), tokenStream);
        ISerializationContext context = this.getContext(obj);
        this.serialize(obj, context, formatterAcceptor, errors);
        formatterAcceptor.flush();
        return tokenStream.tokens;
    }

    public static class Acceptor
    implements FormattingSequenceAcceptor.IAcceptor {
        private boolean excluding = false;
        private final List<Token> tokens = new TokenList();

        @Override
        public void accept(EObject semanticElement, EObject grammarElement, String token, boolean hidden) {
            if (token.contains("XPECT")) {
                this.excluding = true;
                return;
            }
            if (hidden) {
                if (this.excluding) {
                    return;
                }
            } else {
                this.excluding = false;
            }
            boolean ignored = hidden;
            int i = 0;
            while (hidden && i < token.length()) {
                if (!Character.isWhitespace(token.charAt(i))) {
                    ignored = false;
                }
                ++i;
            }
            List segments = grammarElement instanceof Keyword ? Collections.singletonList(token) : new WhitespaceTokenizer().apply(token);
            this.tokens.add(new Token(semanticElement, segments, ignored, (IDifferencer.ISimilarityFunction<String>)new StringEndsSimilarityFunction()));
        }
    }

    public static class Token
    implements IStringDiffExpectation.IToken<Token> {
        private final boolean hidden;
        private final Object owner;
        private final Iterable<String> segments;
        private final IDifferencer.ISimilarityFunction<String> similarityFunction;

        public Token(Object owner, Iterable<String> segments, boolean hidden, IDifferencer.ISimilarityFunction<String> similarityFunction) {
            this.owner = owner;
            this.segments = segments;
            this.hidden = hidden;
            this.similarityFunction = similarityFunction;
        }

        public boolean isHidden(String segment) {
            return this.hidden;
        }

        public float similarity(String ownSegment, Token otherToken, String otherSegment) {
            if (this.owner != otherToken.owner) {
                return 1.0f;
            }
            return this.similarityFunction.similarity((Object)ownSegment, (Object)otherSegment);
        }

        public Iterable<String> splitIntoSegments() {
            return this.segments;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("segments", (Object)Lists.newArrayList(this.segments)).add("hidden", this.hidden).add("owner", this.owner).toString();
        }
    }

    public static class TokenList
    extends ArrayList<Token> {
        @Override
        public String toString() {
            StringBuilder result = new StringBuilder();
            for (Token t : this) {
                for (String segment : t.splitIntoSegments()) {
                    result.append(segment);
                }
            }
            return result.toString();
        }
    }
}

