/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.graph;

import java.util.LinkedList;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.eclipse.n4js.smith.CollectedDataAccess;
import org.eclipse.n4js.smith.DataPoint;
import org.eclipse.n4js.smith.DataSeries;
import org.eclipse.n4js.smith.SimpleTimeFormat;
import org.eclipse.n4js.smith.ui.graph.ChartNode;
import org.eclipse.n4js.smith.ui.graph.VisualisationGraph;
import org.eclipse.n4js.smith.ui.graph.VisualisationNode;
import org.eclipse.n4js.smith.ui.graph.VisualisationSnapshot;
import org.eclipse.n4js.utils.IndentLevel;

public class ChartGraphFactory {
    public static VisualisationSnapshot buildGraph(String key, float baseHeight, float baseWidth, String label) {
        DataSeries dataSeries = CollectedDataAccess.getDataSeries((String)key);
        if (dataSeries.hasNoData()) {
            return new VisualisationSnapshot(label, new VisualisationGraph(new VisualisationNode[0]), String.valueOf(label) + " (no data)");
        }
        return ChartGraphFactory.createChartGraph(dataSeries, baseHeight, baseWidth, label);
    }

    private static VisualisationSnapshot createChartGraph(DataSeries series, float baseHeight, float baseWidth, String label) {
        StringJoiner sj = new StringJoiner("\n");
        IndentLevel indent = new IndentLevel("\t");
        List data = series.getData().stream().sorted(ChartGraphFactory::compareDesc).collect(Collectors.toList());
        int size = data.size();
        if (size == 1) {
            sj.add(String.valueOf(indent.get()) + SimpleTimeFormat.convert((long)((DataPoint)data.get((int)0)).nanos) + " - " + series.name);
            float max = ((DataPoint)data.get((int)0)).nanos.floatValue();
            float min = 0.0f;
            LinkedList<Long> data100 = new LinkedList<Long>();
            data100.add(((DataPoint)data.get((int)0)).nanos);
            ChartNode node100 = new ChartNode("100%", "all 100 %", data100, 1.0f, Float.valueOf(min), Float.valueOf(max), baseHeight, baseWidth, 0, 1, size);
            return new VisualisationSnapshot(label, new VisualisationGraph(node100), sj.toString());
        }
        int top20PercentMarker = (int)Math.floor((double)size * 0.2) + 1;
        float max = ((DataPoint)data.get((int)0)).nanos.floatValue();
        float min = ((DataPoint)data.get((int)(size - 1))).nanos.floatValue();
        int i = 0;
        LinkedList<Long> data20 = new LinkedList<Long>();
        sj.add(String.valueOf(indent.get()) + "top 20% :");
        indent.increase();
        DataPoint dataPoint = null;
        while (i < top20PercentMarker) {
            dataPoint = (DataPoint)data.get(i);
            data20.add(dataPoint.nanos);
            sj.add(String.valueOf(indent.get()) + SimpleTimeFormat.convert((long)dataPoint.nanos) + " - " + dataPoint.name);
            ++i;
        }
        LinkedList<Long> dataGap = new LinkedList<Long>();
        dataGap.add(((DataPoint)data.get((int)(i - 1))).nanos);
        dataGap.add(((DataPoint)data.get((int)i)).nanos);
        indent.decrease();
        sj.add(String.valueOf(indent.get()) + "the 80% :");
        indent.increase();
        LinkedList<Long> data80 = new LinkedList<Long>();
        while (i < size) {
            dataPoint = (DataPoint)data.get(i);
            data80.add(dataPoint.nanos);
            sj.add(String.valueOf(indent.get()) + SimpleTimeFormat.convert((long)dataPoint.nanos) + " - " + dataPoint.name);
            ++i;
        }
        ChartNode node20 = new ChartNode("20%", "top 20 %", data20, 0.2f, Float.valueOf(min), Float.valueOf(max), baseHeight, baseWidth, 0, top20PercentMarker, size);
        ChartNode nodeGap = new ChartNode("GAP", "gap<20%, 80%>", dataGap, 0.5f, Float.valueOf(min), Float.valueOf(max), baseHeight, baseWidth, top20PercentMarker - 1, top20PercentMarker + 1, size);
        ChartNode node80 = new ChartNode("80%", "bottom 80 %", data80, 0.8f, Float.valueOf(min), Float.valueOf(max), baseHeight, baseWidth, top20PercentMarker, size, size);
        return new VisualisationSnapshot(label, new VisualisationGraph(node20, nodeGap, node80), sj.toString());
    }

    private static int compareDesc(DataPoint data1, DataPoint data2) {
        return Long.compare(data2.nanos, data1.nanos);
    }
}

