/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.containers;

import com.google.common.collect.FluentIterable;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.fileextensions.FileExtensionTypeHelper;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ui.containers.N4JSProjectsStateHelper;
import org.eclipse.xtext.ui.containers.AbstractAllContainersState;

@Singleton
public class N4JSAllContainersState
extends AbstractAllContainersState {
    private static final Logger LOGGER = Logger.getLogger(N4JSAllContainersState.class);
    private static final String PLATFORM_RESOURCE_SCHEME = "platform:/resource";
    @Inject
    private N4JSProjectsStateHelper projectsHelper;
    @Inject
    private FileExtensionTypeHelper fileExtensionTypeHelper;
    @Inject
    private IN4JSCore core;

    protected String doInitHandle(URI uri) {
        String handle = this.projectsHelper.initHandle(uri);
        return handle;
    }

    protected Collection<URI> doInitContainedURIs(String containerHandle) {
        Collection<URI> initContainedURIs = this.projectsHelper.initContainedURIs(containerHandle);
        return initContainedURIs;
    }

    protected List<String> doInitVisibleHandles(String handle) {
        List<String> visibleHandles = this.projectsHelper.initVisibleHandles(handle);
        return visibleHandles;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.updateProjectState(event);
        super.resourceChanged(event);
    }

    private void updateProjectState(IResourceChangeEvent event) {
        if (event.getDelta() != null) {
            IResourceDelta eventDelta = event.getDelta();
            try {
                final AtomicBoolean mustClear = new AtomicBoolean(false);
                eventDelta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource == null) {
                            return true;
                        }
                        IPath path = resource.getFullPath();
                        int pathLength = path.segmentCount();
                        if (pathLength <= 2 && N4JSAllContainersState.this.updateProjectState(delta)) {
                            mustClear.set(true);
                            return false;
                        }
                        return pathLength == 0 || resource instanceof IProject;
                    }
                });
                if (mustClear.get()) {
                    this.projectsHelper.clearProjectCache();
                }
            }
            catch (CoreException e) {
                LOGGER.error((Object)"Failed to process IResourceDelta", (Throwable)e);
            }
        }
    }

    private boolean updateProjectState(IResourceDelta delta) {
        if (delta.getKind() == 1 || delta.getKind() == 2) {
            if ("package.json".equals(delta.getFullPath().lastSegment())) {
                return true;
            }
            if (delta.getResource() instanceof IProject) {
                return true;
            }
            return delta.getResource() instanceof IFolder && this.isSourceContainerModification(delta);
        }
        if (delta.getKind() == 4) {
            if (delta.getResource() instanceof IProject) {
                return (delta.getFlags() & 0x4000) != 0;
            }
            if (delta.getResource() instanceof IFolder) {
                return "node_modules".equals(delta.getFullPath().lastSegment());
            }
        }
        return this.packageJSONFileHasBeenChanged(delta);
    }

    protected boolean isAffectingContainerState(IResourceDelta delta) {
        if (delta.getKind() == 1 || delta.getKind() == 2) {
            String fileExtension = delta.getFullPath().getFileExtension();
            if (fileExtension != null && this.fileExtensionTypeHelper.isTypable(fileExtension)) {
                return true;
            }
            if ("package.json".equals(delta.getFullPath().lastSegment())) {
                return true;
            }
            if (delta.getResource() instanceof IProject) {
                return true;
            }
            return delta.getResource() instanceof IFolder && this.isSourceContainerModification(delta);
        }
        if (delta.getKind() == 4 && delta.getResource() instanceof IProject) {
            if ((delta.getFlags() & 0x80000) != 0) {
                return true;
            }
            return (delta.getFlags() & 0x4000) != 0;
        }
        return this.packageJSONFileHasBeenChanged(delta);
    }

    private boolean isSourceContainerModification(IResourceDelta delta) {
        String fullPathStr = delta.getFullPath().toString();
        URI folderUri = URI.createPlatformResourceURI((String)fullPathStr, (boolean)true);
        IN4JSProject project = (IN4JSProject)this.core.findProject(folderUri).orNull();
        if (project != null && project.exists()) {
            return FluentIterable.from((Iterable)project.getSourceContainers()).transform(container -> container.getLocation()).filter(uri -> uri.isPlatformResource()).transform(uri -> uri.toString()).transform(uri -> uri.replaceFirst(PLATFORM_RESOURCE_SCHEME, "")).firstMatch(uri -> uri.equals(fullPathStr)).isPresent();
        }
        return false;
    }

    private boolean packageJSONFileHasBeenChanged(IResourceDelta delta) {
        return delta.getKind() == 4 && delta.getResource().getType() == 1 && "package.json".equalsIgnoreCase(delta.getFullPath().lastSegment());
    }
}

