/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.preferences;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.n4js.generator.CompilerDescriptor;
import org.eclipse.n4js.generator.CompilerProperties;
import org.eclipse.n4js.generator.ICompositeGenerator;
import org.eclipse.n4js.utils.ComponentDescriptor;
import org.eclipse.xtext.builder.preferences.BuilderPreferenceAccess;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreInitializer;

@Singleton
public class N4JSBuilderPreferenceAccess
extends BuilderPreferenceAccess {
    private IPreferenceStoreAccess preferenceStoreAccess;
    @Inject
    private ICompositeGenerator compositeGenerator;

    @Inject
    public void setPreferenceStoreAccess(IPreferenceStoreAccess preferenceStoreAccess) {
        this.preferenceStoreAccess = preferenceStoreAccess;
    }

    public boolean isAutoBuildEnabled(Object context) {
        return true;
    }

    public void setAutoBuildEnabled(Object context, boolean enabled) {
        IPreferenceStore preferenceStore = this.preferenceStoreAccess.getWritablePreferenceStore(context);
        String key = null;
        for (CompilerDescriptor compilerDescriptor : this.compositeGenerator.getCompilerDescriptors()) {
            key = CompilerProperties.IS_ACTIVE.getKey(compilerDescriptor.getIdentifier());
            preferenceStore.setValue(key, enabled);
        }
    }

    public static class Initializer
    implements IPreferenceStoreInitializer {
        @Inject
        private ICompositeGenerator compositeGenerator;

        public void initialize(IPreferenceStoreAccess preferenceStoreAccess) {
            IPreferenceStore store = preferenceStoreAccess.getWritablePreferenceStore();
            this.intializeBuilderPreferences(store);
        }

        private void intializeBuilderPreferences(IPreferenceStore store) {
            for (CompilerDescriptor compilerDescriptor : this.compositeGenerator.getCompilerDescriptors()) {
                CompilerProperties[] compilerPropertiesArray = CompilerProperties.values();
                int n = compilerPropertiesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CompilerProperties prop = compilerPropertiesArray[n2];
                    if (prop.getType() == Boolean.class) {
                        store.setDefault(prop.getKey(compilerDescriptor.getIdentifier()), ((Boolean)prop.getValueInCompilerDescriptor((ComponentDescriptor)compilerDescriptor, compilerDescriptor.getIdentifier())).booleanValue());
                    } else {
                        store.setDefault(prop.getKey(compilerDescriptor.getIdentifier()), (String)prop.getValueInCompilerDescriptor((ComponentDescriptor)compilerDescriptor, compilerDescriptor.getIdentifier()));
                    }
                    ++n2;
                }
            }
        }
    }
}

