/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.parameter;

import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.parameter.DerivedRegion;
import org.eclipse.xpect.parameter.IStatementRelatedRegion;
import org.eclipse.xpect.text.CharSequences;
import org.eclipse.xpect.text.IRegion;

public class OffsetRegion
extends DerivedRegion {
    private final int matchedOffset;
    private final DerivedRegion matchedRegion;

    public OffsetRegion(IStatementRelatedRegion origin, int matchedOffset) {
        super(origin, -1, -1);
        this.matchedRegion = null;
        this.matchedOffset = matchedOffset;
    }

    public OffsetRegion(IStatementRelatedRegion origin, int offset, int length) {
        super(origin, offset, length);
        String val = this.getRegionText();
        int add = val.indexOf(124);
        if (add >= 0) {
            val = String.valueOf(val.substring(0, add)) + val.substring(add + 1);
        } else {
            add = 0;
        }
        XpectInvocation statement = this.getStatement();
        IStatementRelatedRegion extendedRegion = statement.getExtendedRegion();
        int nodeOffset = extendedRegion.getOffset() + extendedRegion.getLength();
        String text = statement.getFile().getDocument();
        int result = -1;
        do {
            result = text.indexOf(val, nodeOffset);
            nodeOffset = result + 1;
        } while (statement.getFile().getInvocationAt(result) != null);
        if (result >= 0) {
            this.matchedOffset = result + add;
            this.matchedRegion = add > 0 ? this.createMatchedRegion(result, length - 1) : this.createMatchedRegion(result, length);
        } else {
            throw new RuntimeException("OFFSET '" + val + "' not found.");
        }
    }

    private DerivedRegion createMatchedRegion(int offset, int length) {
        return new DerivedRegion(this, offset, length);
    }

    public int getMatchedOffset() {
        return this.matchedOffset;
    }

    public IRegion getMatchedRegion() {
        return this.matchedRegion;
    }

    @Override
    public String toString() {
        if (this.matchedOffset < 0 || this.matchedRegion == null) {
            return "(not available)";
        }
        int offset = this.matchedRegion.getOffset();
        int end = offset + this.matchedRegion.getLength();
        CharSequence document = this.getDocument();
        String prefix = CharSequences.getPrefix(document, offset, 24);
        String postfix = CharSequences.getPostfix(document, end, 24);
        String before = document.subSequence(offset, this.matchedOffset).toString();
        String after = document.subSequence(this.matchedOffset, end).toString();
        return String.valueOf(prefix) + ">>>" + before + "|" + after + "<<<" + postfix;
    }
}

