/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.BreakStatement;
import org.eclipse.n4js.n4JS.ContinueStatement;
import org.eclipse.n4js.n4JS.DebuggerStatement;
import org.eclipse.n4js.n4JS.DoStatement;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.GenericDeclaration;
import org.eclipse.n4js.n4JS.IfStatement;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4JSFeatureUtils;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.SwitchStatement;
import org.eclipse.n4js.n4JS.ThrowStatement;
import org.eclipse.n4js.n4JS.TryStatement;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.n4JS.WhileStatement;
import org.eclipse.n4js.n4JS.WithStatement;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.MemberType;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ts.types.util.Variance;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.Result;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.n4js.validation.AbstractMessageAdjustingN4JSValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.N4JSElementKeywordProvider;
import org.eclipse.n4js.validation.ValidatorMessageHelper;
import org.eclipse.xtext.nodemodel.BidiIterable;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public abstract class AbstractN4JSDeclarativeValidator
extends AbstractMessageAdjustingN4JSValidator {
    @Inject
    @Extension
    protected N4JSElementKeywordProvider keywordProvider;
    @Inject
    @Extension
    protected ValidatorMessageHelper validatorMessageHelper;
    @Inject
    private N4JSGrammarAccess grammarAccess;
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private TypeSystemHelper tsh;
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public AbstractMessageAdjustingN4JSValidator.MethodWrapperCancelable createMethodWrapper(AbstractDeclarativeValidator instanceToUse, Method method) {
        abstract class __AbstractN4JSDeclarativeValidator_1
        extends AbstractMessageAdjustingN4JSValidator.MethodWrapperCancelable {
            __AbstractN4JSDeclarativeValidator_1(AbstractDeclarativeValidator instance, Method m) {
                super(instance, m);
            }

            abstract boolean shouldInvoke(AbstractDeclarativeValidator.State var1);
        }
        return new __AbstractN4JSDeclarativeValidator_1(this, instanceToUse, method){
            {
                super($anonymous0, $anonymous1);
            }

            public void invoke(AbstractDeclarativeValidator.State state) {
                operationCanceledManager.checkCanceled(this.getCancelIndicator(state));
                boolean _shouldInvoke = this.shouldInvoke(state);
                if (_shouldInvoke) {
                    super.invoke(state);
                }
            }

            @Override
            boolean shouldInvoke(AbstractDeclarativeValidator.State state) {
                boolean _tripleNotEquals;
                EObject _currentObject = state.currentObject;
                Resource _eResource = null;
                if (_currentObject != null) {
                    _eResource = _currentObject.eResource();
                }
                boolean bl = _tripleNotEquals = _eResource != null;
                if (_tripleNotEquals) {
                    boolean _not;
                    boolean _isNoValidate = n4jsCore.isNoValidate(state.currentObject.eResource().getURI());
                    boolean bl2 = _not = !_isNoValidate;
                    if (_not) {
                        return true;
                    }
                }
                return false;
            }

            public void handleInvocationTargetException(Throwable targetException, AbstractDeclarativeValidator.State state) {
                super.handleInvocationTargetException(targetException, state);
                if (targetException instanceof NullPointerException) {
                    Exceptions.sneakyThrow((Throwable)targetException);
                }
            }
        };
    }

    protected void internalCheckTypeArguments(List<? extends TypeVariable> typeVars, List<? extends TypeArgument> typeArgs, boolean allowAutoInference, IdentifiableElement parameterizedElement, EObject source, EStructuralFeature feature) {
        int typeParameterCount = typeVars.size();
        int typeArgumentCount = typeArgs.size();
        if (allowAutoInference && typeArgumentCount == 0) {
            return;
        }
        if (typeParameterCount != typeArgumentCount) {
            if (parameterizedElement != null && parameterizedElement.getName() != null) {
                String message = IssueCodes.getMessageForEXP_WRONG_NUMBER_OF_TYPEARGS_FOR_ELEMENT(this.keywordProvider.keyword(parameterizedElement), parameterizedElement.getName(), typeParameterCount, typeArgumentCount);
                this.addIssue(message, source, feature, "EXP_WRONG_NUMBER_OF_TYPEARGS_FOR_ELEMENT", new String[0]);
            } else {
                String message_1 = IssueCodes.getMessageForEXP_WRONG_NUMBER_OF_TYPEARGS(typeParameterCount, typeArgumentCount);
                this.addIssue(message_1, source, feature, "EXP_WRONG_NUMBER_OF_TYPEARGS", new String[0]);
            }
            return;
        }
        int minTypeVariables = Math.min(typeParameterCount, typeArgumentCount);
        if (minTypeVariables != 0) {
            RuleEnvironment G_subst = RuleEnvironmentExtensions.newRuleEnvironment(source);
            if (source instanceof ParameterizedPropertyAccessExpression) {
                RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment(source);
                TypeRef targetTypeRef = this.ts.type(G, (TypableElement)((ParameterizedPropertyAccessExpression)source).getTarget());
                this.tsh.addSubstitutions(G_subst, targetTypeRef);
            }
            int _size = typeArgs.size();
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
            Iterator iterator = _doubleDotLessThan.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                RuleEnvironmentExtensions.addTypeMapping(G_subst, typeVars.get(i), typeArgs.get(i));
            }
            ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, minTypeVariables, true);
            Iterator iterator2 = _doubleDotLessThan_1.iterator();
            while (iterator2.hasNext()) {
                TypeRef _typeVariableImplicitUpperBound;
                boolean isExceptionCase;
                int i_1 = (Integer)iterator2.next();
                TypeVariable typeParameter = typeVars.get(i_1);
                TypeArgument typeArgument = typeArgs.get(i_1);
                if (typeArgument instanceof Wildcard) {
                    boolean _tripleNotEquals;
                    Variance defSiteVariance = typeParameter.getVariance();
                    Variance _xifexpression = null;
                    TypeRef _declaredUpperBound = ((Wildcard)typeArgument).getDeclaredUpperBound();
                    boolean bl = _tripleNotEquals = _declaredUpperBound != null;
                    if (_tripleNotEquals) {
                        _xifexpression = Variance.CO;
                    } else {
                        boolean _tripleNotEquals_1;
                        Variance _xifexpression_1 = null;
                        TypeRef _declaredLowerBound = ((Wildcard)typeArgument).getDeclaredLowerBound();
                        boolean bl2 = _tripleNotEquals_1 = _declaredLowerBound != null;
                        if (_tripleNotEquals_1) {
                            _xifexpression_1 = Variance.CONTRA;
                        }
                        _xifexpression = _xifexpression_1;
                    }
                    Variance useSiteVariance = _xifexpression;
                    if (defSiteVariance != Variance.INV && useSiteVariance != null && useSiteVariance != defSiteVariance) {
                        boolean _isUsingInOutNotation = ((Wildcard)typeArgument).isUsingInOutNotation();
                        if (_isUsingInOutNotation) {
                            String message_2 = IssueCodes.getMessageForEXP_INCONSISTENT_VARIANCE_OF_TYPE_ARG_IN_OUT(useSiteVariance.getDescriptiveStringNoun(true), defSiteVariance.getDescriptiveStringNoun(true));
                            this.addIssue(message_2, (EObject)typeArgument, "EXP_INCONSISTENT_VARIANCE_OF_TYPE_ARG_IN_OUT");
                        } else {
                            String _xifexpression_2 = null;
                            _xifexpression_2 = useSiteVariance == Variance.CO ? "upper" : "lower";
                            String message_3 = IssueCodes.getMessageForEXP_INCONSISTENT_VARIANCE_OF_TYPE_ARG(_xifexpression_2, defSiteVariance.getDescriptiveString(true));
                            this.addIssue(message_3, (EObject)typeArgument, "EXP_INCONSISTENT_VARIANCE_OF_TYPE_ARG");
                        }
                    }
                }
                if (isExceptionCase = TypeUtils.isVoid((TypeArgument)typeArgument)) continue;
                TypeRef _elvis = null;
                TypeRef _declaredUpperBound_1 = typeParameter.getDeclaredUpperBound();
                _elvis = _declaredUpperBound_1 != null ? _declaredUpperBound_1 : (_typeVariableImplicitUpperBound = N4JSLanguageUtils.getTypeVariableImplicitUpperBound(G_subst));
                TypeRef upperBound = _elvis;
                TypeRef substituted = this.ts.substTypeVariables(G_subst, upperBound);
                Result result = this.ts.subtype(G_subst, typeArgument, (TypeArgument)substituted);
                boolean _isFailure = result.isFailure();
                if (!_isFailure) continue;
                this.createTypeError(result, (EObject)typeArgument);
            }
        }
    }

    protected <T extends GenericDeclaration & FunctionDefinition> void internalCheckNoUnusedTypeParameters(T genericFunctionOrMethod) {
        boolean _tripleEquals;
        Type _definedType = genericFunctionOrMethod.getDefinedType();
        boolean bl = _tripleEquals = _definedType == null;
        if (_tripleEquals) {
            return;
        }
        Type _definedType_1 = genericFunctionOrMethod.getDefinedType();
        TFunction functionType = (TFunction)_definedType_1;
        this.internalCheckNoUnusedTypeParameters((EObject)genericFunctionOrMethod, (EList<TypeVariable>)genericFunctionOrMethod.getTypeVars(), (EList<TypeVariable>)functionType.getTypeVars());
    }

    protected void internalCheckNoUnusedTypeParameters(FunctionTypeExpression functionTypeExp) {
        boolean _tripleEquals;
        TFunction _declaredType = functionTypeExp.getDeclaredType();
        boolean bl = _tripleEquals = _declaredType == null;
        if (_tripleEquals) {
            return;
        }
        TFunction declaredType = functionTypeExp.getDeclaredType();
        this.internalCheckNoUnusedTypeParameters((EObject)functionTypeExp, (EList<TypeVariable>)functionTypeExp.getOwnedTypeVars(), (EList<TypeVariable>)declaredType.getTypeVars());
    }

    private void internalCheckNoUnusedTypeParameters(EObject root, EList<TypeVariable> actualTypeVars, EList<TypeVariable> declaredTypeVars) {
        int typeVarCount = Math.min(actualTypeVars.size(), declaredTypeVars.size());
        if (typeVarCount == 1) {
            boolean _not;
            TypeVariable actualTypeVar = (TypeVariable)actualTypeVars.get(0);
            TypeVariable declaredTypeVar = (TypeVariable)declaredTypeVars.get(0);
            boolean _isOrContainsRefToTypeVar = TypeUtils.isOrContainsRefToTypeVar((EObject)root, (TypeVariable[])new TypeVariable[]{declaredTypeVar});
            boolean bl = _not = !_isOrContainsRefToTypeVar;
            if (_not) {
                this.addIssue(IssueCodes.getMessageForFUN_UNUSED_GENERIC_TYPE_PARAM(actualTypeVar.getName()), (EObject)actualTypeVar, (EStructuralFeature)TypesPackage.Literals.IDENTIFIABLE_ELEMENT__NAME, "FUN_UNUSED_GENERIC_TYPE_PARAM", new String[0]);
            }
        } else if (typeVarCount > 1) {
            Set referencedTypeVars = TypeUtils.getReferencedTypeVars((EObject)root);
            int i = 0;
            while (i < typeVarCount) {
                boolean _not_1;
                TypeVariable actualTypeVar_1 = (TypeVariable)actualTypeVars.get(i);
                TypeVariable declaredTypeVar_1 = (TypeVariable)declaredTypeVars.get(i);
                boolean _contains = referencedTypeVars.contains(declaredTypeVar_1);
                boolean bl = _not_1 = !_contains;
                if (_not_1) {
                    this.addIssue(IssueCodes.getMessageForFUN_UNUSED_GENERIC_TYPE_PARAM(actualTypeVar_1.getName()), (EObject)actualTypeVar_1, (EStructuralFeature)TypesPackage.Literals.IDENTIFIABLE_ELEMENT__NAME, "FUN_UNUSED_GENERIC_TYPE_PARAM", new String[0]);
                }
                ++i;
            }
        }
    }

    protected List<TClassifier> findCyclicInheritance(TClassifier classifier) {
        Function<TClassifier, Iterable> _function = it -> {
            List _xifexpression = null;
            if (it instanceof TClass) {
                List _xifexpression_1 = null;
                ParameterizedTypeRef _superClassRef = ((TClass)it).getSuperClassRef();
                Type _declaredType = null;
                if (_superClassRef != null) {
                    _declaredType = _superClassRef.getDeclaredType();
                }
                if (_declaredType instanceof TClass) {
                    Type _declaredType_1 = ((TClass)it).getSuperClassRef().getDeclaredType();
                    _xifexpression_1 = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TClassifier[]{(TClassifier)_declaredType_1}));
                } else {
                    _xifexpression_1 = Collections.unmodifiableList(CollectionLiterals.newArrayList());
                }
                _xifexpression = _xifexpression_1;
            } else {
                Functions.Function1 _function_1 = it_1 -> it_1.getDeclaredType();
                _xifexpression = Iterables.filter((Iterable)IterableExtensions.map((Iterable)it.getSuperClassifierRefs(), (Functions.Function1)_function_1), TClassifier.class);
            }
            return _xifexpression;
        };
        return UtilN4.findCycleInDirectedGraph((Object)classifier, _function);
    }

    public static boolean isConstructor(TMember tMember) {
        boolean _xifexpression = false;
        _xifexpression = tMember instanceof TMethod ? ((TMethod)tMember).isConstructor() : false;
        return _xifexpression;
    }

    public boolean isAbstract(TClassifier classifier) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (classifier instanceof TClass) {
            _matched = true;
            _switchResult = ((TClass)classifier).isAbstract();
        }
        if (!_matched && classifier instanceof TInterface) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public boolean isDeclaredAbstract(TMember member) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (member instanceof TMethod) {
            _matched = true;
            _switchResult = ((TMethod)member).isDeclaredAbstract();
        }
        if (!_matched && member instanceof TGetter) {
            _matched = true;
            _switchResult = ((TGetter)member).isDeclaredAbstract();
        }
        if (!_matched && member instanceof TSetter) {
            _matched = true;
            _switchResult = ((TSetter)member).isDeclaredAbstract();
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public Block getBody(N4MemberDeclaration n4MemberDeclaration) {
        Block _switchResult = null;
        boolean _matched = false;
        if (n4MemberDeclaration instanceof N4MethodDeclaration) {
            _matched = true;
            _switchResult = ((N4MethodDeclaration)n4MemberDeclaration).getBody();
        }
        if (!_matched && n4MemberDeclaration instanceof N4GetterDeclaration) {
            _matched = true;
            _switchResult = ((N4GetterDeclaration)n4MemberDeclaration).getBody();
        }
        if (!_matched && n4MemberDeclaration instanceof N4SetterDeclaration) {
            _matched = true;
            _switchResult = ((N4SetterDeclaration)n4MemberDeclaration).getBody();
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    public boolean hasAnnotation(AnnotableElement elem, String annotationName) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equal((Object)_name, (Object)annotationName);
        };
        return IterableExtensions.exists((Iterable)elem.getAnnotations(), (Functions.Function1)_function);
    }

    public void error(String message, EObject source, EStructuralFeature feature, int index, String code, String ... issueData) {
        throw new UnsupportedOperationException("Don't use error(...) anymore, but addIssue");
    }

    public void warning(String message, EObject source, EStructuralFeature feature, int index, String code, String ... issueData) {
        throw new UnsupportedOperationException("Don't use warning(...) anymore, but addIssue");
    }

    public void info(String message, EObject source, EStructuralFeature feature, int index, String code, String ... issueData) {
        throw new UnsupportedOperationException("Don't use info(...) anymore, but addIssue");
    }

    public Pair<? extends EObject, ? extends EStructuralFeature> findNameFeature(EObject eo) {
        EStructuralFeature attribute;
        if (eo instanceof NamedElement && (attribute = N4JSFeatureUtils.attributeOfNameFeature((NamedElement)((NamedElement)eo))) != null) {
            return Pair.of((Object)((NamedElement)eo), (Object)attribute);
        }
        Pair _xifexpression = null;
        if (eo instanceof ExportDeclaration) {
            _xifexpression = this.findNameFeature((EObject)((ExportDeclaration)eo).getExportedElement());
        } else {
            Pair _xifexpression_1 = null;
            if (eo instanceof IdentifiableElement) {
                _xifexpression_1 = Pair.of((Object)((IdentifiableElement)eo), (Object)TypesPackage.Literals.IDENTIFIABLE_ELEMENT__NAME);
            } else {
                Pair<? extends EObject, ? extends EStructuralFeature> _xifexpression_2 = null;
                if (eo instanceof VariableStatement) {
                    Pair<? extends EObject, ? extends EStructuralFeature> _xblockexpression = null;
                    VariableDeclaration varDecl = (VariableDeclaration)IterableExtensions.head((Iterable)((VariableStatement)eo).getVarDecl());
                    _xifexpression_2 = _xblockexpression = this.findNameFeature((EObject)varDecl);
                } else {
                    _xifexpression_2 = null;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        Pair eObjectToNameFeature = _xifexpression;
        return eObjectToNameFeature;
    }

    public Pair<Integer, Integer> findOffsetAndLength(EObject eo) {
        Pair offsetAndLength;
        Pair _xblockexpression = null;
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)eo);
        INode _xifexpression = null;
        if (eo instanceof Block) {
            _xifexpression = this.findChildNode(node, (EObject)this.grammarAccess.getBlockAccess().getLeftCurlyBracketKeyword_0_0_1());
        } else {
            INode _xifexpression_1 = null;
            if (eo instanceof IfStatement) {
                _xifexpression_1 = this.findChildNode(node, (EObject)this.grammarAccess.getIfStatementAccess().getIfKeyword_0());
            } else {
                INode _xifexpression_2 = null;
                if (eo instanceof DoStatement) {
                    _xifexpression_2 = this.findChildNode(node, (EObject)this.grammarAccess.getDoStatementAccess().getDoKeyword_0());
                } else {
                    INode _xifexpression_3 = null;
                    if (eo instanceof WhileStatement) {
                        _xifexpression_3 = this.findChildNode(node, (EObject)this.grammarAccess.getWhileStatementAccess().getWhileKeyword_0());
                    } else {
                        INode _xifexpression_4 = null;
                        if (eo instanceof ForStatement) {
                            _xifexpression_4 = this.findChildNode(node, (EObject)this.grammarAccess.getForStatementAccess().getForKeyword_1());
                        } else {
                            INode _xifexpression_5 = null;
                            if (eo instanceof ContinueStatement) {
                                _xifexpression_5 = this.findChildNode(node, (EObject)this.grammarAccess.getContinueStatementAccess().getContinueKeyword_1());
                            } else {
                                INode _xifexpression_6 = null;
                                if (eo instanceof BreakStatement) {
                                    _xifexpression_6 = this.findChildNode(node, (EObject)this.grammarAccess.getBreakStatementAccess().getBreakKeyword_1());
                                } else {
                                    INode _xifexpression_7 = null;
                                    if (eo instanceof ReturnStatement) {
                                        _xifexpression_7 = this.findChildNode(node, (EObject)this.grammarAccess.getReturnStatementAccess().getReturnKeyword_1());
                                    } else {
                                        INode _xifexpression_8 = null;
                                        if (eo instanceof WithStatement) {
                                            _xifexpression_8 = this.findChildNode(node, (EObject)this.grammarAccess.getWithStatementAccess().getWithKeyword_0());
                                        } else {
                                            INode _xifexpression_9 = null;
                                            if (eo instanceof SwitchStatement) {
                                                _xifexpression_9 = this.findChildNode(node, (EObject)this.grammarAccess.getSwitchStatementAccess().getSwitchKeyword_0());
                                            } else {
                                                INode _xifexpression_10 = null;
                                                if (eo instanceof ThrowStatement) {
                                                    _xifexpression_10 = this.findChildNode(node, (EObject)this.grammarAccess.getThrowStatementAccess().getThrowKeyword_0());
                                                } else {
                                                    INode _xifexpression_11 = null;
                                                    if (eo instanceof TryStatement) {
                                                        _xifexpression_11 = this.findChildNode(node, (EObject)this.grammarAccess.getTryStatementAccess().getTryKeyword_0());
                                                    } else {
                                                        INode _xifexpression_12 = null;
                                                        if (eo instanceof DebuggerStatement) {
                                                            _xifexpression_12 = this.findChildNode(node, (EObject)this.grammarAccess.getDebuggerStatementAccess().getDebuggerKeyword_1());
                                                        }
                                                        _xifexpression_11 = _xifexpression_12;
                                                    }
                                                    _xifexpression_10 = _xifexpression_11;
                                                }
                                                _xifexpression_9 = _xifexpression_10;
                                            }
                                            _xifexpression_8 = _xifexpression_9;
                                        }
                                        _xifexpression_7 = _xifexpression_8;
                                    }
                                    _xifexpression_6 = _xifexpression_7;
                                }
                                _xifexpression_5 = _xifexpression_6;
                            }
                            _xifexpression_4 = _xifexpression_5;
                        }
                        _xifexpression_3 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        INode childNode = _xifexpression;
        Pair _xifexpression_13 = null;
        if (childNode != null) {
            int _offset = childNode.getOffset();
            int _length = childNode.getLength();
            _xifexpression_13 = Pair.of((Object)_offset, (Object)_length);
        } else {
            int _offset_1 = node.getOffset();
            int _length_1 = node.getLength();
            _xifexpression_13 = Pair.of((Object)_offset_1, (Object)_length_1);
        }
        _xblockexpression = offsetAndLength = _xifexpression_13;
        return _xblockexpression;
    }

    public Pair<Integer, Integer> findListFeatureOffsetAndLength(EObject obj, EStructuralFeature feature) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)obj, (EStructuralFeature)feature);
        boolean _isEmpty = nodes.isEmpty();
        if (_isEmpty) {
            return Pair.of((Object)0, (Object)0);
        }
        int start = ((INode)IterableExtensions.head((Iterable)nodes)).getOffset();
        int _offset = ((INode)IterableExtensions.last((Iterable)nodes)).getOffset();
        int _length = ((INode)IterableExtensions.last((Iterable)nodes)).getLength();
        int end = _offset + _length;
        return Pair.of((Object)start, (Object)(end - start));
    }

    protected void addIssueToMultiValueFeature(String message, EObject source, EStructuralFeature feature, String issueCode, String ... issueData) {
        Pair<Integer, Integer> offsetAndLength = this.findListFeatureOffsetAndLength(source, feature);
        this.addIssue(message, source, (Integer)offsetAndLength.getKey(), (Integer)offsetAndLength.getValue(), issueCode, issueData);
    }

    private INode findChildNode(ICompositeNode compositeNode, EObject grammarElement) {
        BidiIterable _children = compositeNode.getChildren();
        for (INode childNode : _children) {
            INode foundNode;
            EObject _grammarElement = childNode.getGrammarElement();
            boolean _equals = Objects.equal((Object)_grammarElement, (Object)grammarElement);
            if (_equals) {
                return childNode;
            }
            if (!(childNode instanceof ICompositeNode) || (foundNode = this.findChildNode((ICompositeNode)childNode, grammarElement)) == null) continue;
            return foundNode;
        }
        return null;
    }

    protected boolean isFieldAccessorPair(TMember member, TMember member2) {
        MemberType mt1 = member.getMemberType();
        MemberType mt2 = member2.getMemberType();
        return mt1 == MemberType.GETTER && mt2 == MemberType.SETTER || mt1 == MemberType.SETTER && mt2 == MemberType.GETTER;
    }

    protected boolean isFieldAccessorPair(Iterable<TMember> members) {
        boolean _not_1;
        boolean _not;
        Iterator<TMember> iter = members.iterator();
        boolean _hasNext = iter.hasNext();
        boolean bl = _not = !_hasNext;
        if (_not) {
            return false;
        }
        TMember m1 = iter.next();
        boolean _hasNext_1 = iter.hasNext();
        boolean bl2 = _not_1 = !_hasNext_1;
        if (_not_1) {
            return false;
        }
        TMember m2 = iter.next();
        boolean _hasNext_2 = iter.hasNext();
        if (_hasNext_2) {
            return false;
        }
        return this.isFieldAccessorPair(m1, m2);
    }
}

