/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.adoc;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.jsdoc2spec.RepoRelativePath;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.ts.types.TModule;

public class RepoRelativePathHolder {
    @Inject
    private IN4JSCore n4jscore;
    private final Map<Resource, RepoRelativePath> modulesToRepoCache = new HashMap<Resource, RepoRelativePath>();

    public RepoRelativePath get(IdentifiableElement idElement) {
        Resource res = this.evadeStaticPolyfillResource(idElement);
        if (res != null) {
            RepoRelativePath rrpRes;
            if (!this.modulesToRepoCache.containsKey(res) && (rrpRes = RepoRelativePath.compute(res.getURI(), this.n4jscore)) != null) {
                this.modulesToRepoCache.put(res, rrpRes);
            }
            if ((rrpRes = this.modulesToRepoCache.get(res)) != null && idElement instanceof SyntaxRelatedTElement) {
                return rrpRes.withLine((SyntaxRelatedTElement)idElement);
            }
        }
        return null;
    }

    private Resource evadeStaticPolyfillResource(IdentifiableElement idElement) {
        TModule module = idElement.getContainingModule();
        if (module == null) {
            return null;
        }
        Resource res = module.eResource();
        return res;
    }
}

