/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.navigator;

import com.google.inject.Inject;
import java.nio.file.Files;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.n4js.external.ExternalIndexSynchronizer;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.navigator.N4JSProjectExplorerProblemsDecorator;
import org.eclipse.n4js.ui.navigator.internal.N4JSProjectExplorerHelper;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetLabelProvider;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerBroker;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class N4JSProjectExplorerLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final Image PROJECT_IMG = (Image)ImageDescriptorCache.ImageRef.PROJECT_IMG.asImage().orNull();
    private static final Image PROJECT_CLOSED_IMG = (Image)ImageDescriptorCache.ImageRef.PROJECT_CLOSED_IMG.asImage().orNull();
    private static final Image SRC_FOLDER_IMG = (Image)ImageDescriptorCache.ImageRef.SRC_FOLDER.asImage().orNull();
    private static final Image WORKING_SET_IMG = (Image)ImageDescriptorCache.ImageRef.WORKING_SET.asImage().orNull();
    private static final Image LIB_PATH = (Image)ImageDescriptorCache.ImageRef.LIB_PATH.asImage().orNull();
    private static final Image LIB_PATH_SCOPED = (Image)ImageDescriptorCache.ImageRef.LIB_PATH_SCOPED.asImage().orNull();
    private static final Image EXTERNAL_LIB_PROJECT = (Image)ImageDescriptorCache.ImageRef.EXTERNAL_LIB_PROJECT.asImage().orNull();
    private static final Image EXTERNAL_LIB_PROJECT_NOT_BUILT = (Image)ImageDescriptorCache.ImageRef.EXTERNAL_LIB_PROJECT_NOT_BUILT.asImage().orNull();
    @Inject
    private N4JSProjectExplorerHelper helper;
    @Inject
    private WorkingSetManagerBroker workingSetManagerBroker;
    @Inject
    private ExternalIndexSynchronizer indexSynchronizer;
    private final ILabelProvider delegate;
    private final ProblemsLabelDecorator decorator = new N4JSProjectExplorerProblemsDecorator();
    private final ILabelProviderListener workingSetLabelProviderListener;
    private final WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();

    public N4JSProjectExplorerLabelProvider() {
        this.delegate = new DecoratingLabelProvider((ILabelProvider)this.workbenchLabelProvider, (ILabelDecorator)this.decorator);
        this.workingSetLabelProviderListener = new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                LabelProviderChangedEvent wrapperEvent = N4JSProjectExplorerLabelProvider.this.createWorkingSetWrapperEvent(event);
                if (wrapperEvent != null) {
                    UIUtils.getDisplay().asyncExec(() -> N4JSProjectExplorerLabelProvider.this.fireLabelProviderChanged(wrapperEvent));
                }
            }
        };
        this.delegate.addListener(this.workingSetLabelProviderListener);
    }

    public String getText(Object element) {
        if (element instanceof WorkingSet) {
            return WorkingSetLabelProvider.INSTANCE.getText(element);
        }
        return this.delegate.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof WorkingSet) {
            return this.decorator.decorateImage(WORKING_SET_IMG, element);
        }
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            N4JSExternalProject npmProject = this.helper.getNodeModulesNpmProjectOrNull(folder);
            if (this.helper.isNodeModulesFolder((IContainer)folder)) {
                return this.decorator.decorateImage(LIB_PATH, element);
            }
            if (folder.getName().startsWith("@") && this.helper.isNodeModulesFolder(folder.getParent())) {
                return this.decorator.decorateImage(LIB_PATH_SCOPED, element);
            }
            if (npmProject != null) {
                if (this.indexSynchronizer.isInIndex(npmProject)) {
                    return this.decorator.decorateImage(EXTERNAL_LIB_PROJECT, element);
                }
                return this.decorator.decorateImage(EXTERNAL_LIB_PROJECT_NOT_BUILT, element);
            }
            if (this.helper.isSourceFolder(folder) || this.helper.isOutputFolder(folder)) {
                return this.decorator.decorateImage(SRC_FOLDER_IMG, element);
            }
            if (Files.isSymbolicLink(folder.getLocation().toFile().toPath())) {
                URI symLinkUri = URI.createFileURI((String)folder.getLocation().toFile().toString());
                String n4jsProjectName = ProjectDescriptionUtils.deriveN4JSProjectNameFromURI((URI)symLinkUri);
                String eclipseProjectName = ProjectDescriptionUtils.convertN4JSProjectNameToEclipseProjectName((String)n4jsProjectName);
                IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(eclipseProjectName);
                if (iProject != null && iProject.exists()) {
                    if (iProject.isAccessible()) {
                        return this.decorator.decorateImage(PROJECT_IMG, element);
                    }
                    return this.decorator.decorateImage(PROJECT_CLOSED_IMG, element);
                }
            }
        }
        return this.delegate.getImage(element);
    }

    public void dispose() {
        super.dispose();
        this.delegate.removeListener(this.workingSetLabelProviderListener);
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof WorkingSet) {
            return WorkingSetLabelProvider.INSTANCE.getStyledText(element);
        }
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            N4JSExternalProject npmProject = this.helper.getNodeModulesNpmProjectOrNull(folder);
            if (npmProject != null) {
                IN4JSProject iNpmProject = npmProject.getIProject();
                return this.helper.getStyledTextForExternalProject(iNpmProject, folder.getName());
            }
            if (Files.isSymbolicLink(folder.getLocation().toFile().toPath())) {
                URI symLinkUri = URI.createFileURI((String)folder.getLocation().toFile().toString());
                String n4jsProjectName = ProjectDescriptionUtils.deriveN4JSProjectNameFromURI((URI)symLinkUri);
                String eclipseProjectName = ProjectDescriptionUtils.convertN4JSProjectNameToEclipseProjectName((String)n4jsProjectName);
                IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(eclipseProjectName);
                if (iProject != null && iProject.exists()) {
                    URI prjPckJson;
                    StyledString.Styler stylerName = StyledString.QUALIFIER_STYLER;
                    if (iProject.isAccessible() && this.indexSynchronizer.isInIndex(prjPckJson = URIUtils.convert((IResource)iProject).appendSegment("package.json"))) {
                        stylerName = null;
                    }
                    StyledString string = new StyledString(folder.getName(), stylerName);
                    return string;
                }
            }
            return new StyledString(folder.getName());
        }
        return this.workbenchLabelProvider.getStyledText(element);
    }

    private LabelProviderChangedEvent createWorkingSetWrapperEvent(LabelProviderChangedEvent event) {
        Object[] workingSets;
        WorkingSetManager manager;
        if (event instanceof ProblemsLabelDecorator.ProblemsLabelChangedEvent && this.workingSetManagerBroker.isWorkingSetTopLevel() && (manager = this.workingSetManagerBroker.getActiveManager()) != null && !Arrays2.isEmpty((Object[])(workingSets = manager.getWorkingSets()))) {
            return new LabelProviderChangedEvent((IBaseLabelProvider)this.delegate, workingSets);
        }
        return null;
    }
}

