/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.security.ui;

import java.security.cert.X509Certificate;
import java.text.DateFormat;
import org.eclipse.equinox.internal.provisional.security.ui.X500PrincipalHelper;
import org.eclipse.equinox.internal.security.ui.Activator;
import org.eclipse.equinox.internal.security.ui.SecurityUIMsg;
import org.eclipse.equinox.internal.security.ui.wizard.CertificateViewer;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class X509CertificateViewDialog
extends TitleAreaDialog {
    private static final String titleImageName = "/titleAreaCert.gif";
    private X509Certificate theCert;
    private static final DateFormat _df = DateFormat.getDateInstance(1);
    private X500PrincipalHelper nameHelper = new X500PrincipalHelper();
    private static Font boldFont = JFaceResources.getBannerFont();
    private Image titleImage;

    public X509CertificateViewDialog(Shell parentShell, X509Certificate cert) {
        super(parentShell);
        this.theCert = cert;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(SecurityUIMsg.CERTVIEW_SHELL_TITLE);
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.nameHelper.setPrincipal(this.theCert.getSubjectX500Principal());
        this.setTitle(this.nameHelper.getCN() != null ? this.nameHelper.getCN() : this.nameHelper.getOU());
        this.titleImage = Activator.getImageDescriptor(titleImageName).createImage();
        if (this.titleImage != null) {
            this.setTitleImage(this.titleImage);
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        TabFolder tabFolder = new TabFolder(composite, 2048);
        GridData bdata = new GridData(1296);
        tabFolder.setLayoutData((Object)bdata);
        this.createBasicTab(tabFolder);
        this.createAdvancedTab(tabFolder);
        return composite;
    }

    private void createBasicTab(TabFolder tabFolder) {
        String displayName = null;
        int labelIndent = 10;
        int dataIdent = 10;
        TabItem basicTab = new TabItem(tabFolder, 0);
        basicTab.setText(SecurityUIMsg.CERTVIEW_LABEL_BASIC);
        Composite basicTabComposite = new Composite((Composite)tabFolder, 0);
        GridLayout tabLayout = new GridLayout();
        tabLayout.numColumns = 2;
        basicTabComposite.setLayout((Layout)tabLayout);
        Label issueToLabel = new Label(basicTabComposite, 0);
        issueToLabel.setText(SecurityUIMsg.CERTPROP_X509_ISSUED_TO);
        issueToLabel.setFont(boldFont);
        X509CertificateViewDialog.configureLayout((Control)issueToLabel, 2, 0, 0, 0);
        this.nameHelper.setPrincipal(this.theCert.getSubjectX500Principal());
        Label CNLabel = new Label(basicTabComposite, 0);
        CNLabel.setText(SecurityUIMsg.X500_LABEL_CN);
        X509CertificateViewDialog.configureLayout((Control)CNLabel, 0, 0, labelIndent, 0);
        Label subjectCN = new Label(basicTabComposite, 0);
        displayName = this.nameHelper.getCN();
        subjectCN.setText(displayName != null ? displayName : SecurityUIMsg.CERTVAL_UNDEFINED);
        X509CertificateViewDialog.configureLayout((Control)subjectCN, 0, 0, dataIdent, 0);
        Label OLabel = new Label(basicTabComposite, 0);
        OLabel.setText(SecurityUIMsg.X500_LABEL_O);
        X509CertificateViewDialog.configureLayout((Control)OLabel, 0, 0, labelIndent, 0);
        Label subjectO = new Label(basicTabComposite, 0);
        displayName = this.nameHelper.getO();
        subjectO.setText(displayName != null ? displayName : SecurityUIMsg.CERTVAL_UNDEFINED);
        X509CertificateViewDialog.configureLayout((Control)subjectO, 0, 0, dataIdent, 0);
        Label OULabel = new Label(basicTabComposite, 0);
        OULabel.setText(SecurityUIMsg.X500_LABEL_OU);
        X509CertificateViewDialog.configureLayout((Control)OULabel, 0, 0, labelIndent, 0);
        Label subjectOU = new Label(basicTabComposite, 0);
        displayName = this.nameHelper.getOU();
        subjectOU.setText(displayName != null ? displayName : SecurityUIMsg.CERTVAL_UNDEFINED);
        X509CertificateViewDialog.configureLayout((Control)subjectOU, 0, 0, dataIdent, 0);
        Label issueByLabel = new Label(basicTabComposite, 0);
        issueByLabel.setText(SecurityUIMsg.CERTPROP_X509_ISSUED_BY);
        X509CertificateViewDialog.configureLayout((Control)issueByLabel, 2, 0, 0, 0);
        issueByLabel.setFont(boldFont);
        this.nameHelper.setPrincipal(this.theCert.getIssuerX500Principal());
        Label CNLabel2 = new Label(basicTabComposite, 0);
        CNLabel2.setText(SecurityUIMsg.X500_LABEL_CN);
        X509CertificateViewDialog.configureLayout((Control)CNLabel2, 0, 0, labelIndent, 0);
        Label issuerCN = new Label(basicTabComposite, 0);
        displayName = this.nameHelper.getCN();
        issuerCN.setText(displayName != null ? displayName : SecurityUIMsg.CERTVAL_UNDEFINED);
        X509CertificateViewDialog.configureLayout((Control)issuerCN, 0, 0, dataIdent, 0);
        Label OLabel2 = new Label(basicTabComposite, 0);
        OLabel2.setText(SecurityUIMsg.X500_LABEL_O);
        X509CertificateViewDialog.configureLayout((Control)OLabel2, 0, 0, labelIndent, 0);
        Label issuerO = new Label(basicTabComposite, 0);
        displayName = this.nameHelper.getO();
        issuerO.setText(displayName != null ? displayName : SecurityUIMsg.CERTVAL_UNDEFINED);
        X509CertificateViewDialog.configureLayout((Control)issuerO, 0, 0, dataIdent, 0);
        Label OULabel2 = new Label(basicTabComposite, 0);
        OULabel2.setText(SecurityUIMsg.X500_LABEL_OU);
        X509CertificateViewDialog.configureLayout((Control)OULabel2, 0, 0, labelIndent, 0);
        Label issuerOU = new Label(basicTabComposite, 0);
        displayName = this.nameHelper.getOU();
        issuerOU.setText(displayName != null ? displayName : SecurityUIMsg.CERTVAL_UNDEFINED);
        X509CertificateViewDialog.configureLayout((Control)issuerOU, 0, 0, dataIdent, 0);
        Label datesLabel = new Label(basicTabComposite, 0);
        datesLabel.setText(SecurityUIMsg.CERTVIEW_LABEL_VALIDITY_DATES);
        X509CertificateViewDialog.configureLayout((Control)datesLabel, 2, 0, 0, 0);
        datesLabel.setFont(boldFont);
        Label validFrom = new Label(basicTabComposite, 0);
        validFrom.setText(SecurityUIMsg.CERTPROP_X509_VALID_FROM);
        X509CertificateViewDialog.configureLayout((Control)validFrom, 0, 0, labelIndent, 0);
        Label fromDate = new Label(basicTabComposite, 0);
        fromDate.setText(_df.format(this.theCert.getNotBefore()));
        X509CertificateViewDialog.configureLayout((Control)fromDate, 0, 0, dataIdent, 0);
        Label validTo = new Label(basicTabComposite, 0);
        validTo.setText(SecurityUIMsg.CERTPROP_X509_VALID_TO);
        X509CertificateViewDialog.configureLayout((Control)validTo, 0, 0, labelIndent, 0);
        Label toDate = new Label(basicTabComposite, 0);
        toDate.setText(_df.format(this.theCert.getNotAfter()));
        X509CertificateViewDialog.configureLayout((Control)toDate, 0, 0, dataIdent, 0);
        basicTab.setControl((Control)basicTabComposite);
    }

    protected static void configureLayout(Control c, int horizontalSpan, int verticalSpan, int horizontalIndent, int vertIndent) {
        GridData gd = new GridData(36);
        gd.horizontalSpan = horizontalSpan;
        gd.verticalSpan = verticalSpan;
        gd.horizontalIndent = horizontalIndent;
        gd.verticalIndent = vertIndent;
        c.setLayoutData((Object)gd);
    }

    private void createAdvancedTab(TabFolder tabFolder) {
        TabItem advancedTab = new TabItem(tabFolder, 0);
        advancedTab.setText(SecurityUIMsg.CERTVIEW_LABEL_DETAILS);
        Composite advTabComposite = new Composite((Composite)tabFolder, 0);
        advTabComposite.setLayout((Layout)new FillLayout(512));
        CertificateViewer certViewer = new CertificateViewer(advTabComposite);
        certViewer.setCertificate(this.theCert);
        advancedTab.setControl((Control)advTabComposite);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x860);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, true);
    }

    public boolean close() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        return super.close();
    }
}

