/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.doctools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.n4js.doctools.ChunkError;
import org.eclipse.n4js.doctools.ChunkHelper;

public class Chunker {
    private static final Pattern IDS = Pattern.compile("(?:\\s|<|\\\")id\\s*=\\s*\\\"([^\"]+)\"");
    private static final Pattern REFS = Pattern.compile("(?:\\s|<|\")href=\"#([^\"]+)");
    private static final String DEF_CHUNK = "<(?:h|H)1[^>]*>";
    private static final String DEF_FOOT = "</(?:body|BODY)>";
    private static final String DEF_NAME = "h1";
    private static final String DEF_INDEX = "index";
    private final String html;
    private final Pattern headPattern;
    private final Pattern footPattern;
    private final Pattern chunkPattern;
    private final Pattern nameTagStartPattern;
    private final Pattern nameTagEndPattern;
    private final String indexName;
    private Range head;
    private Range foot;
    final List<Range> chunks = new ArrayList<Range>();
    final Map<String, Range> anchorMappings = new HashMap<String, Range>();
    private final Matcher chunkMatcher;

    public static void main(String[] args) throws IOException {
        if (args.length % 2 != 1) {
            Chunker.printHelp();
            System.exit(1);
        }
        String head = null;
        String foot = null;
        String tag = null;
        String name = null;
        String index = null;
        String dir = ".";
        String in = null;
        int f = 0;
        while (f < args.length - 1) {
            String flag = args[f];
            String value = args[f + 1];
            switch (flag) {
                case "-h": {
                    head = value;
                    break;
                }
                case "-f": {
                    foot = value;
                    break;
                }
                case "-c": {
                    tag = value;
                    break;
                }
                case "-d": {
                    dir = value;
                    break;
                }
                case "-n": {
                    name = value;
                    break;
                }
                case "-i": {
                    index = value;
                    break;
                }
                default: {
                    System.out.println("Flag " + flag + " not recognized.");
                    Chunker.printHelp();
                    System.exit(2);
                }
            }
            f += 2;
        }
        in = args[args.length - 1];
        String html = new String(Files.readAllBytes(new File(in).toPath()));
        Chunker chunker = new Chunker(html, head, foot, tag, name, index);
        for (Range range : chunker.chunks) {
            String fileName = String.valueOf(dir) + File.separator + range.name + ".html";
            System.out.println("Writing chunk " + fileName);
            File f2 = new File(fileName);
            Files.write(f2.toPath(), chunker.getChunk(range).toString().getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
    }

    private static void printHelp() {
        System.out.println("chunker [-h head] [-f foot] [-c tag] [-d output-directory] inputfile\n-h regex    Separator to identify the end of the head,\n            if omitted the first tag is used to determine the head\n            If head is specified, the content between head and first tag is\n            used for index page.\n-i string   Name of the index file, if omitted index is used.\n-f regex    Separator to identify foot, if omitted </(?:body|BODY)> is used.\n-c regex    The marker to determine a chapter, if omitted\n            <(?:h|H)1[^>]*> is used.\n-n string   The name tag, if omitted h1 is used.\n-d output-directory\n            The output directly, if omitted the current folder is used.");
    }

    public Chunker(String html, String head, String foot, String chunk, String name, String index) {
        this.html = html;
        if (html == null || html.isEmpty()) {
            throw new ChunkError("No html specified");
        }
        this.headPattern = head != null ? Pattern.compile(head) : null;
        this.footPattern = Pattern.compile(foot == null ? DEF_FOOT : foot);
        this.chunkPattern = Pattern.compile(chunk == null ? DEF_CHUNK : chunk);
        if (name == null) {
            name = DEF_NAME;
        }
        this.nameTagStartPattern = Pattern.compile("<(?:" + name.toLowerCase() + "|" + name.toUpperCase() + ")[^>]*>");
        this.nameTagEndPattern = Pattern.compile("</(?:" + name.toLowerCase() + "|" + name.toUpperCase() + ")[^>]*>");
        this.chunkMatcher = this.chunkPattern.matcher(html);
        this.indexName = index == null ? DEF_INDEX : index;
        this.findHead();
        this.findFoot();
        this.findChunks();
        this.createAnchorMappings();
    }

    private void createAnchorMappings() {
        Matcher m = IDS.matcher(this.html);
        while (m.find()) {
            String id = m.group(1);
            int start = m.start();
            Range chunk = this.findChunk(start);
            if (chunk == null) continue;
            this.anchorMappings.put(id, chunk);
        }
    }

    private Range findChunk(int offset) {
        for (Range chunk : this.chunks) {
            if (chunk.end < offset) continue;
            return chunk;
        }
        return null;
    }

    private void findHead() {
        if (this.headPattern != null) {
            Matcher m = this.headPattern.matcher(this.html);
            if (!m.find()) {
                throw new ChunkError("Head separator not found.");
            }
            int pos = m.end();
            this.head = new Range("head", 0, pos);
        } else {
            int pos = this.findNextChunkStart(0);
            if (pos < 0) {
                throw new ChunkError("No chunk found, no head identified.");
            }
            this.head = new Range("head", 0, pos);
        }
    }

    private void findFoot() {
        Matcher m = this.footPattern.matcher(this.html);
        if (!m.find()) {
            throw new ChunkError("Foot separator not found.");
        }
        int pos = m.start();
        this.foot = new Range("foot", pos, this.html.length());
    }

    private int findNextChunkStart(int offset) {
        if (this.chunkMatcher.find(offset)) {
            int start = this.chunkMatcher.start();
            return start;
        }
        return -1;
    }

    private void findChunks() {
        int start = this.head.end + 1;
        while (start < this.foot.start) {
            int end = this.findNextChunkStart(start);
            if (end < 0) {
                end = this.foot.start;
            }
            String name = null;
            if (this.headPattern != null && this.chunks.isEmpty()) {
                name = this.indexName;
            } else {
                String uniqueName;
                name = this.findChunkName(start, end - 1);
                if (name == null) {
                    name = "Chunk_" + this.chunks.size() + 1;
                }
                int i = 0;
                boolean foundDuplicateName = true;
                do {
                    name = uniqueName = i == 0 ? name : String.valueOf(name) + "_" + i;
                    ++i;
                } while (foundDuplicateName = this.chunks.stream().anyMatch(chunk -> chunk.name.equals(uniqueName)));
            }
            Range chunk2 = new Range(name, start - 1, end);
            this.chunks.add(chunk2);
            start = end + 1;
        }
    }

    private String findChunkName(int start, int end) {
        Matcher mStart = this.nameTagStartPattern.matcher(this.html);
        if (!mStart.find(start - 1)) {
            return null;
        }
        int startOfName = mStart.end();
        Matcher mEnd = this.nameTagEndPattern.matcher(this.html);
        if (!mEnd.find(startOfName)) {
            return null;
        }
        int endOfName = mEnd.start();
        if (endOfName > end) {
            return null;
        }
        return ChunkHelper.extractFileNameFromTitle(this.html, startOfName, endOfName);
    }

    CharSequence getChunk(Range range) {
        StringBuilder strb = new StringBuilder();
        this.appendWithRewrittenLinks(range, strb, this.html.substring(this.head.start, this.head.end));
        this.appendWithRewrittenLinks(range, strb, this.html.substring(range.start, range.end));
        this.appendWithRewrittenLinks(range, strb, this.html.substring(this.foot.start, this.foot.end));
        return strb;
    }

    private void appendWithRewrittenLinks(Range chunkFrom, StringBuilder strb, String content) {
        Matcher m = REFS.matcher(content);
        int offset = 0;
        while (m.find()) {
            String ref = m.group(1);
            String prefix = null;
            Range chunkTo = this.anchorMappings.get(ref);
            if (chunkTo != null && chunkTo != chunkFrom) {
                prefix = chunkTo.name;
            }
            if (prefix == null) continue;
            strb.append(content.substring(offset, m.start(1) - 1));
            strb.append(prefix).append(".html");
            strb.append('#');
            strb.append(ref);
            offset = m.end();
        }
        if (offset < content.length()) {
            strb.append(content.substring(offset));
        }
    }

    static class Range {
        public final String name;
        public final int start;
        public final int end;

        public Range(String name, int start, int end) {
            this.name = name;
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return String.valueOf(this.name) + "(" + this.start + "-" + this.end + ")";
        }
    }
}

