/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.runner;

import org.eclipse.xpect.XjmMethod;
import org.eclipse.xpect.runner.XpectFileRunner;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.state.StateContainer;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public abstract class AbstractTestRunner
extends Runner {
    private Description description;
    private final XpectFileRunner uriRunner;

    public AbstractTestRunner(XpectFileRunner uriRunner) {
        this.uriRunner = uriRunner;
    }

    public abstract StateContainer getState();

    public abstract Description createDescription();

    public Description getDescription() {
        if (this.description == null) {
            this.description = this.createDescription();
        }
        return this.description;
    }

    @Creates
    public abstract XjmMethod getMethod();

    public XpectFileRunner getFileRunner() {
        return this.uriRunner;
    }

    protected boolean isIgnore() {
        Ignore annotation = this.getMethod().getJavaMethod().getAnnotation(Ignore.class);
        return annotation != null;
    }

    public void run(RunNotifier notifier) {
        try {
            try {
                notifier.fireTestStarted(this.getDescription());
                if (this.isIgnore()) {
                    notifier.fireTestIgnored(this.getDescription());
                } else {
                    this.runInternal();
                }
            }
            catch (Throwable t) {
                notifier.fireTestFailure(new Failure(this.getDescription(), t));
                try {
                    try {
                        this.getState().invalidate();
                    }
                    catch (Throwable t2) {
                        notifier.fireTestFailure(new Failure(this.getDescription(), t2));
                        notifier.fireTestFinished(this.getDescription());
                    }
                }
                finally {
                    notifier.fireTestFinished(this.getDescription());
                }
            }
        }
        finally {
            block22: {
                try {
                    try {
                        this.getState().invalidate();
                    }
                    catch (Throwable t) {
                        notifier.fireTestFailure(new Failure(this.getDescription(), t));
                        notifier.fireTestFinished(this.getDescription());
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    notifier.fireTestFinished(this.getDescription());
                    throw throwable;
                }
                notifier.fireTestFinished(this.getDescription());
            }
        }
    }

    protected abstract void runInternal() throws Throwable;

    public String toString() {
        return this.getDescription().getDisplayName();
    }
}

