/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner;

import com.google.inject.Inject;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.runner.RunConfiguration;
import org.eclipse.n4js.runner.RunnerFrontEnd;
import org.eclipse.n4js.runner.RunnerHelper;
import org.eclipse.n4js.runner.extension.RunnerRegistry;
import org.eclipse.n4js.runner.internal.RunnerN4JSCore;

public class RunnerFileBasedShippedCodeConfigurationHelper {
    @Inject
    private RunnerFrontEnd runnerFrontEnd;
    @Inject
    private RunnerHelper runnerHelper;
    @Inject
    private RunnerRegistry runnerRegistry;
    @Inject
    private RunnerN4JSCore runnerN4JSCore;

    public void configureFromFileSystem(RunConfiguration config) {
        Iterable<IN4JSProject> allShippedProjects = this.runnerN4JSCore.getAllShippedProjects();
        IN4JSProject customRuntimeEnvironment = this.getCustomRuntimeEnvironment(config, allShippedProjects);
        this.reconfigure(config, allShippedProjects, customRuntimeEnvironment);
    }

    protected void reconfigure(RunConfiguration config, Iterable<IN4JSProject> allShippedProjects, IN4JSProject customRuntimeEnvironment) {
        if (customRuntimeEnvironment == null) {
            throw new RuntimeException("Custom bootstrap code was requested but cannot be determined.");
        }
        LinkedHashSet<IN4JSProject> customBootstrapProjects = new LinkedHashSet<IN4JSProject>();
        this.runnerHelper.recursiveExtendedREsCollector(customRuntimeEnvironment, customBootstrapProjects, allShippedProjects);
        if (!customBootstrapProjects.isEmpty()) {
            this.runnerFrontEnd.configureRuntimeEnvironment(config, customBootstrapProjects);
            Map<Path, String> coreProjectPaths = this.runnerHelper.getCoreProjectPaths(customBootstrapProjects);
            config.addCoreProjectPaths(coreProjectPaths);
        }
    }

    protected IN4JSProject getCustomRuntimeEnvironment(RunConfiguration config, Iterable<IN4JSProject> allShippedProjects) {
        return (IN4JSProject)this.runnerHelper.findRuntimeEnvironemtnWithName(this.runnerRegistry.getDescriptor(config.getRunnerId()).getEnvironment().getProjectName(), allShippedProjects).orNull();
    }
}

