/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc;

import org.eclipse.n4js.jsdoc.AbstractJSDocParser;
import org.eclipse.n4js.jsdoc.ITagDefinition;
import org.eclipse.n4js.jsdoc.JSDocCharScanner;
import org.eclipse.n4js.jsdoc.JSDocToken;
import org.eclipse.n4js.jsdoc.TagDictionary;
import org.eclipse.n4js.jsdoc.dom.ComposedContent;
import org.eclipse.n4js.jsdoc.dom.ContentNode;
import org.eclipse.n4js.jsdoc.dom.DomFactory;
import org.eclipse.n4js.jsdoc.dom.InlineTag;
import org.eclipse.n4js.jsdoc.dom.Tag;
import org.eclipse.n4js.jsdoc.dom.TagTitle;
import org.eclipse.n4js.jsdoc.dom.Text;
import org.eclipse.n4js.jsdoc.tags.AbstractInlineTagDefinition;
import org.eclipse.n4js.jsdoc.tokenizers.InlineTagTokenizer;
import org.eclipse.n4js.jsdoc.tokenizers.TagTitleTokenizer;

public class DescriptionParser
extends AbstractJSDocParser {
    Tag parseRegion(JSDocCharScanner scanner, TagDictionary<AbstractInlineTagDefinition> inlineTagsDictinary) {
        JSDocCharScanner.ScannerState stateBeforeRegion = scanner.saveState();
        char _char = scanner.nextNonWS();
        if (!this.regionStart(_char)) {
            return null;
        }
        scanner.skipWS();
        JSDocToken tokenTitle = TagTitleTokenizer.INSTANCE.nextToken(scanner);
        if (tokenTitle != null) {
            ITagDefinition iTagDefinition = inlineTagsDictinary.getDefinition(tokenTitle.token);
            if (iTagDefinition != null) {
                TagTitle tagTitle = this.createTagTitle(tokenTitle, iTagDefinition);
                AbstractInlineTagDefinition tagDefinition = (AbstractInlineTagDefinition)iTagDefinition;
                scanner.restoreState(stateBeforeRegion);
                InlineTag tag = (InlineTag)tagDefinition.parse(tagTitle, scanner);
                tag.setRange(tokenTitle.start, scanner.offset());
                return tag;
            }
            System.err.println("silent ignore of unrecognized InlineTag {" + tokenTitle.token + "}");
            return null;
        }
        return null;
    }

    private boolean regionStart(char _char) {
        return String.valueOf(_char).equals(InlineTagTokenizer.INSTANCE.startMarker);
    }

    public ContentNode parse(JSDocCharScanner scanner, TagDictionary<AbstractInlineTagDefinition> inlineTagsDictinary) {
        String pendingData;
        int start;
        ComposedContent description = DomFactory.eINSTANCE.createComposedContent();
        if (!scanner.hasNext()) {
            return null;
        }
        if (this.nextIsTagTitle(scanner)) {
            return null;
        }
        int end = start = scanner.nextOffset();
        StringBuilder strb = new StringBuilder();
        while (scanner.hasNext()) {
            char c = scanner.peek();
            if (this.regionStart(c)) {
                JSDocCharScanner.ScannerState st = scanner.saveState();
                InlineTag tag = (InlineTag)this.parseRegion(scanner, inlineTagsDictinary);
                if (tag != null) {
                    this.saveTextTokens(description, start, end, strb);
                    strb = new StringBuilder();
                    start = end;
                    description.getContents().add((Object)tag);
                    continue;
                }
                scanner.restoreState(st);
                if (start == end) assert (false);
            }
            scanner.next();
            if (JSDocCharScanner.isNL(c)) {
                if (!scanner.hasNext() || this.nextIsTagTitle(scanner)) break;
                end = scanner.offset();
            }
            strb.append(c);
            end = scanner.offset();
        }
        if (!(pendingData = strb.toString()).isEmpty()) {
            this.saveTextTokens(description, start, end, strb);
        }
        switch (description.getContents().size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (ContentNode)description.getContents().get(0);
            }
        }
        return description;
    }

    private void saveTextTokens(ComposedContent description, int start, int end, StringBuilder strb) {
        Text text = DomFactory.eINSTANCE.createText();
        JSDocToken token = new JSDocToken(strb.toString(), start, end);
        text.setText(token.token);
        text.setBegin(token.start);
        text.setEnd(token.end);
        description.getContents().add((Object)text);
    }

    boolean nextIsTagTitle(JSDocCharScanner scanner) {
        JSDocCharScanner.ScannerState state = scanner.saveState();
        try {
            scanner.skipWS();
            if (scanner.hasNext() && scanner.peek() == '@') {
                boolean bl = TagTitleTokenizer.INSTANCE.nextToken(scanner.copy()) != null;
                return bl;
            }
        }
        finally {
            scanner.restoreState(state);
        }
        return false;
    }
}

