/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.semver;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.semver.Semver.NPMVersionRequirement;
import org.eclipse.n4js.semver.Semver.SimpleVersion;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.Semver.VersionRange;
import org.eclipse.n4js.semver.Semver.VersionRangeConstraint;
import org.eclipse.n4js.semver.Semver.VersionRangeSetRequirement;
import org.eclipse.n4js.semver.SemverResourceValidator;
import org.eclipse.n4js.utils.languages.N4LanguageUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.Issue;

public class SemverHelper {
    private SemverResourceValidator validator;
    private IParser semverParser;

    public IParser getSemverParser() {
        if (this.semverParser == null) {
            this.semverParser = (IParser)N4LanguageUtils.getServiceForContext((String)"semver", IParser.class).get();
        }
        return this.semverParser;
    }

    public SemverResourceValidator getSemverValidator() {
        if (this.validator == null) {
            this.validator = (SemverResourceValidator)((Object)N4LanguageUtils.getServiceForContext((String)"semver", SemverResourceValidator.class).get());
        }
        return this.validator;
    }

    public IParseResult getParseResult(String semverString) {
        if (semverString == null) {
            return null;
        }
        IParseResult parseResult = this.getSemverParser().parse((Reader)new StringReader(semverString));
        return parseResult;
    }

    public NPMVersionRequirement parse(String semverString) {
        IParseResult parseResult = this.getParseResult(semverString);
        return this.parse(parseResult);
    }

    public NPMVersionRequirement parse(IParseResult parseResult) {
        if (parseResult != null && parseResult.getRootASTElement() instanceof NPMVersionRequirement) {
            NPMVersionRequirement npmVersion = (NPMVersionRequirement)parseResult.getRootASTElement();
            return npmVersion;
        }
        return null;
    }

    public VersionRangeSetRequirement parseVersionRangeSet(String semverString) {
        NPMVersionRequirement npmVersion = this.parse(semverString);
        if (npmVersion instanceof VersionRangeSetRequirement) {
            VersionRangeSetRequirement vrs = (VersionRangeSetRequirement)npmVersion;
            return vrs;
        }
        return null;
    }

    public VersionRangeSetRequirement parseVersionRangeSet(IParseResult semverParseResult) {
        NPMVersionRequirement npmVersion = this.parse(semverParseResult);
        if (npmVersion instanceof VersionRangeSetRequirement) {
            VersionRangeSetRequirement vrs = (VersionRangeSetRequirement)npmVersion;
            return vrs;
        }
        return null;
    }

    public VersionNumber parseVersionNumber(IParseResult semverParseResult) {
        VersionRangeSetRequirement vrs = this.parseVersionRangeSet(semverParseResult);
        if (vrs == null || vrs.getRanges().isEmpty()) {
            return null;
        }
        VersionRange firstVersionRange = (VersionRange)vrs.getRanges().get(0);
        if (!(firstVersionRange instanceof VersionRangeConstraint)) {
            return null;
        }
        VersionRangeConstraint vrc = (VersionRangeConstraint)firstVersionRange;
        if (vrc.getVersionConstraints().isEmpty()) {
            return null;
        }
        SimpleVersion firstSimpleVersion = (SimpleVersion)vrc.getVersionConstraints().get(0);
        return firstSimpleVersion.getNumber();
    }

    public VersionNumber parseVersionNumber(String semverString) {
        IParseResult semverParseResult = this.getParseResult(semverString);
        return this.parseVersionNumber(semverParseResult);
    }

    public List<Issue> validate(IParseResult semverParseResult) {
        EObject rootASTElement = semverParseResult.getRootASTElement();
        if (!(rootASTElement instanceof NPMVersionRequirement)) {
            return Collections.emptyList();
        }
        return this.validate((NPMVersionRequirement)rootASTElement);
    }

    public List<Issue> validate(NPMVersionRequirement rootASTElement) {
        if (rootASTElement == null) {
            return Collections.emptyList();
        }
        SemverResourceValidator validat0r = this.getSemverValidator();
        List<Issue> issues = validat0r.validate((EObject)rootASTElement, CheckMode.ALL, CancelIndicator.NullImpl);
        return issues;
    }
}

