/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.runner;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.parameter.IStatementRelatedRegionProvider;
import org.eclipse.xpect.parameter.StatementRelatedRegionProvider;
import org.eclipse.xpect.runner.TestTitleRegion;
import org.eclipse.xpect.text.Text;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

@StatementRelatedRegionProvider
public class TestTitleProvider
implements IStatementRelatedRegionProvider {
    protected TestTitleRegion findTitle(XpectInvocation invocation, String documentString, int offset) {
        Text document = new Text(documentString);
        int lineStart = document.currentLineStart(offset);
        if (lineStart > 0) {
            String title;
            String prevPrefix;
            int prevLine;
            String prefix = document.substring(lineStart, offset);
            String trimmedPrefix = prefix.trim();
            if (trimmedPrefix.length() > 0) {
                int i = 0;
                while (i < trimmedPrefix.length()) {
                    char c = trimmedPrefix.charAt(i);
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                        return new TestTitleRegion(invocation, lineStart, offset - lineStart);
                    }
                    ++i;
                }
            }
            if ((prevLine = document.previousLineStart(offset)) >= 0 && prefix.equals(prevPrefix = document.substring(prevLine, prevLine + prefix.length())) && (title = document.substring(prevLine + prefix.length(), lineStart).trim()).length() > 0) {
                return new TestTitleRegion(invocation, prevLine + prefix.length(), lineStart - (prevLine + prefix.length()));
            }
        }
        return null;
    }

    @Override
    public TestTitleRegion getRegion(XpectInvocation invocation) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)invocation);
        String document = node.getRootNode().getText();
        TestTitleRegion title = this.findTitle(invocation, document, node.getOffset());
        if (title != null && title.getRegionText().startsWith("XPECT")) {
            title = null;
        }
        return title;
    }
}

