/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.building;

import com.google.common.base.Stopwatch;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.internal.RaceDetectionHelper;
import org.eclipse.n4js.ui.building.BuilderStateLogger;
import org.eclipse.n4js.ui.building.N4JSBuildTypeTracker;
import org.eclipse.n4js.ui.containers.N4JSProjectsStateHelper;
import org.eclipse.n4js.ui.external.EclipseExternalIndexSynchronizer;
import org.eclipse.n4js.ui.external.ExternalLibraryBuildScheduler;
import org.eclipse.n4js.ui.internal.N4JSProjectDependencyStrategy;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.debug.IBuildLogger;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.builder.impl.XtextBuilder;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;
import org.eclipse.xtext.xbase.lib.util.ReflectExtensions;

public class N4JSBuildTypeTrackingBuilder
extends XtextBuilder {
    private static final Logger LOGGER = Logger.getLogger(N4JSBuildTypeTrackingBuilder.class);
    @Inject
    @BuilderStateLogger.BuilderState
    private IBuildLogger builderStateLogger;
    private EclipseExternalIndexSynchronizer externalIndexSynchronizer;
    private ExternalLibraryBuildScheduler externalLibraryBuildJobProvider;
    private N4JSProjectDependencyStrategy projectDependencyStrategy;
    private N4JSProjectsStateHelper projectsStateHelper;
    @Inject
    private ReflectExtensions reflector;

    @Inject
    private void injectSharedContributions(ISharedStateContributionRegistry registry) {
        this.externalLibraryBuildJobProvider = (ExternalLibraryBuildScheduler)registry.getSingleContributedInstance(ExternalLibraryBuildScheduler.class);
        this.externalIndexSynchronizer = (EclipseExternalIndexSynchronizer)((Object)registry.getSingleContributedInstance(EclipseExternalIndexSynchronizer.class));
        this.projectsStateHelper = (N4JSProjectsStateHelper)((Object)registry.getSingleContributedInstance(N4JSProjectsStateHelper.class));
        try {
            this.projectDependencyStrategy = (N4JSProjectDependencyStrategy)registry.getSingleContributedInstance(N4JSProjectDependencyStrategy.class);
        }
        catch (RuntimeException e) {
            LOGGER.warn((Object)("Building projects based on default dependencies but without " + N4JSProjectDependencyStrategy.class));
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        IProject project = this.getProject();
        try {
            List<IProject> dependencies;
            RaceDetectionHelper.log((String)"About to build %s", (Object)project);
            SubMonitor builderMonitor = this.toBuilderMonitor(monitor, 1100);
            this.externalLibraryBuildJobProvider.buildExternalProjectsNow((IProgressMonitor)builderMonitor.split(50));
            Object[] result = super.build(kind, args, (IProgressMonitor)builderMonitor.split(1000, 4));
            List<IProject> list = dependencies = this.projectDependencyStrategy != null ? this.projectDependencyStrategy.getProjectDependencies(project, true) : null;
            if (dependencies == null) {
                RaceDetectionHelper.log((String)"Returning project results since dependencies cannot be determined", (Object[])new Object[0]);
                RaceDetectionHelper.log((String)"%s depends on %s", (Object[])new Object[]{project, Arrays.toString(result)});
                Object[] objectArray = result;
                return objectArray;
            }
            Object[] staticReferences = project.getDescription().getReferencedProjects();
            if (dependencies.isEmpty()) {
                RaceDetectionHelper.log((String)"Returning static project results since dependencies are empty", (Object[])new Object[0]);
                RaceDetectionHelper.log((String)"%s depends on %s", (Object[])new Object[]{project, Arrays.toString(result)});
                Object[] objectArray = staticReferences;
                return objectArray;
            }
            LinkedHashSet asSet = Sets.newLinkedHashSet((Iterable)FluentIterable.from(dependencies).append(staticReferences));
            result = asSet.toArray(new IProject[0]);
            RaceDetectionHelper.log((String)"Returning computed results", (Object[])new Object[0]);
            RaceDetectionHelper.log((String)"%s depends on %s", (Object[])new Object[]{project, Arrays.toString(result)});
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            stopwatch.stop();
            if (LOGGER.isDebugEnabled()) {
                String msg = "Building " + project.getName() + " took " + stopwatch.elapsed(TimeUnit.SECONDS) + " seconds";
                LOGGER.debug((Object)msg);
            }
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        this.builderStateLogger.log((Object)"N4JSBuildTypeTrackingBuilder.incrementalBuild() >>>");
        this.builderStateLogger.log((Object)("Resource delta: " + delta));
        super.incrementalBuild(delta, monitor);
        this.builderStateLogger.log((Object)"N4JSBuildTypeTrackingBuilder.incrementalBuild() <<<");
    }

    protected void doClean(ToBeBuilt toBeBuilt, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        this.projectsStateHelper.clearProjectCache(project);
        this.runWithBuildType(monitor, IXtextBuilderParticipant.BuildType.CLEAN, m -> super.doClean(toBeBuilt, m));
    }

    protected void doBuild(ToBeBuilt toBeBuilt, IProgressMonitor monitor, IXtextBuilderParticipant.BuildType type) throws CoreException, OperationCanceledException {
        toBeBuilt.getToBeDeleted().removeAll(toBeBuilt.getToBeUpdated());
        RaceDetectionHelper.log((String)"%s", (Object)toBeBuilt);
        this.runWithBuildType(monitor, type, m -> this.superDoBuild(toBeBuilt, m, type));
    }

    private void runWithBuildType(IProgressMonitor monitor, IXtextBuilderParticipant.BuildType type, IWorkspaceRunnable runMe) throws CoreException, OperationCanceledException {
        try {
            try {
                N4JSBuildTypeTracker.setBuildType(this.getProject(), type);
                runMe.run(monitor);
                this.getProject().touch(monitor);
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error in n4js-build", (Throwable)e);
                throw e;
            }
        }
        finally {
            N4JSBuildTypeTracker.clearBuildType(this.getProject());
        }
    }

    private QueuedBuildData getQueuedBuildData() {
        return (QueuedBuildData)this.optimisticGet("queuedBuildData");
    }

    private IBuilderState getBuilderState() {
        return (IBuilderState)this.optimisticGet("builderState");
    }

    private <T> T optimisticGet(String fieldName) {
        try {
            return (T)this.reflector.get((Object)this, fieldName);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private void superDoBuild(ToBeBuilt toBeBuilt, IProgressMonitor monitor, IXtextBuilderParticipant.BuildType type) {
        boolean indexingOnly = type == IXtextBuilderParticipant.BuildType.RECOVERY;
        QueuedBuildData queuedBuildData = this.getQueuedBuildData();
        if (this.isNoop(toBeBuilt, queuedBuildData, indexingOnly)) {
            return;
        }
        SubMonitor progress = this.toBuilderMonitor(monitor, 1);
        IProject project = this.getProject();
        ResourceSet resourceSet = this.createResourceSet(project);
        BuildData buildData = new BuildData(this.getProject().getName(), resourceSet, toBeBuilt, queuedBuildData, indexingOnly, () -> ((N4JSBuildTypeTrackingBuilder)this).needRebuild());
        this.getBuilderState().update(buildData, (IProgressMonitor)progress.split(1, 0));
        if (!indexingOnly) {
            try {
                project.getWorkspace().checkpoint(false);
            }
            catch (NoClassDefFoundError e) {
                throw new RuntimeException(e);
            }
        }
    }

    private SubMonitor toBuilderMonitor(IProgressMonitor monitor, int ticks) {
        monitor.subTask("Building " + this.getProject().getName());
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)ticks);
        return progress;
    }

    private ResourceSet createResourceSet(IProject project) {
        ResourceSet resourceSet = this.getResourceSetProvider().get(project);
        resourceSet.getLoadOptions().put("org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE", Boolean.TRUE);
        return resourceSet;
    }

    private boolean isNoop(ToBeBuilt toBeBuilt, QueuedBuildData queuedBuildData, boolean indexingOnly) {
        return new BuildData(this.getProject().getName(), null, toBeBuilt, queuedBuildData, indexingOnly, () -> ((N4JSBuildTypeTrackingBuilder)this).needRebuild()).isEmpty();
    }
}

