/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.ExternalProject;
import org.eclipse.n4js.external.ExternalProjectsCollector;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.external.RebuildWorkspaceProjectsScheduler;
import org.eclipse.n4js.external.libraries.ExternalLibrariesActivator;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectReference;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.ui.external.ExternalLibraryBuilder;
import org.eclipse.n4js.ui.external.ExternalProjectProvider;
import org.eclipse.n4js.ui.internal.N4JSEclipseProject;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.n4js.utils.resources.IExternalResource;
import org.eclipse.xtext.util.Pair;

@Singleton
public class EclipseExternalLibraryWorkspace
extends ExternalLibraryWorkspace
implements ExternalLibraryPreferenceStore.StoreUpdatedListener {
    private static Logger logger = Logger.getLogger(EclipseExternalLibraryWorkspace.class);
    @Inject
    private IN4JSCore core;
    @Inject
    private ExternalLibraryBuilder builder;
    @Inject
    private ExternalProjectsCollector collector;
    @Inject
    private RebuildWorkspaceProjectsScheduler scheduler;
    @Inject
    private ExternalProjectProvider projectProvider;
    @Inject
    private ExternalLibraryPreferenceStore externalLibraryPreferenceStore;

    @Inject
    void init() {
        try {
            this.projectProvider.updateCache();
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to initialize external library workspace.", t);
            UIUtils.showError(t);
        }
        this.externalLibraryPreferenceStore.addListener((ExternalLibraryPreferenceStore.StoreUpdatedListener)this);
    }

    public void storeUpdated(ExternalLibraryPreferenceStore store, IProgressMonitor monitor) {
        this.projectProvider.updateCache();
    }

    public ProjectDescription getProjectDescription(URI location) {
        Pair<N4JSExternalProject, ProjectDescription> pair = this.projectProvider.getProjectWithDescription(location);
        return pair == null ? null : (ProjectDescription)pair.getSecond();
    }

    public URI getLocation(URI projectURI, ProjectReference reference) {
        String name = reference.getProjectName();
        N4JSExternalProject project = this.projectProvider.getProject(name);
        if (project == null) {
            return null;
        }
        File referencedProject = new File(project.getLocationURI());
        URI refLocation = URI.createFileURI((String)referencedProject.getAbsolutePath());
        Pair<N4JSExternalProject, ProjectDescription> pair = this.projectProvider.getProjectWithDescription(refLocation);
        if (pair != null) {
            return refLocation;
        }
        return null;
    }

    public Iterator<URI> getFolderIterator(URI folderLocation) {
        String projectName;
        N4JSExternalProject project;
        URI findProjectWith = this.findProjectWith(folderLocation);
        if (findProjectWith != null && (project = this.projectProvider.getProject(projectName = ProjectDescriptionUtils.deriveN4JSProjectNameFromURI((URI)findProjectWith))) != null) {
            String folderPath;
            String projectPath = new File(project.getLocationURI()).getAbsolutePath();
            N4JSExternalProject container = projectPath.equals(folderPath = folderLocation.toFileString()) ? project : project.getFolder(folderPath.substring(projectPath.length() + 1));
            LinkedList result = Lists.newLinkedList();
            try {
                container.accept(resource -> {
                    if (resource instanceof IFile) {
                        String path = new File(resource.getLocationURI()).getAbsolutePath();
                        result.add(URI.createFileURI((String)path));
                    }
                    return resource.getType() != 2 || !resource.getName().equals("node_modules");
                });
                return Iterators.unmodifiableIterator(result.iterator());
            }
            catch (CoreException e) {
                return Iterators.unmodifiableIterator(result.iterator());
            }
        }
        return Collections.emptyIterator();
    }

    public URI findArtifactInFolder(URI folderLocation, String folderRelativePath) {
        IFile file;
        IResource folder = this.getResource(folderLocation);
        if (folder instanceof IFolder && (file = ((IFolder)folder).getFile(folderRelativePath)) instanceof IExternalResource) {
            File externalResource = ((IExternalResource)file).getExternalResource();
            return URI.createFileURI((String)externalResource.getAbsolutePath());
        }
        return null;
    }

    public URI findProjectWith(URI nestedLocation) {
        URI uriCandidate;
        java.net.URI rootLoc = this.getRootLocationForResource(nestedLocation);
        if (rootLoc != null && this.projectProvider.getProject(uriCandidate = this.computeProjectURI(nestedLocation, rootLoc)) != null) {
            return uriCandidate;
        }
        return null;
    }

    private URI computeProjectURI(URI nestedLocation, java.net.URI rootLoc) {
        String rootLocStr = rootLoc.toString();
        URI loc = URI.createURI((String)rootLocStr);
        URI prefix = !loc.hasTrailingPathSeparator() ? loc.appendSegment("") : loc;
        int oldSegmentCount = nestedLocation.segmentCount();
        int newSegmentCount = prefix.segmentCount() - 1 + 1;
        if (newSegmentCount - 1 >= oldSegmentCount) {
            return null;
        }
        String projectNameCandidate = nestedLocation.segment(newSegmentCount - 1);
        if (projectNameCandidate.startsWith("@")) {
            ++newSegmentCount;
        }
        URI uriCandidate = nestedLocation.trimSegments(oldSegmentCount - newSegmentCount).trimFragment();
        return uriCandidate;
    }

    public ExternalLibraryWorkspace.RegisterResult registerProjects(IProgressMonitor monitor, Set<URI> toBeUpdated) {
        ISchedulingRule rule = this.builder.getRule();
        try {
            Job.getJobManager().beginRule(rule, monitor);
            ExternalLibraryWorkspace.RegisterResult registerResult = this.registerProjectsInternal(monitor, toBeUpdated);
            return registerResult;
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
    }

    public ExternalLibraryWorkspace.RegisterResult deregisterProjects(IProgressMonitor monitor, Set<URI> toBeDeleted) {
        ISchedulingRule rule = this.builder.getRule();
        try {
            Job.getJobManager().beginRule(rule, monitor);
            ExternalLibraryWorkspace.RegisterResult registerResult = this.deregisterProjectsInternal(monitor, toBeDeleted, new HashSet<URI>());
            return registerResult;
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
    }

    public ExternalLibraryWorkspace.RegisterResult deregisterAllProjects(IProgressMonitor monitor) {
        ISchedulingRule rule = this.builder.getRule();
        try {
            Job.getJobManager().beginRule(rule, monitor);
            HashSet<URI> toBeDeleted = new HashSet<URI>();
            for (ExternalProject externalProject : this.getProjects()) {
                URI location = URIUtils.convert((IResource)externalProject);
                toBeDeleted.add(location);
            }
            HashSet<URI> hashSet = new HashSet<URI>();
            for (java.net.URI rootLocation : this.projectProvider.getRootLocationsInReversedShadowingOrder()) {
                hashSet.add(URIUtils.toFileUri((java.net.URI)rootLocation));
            }
            ExternalLibraryWorkspace.RegisterResult registerResult = this.deregisterProjectsInternal(monitor, toBeDeleted, hashSet);
            return registerResult;
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
    }

    private ExternalLibraryWorkspace.RegisterResult deregisterProjectsInternal(IProgressMonitor monitor, Set<URI> toBeDeleted, Set<URI> toBeWiped) {
        if (!ExternalLibrariesActivator.requiresInfrastructureForLibraryManager()) {
            logger.warn((Object)"Built-in libraries and NPM support are disabled.");
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        Set<N4JSExternalProject> allProjectsToClean = this.getAllToBeCleaned(toBeDeleted);
        LinkedList<IProject> extPrjCleaned = new LinkedList<IProject>();
        if (!allProjectsToClean.isEmpty()) {
            extPrjCleaned.addAll(this.builder.clean(allProjectsToClean, (IProgressMonitor)subMonitor.split(1)));
        }
        HashSet wsPrjAffected = Sets.newHashSet();
        wsPrjAffected.addAll(this.collector.getWSProjectsDependendingOn(allProjectsToClean));
        toBeWiped.addAll(toBeDeleted);
        this.wipeIndex(monitor, toBeWiped, allProjectsToClean);
        return new ExternalLibraryWorkspace.RegisterResult(extPrjCleaned.toArray(new IProject[0]), wsPrjAffected.toArray(new IProject[0]), toBeWiped);
    }

    private Set<N4JSExternalProject> getAllToBeCleaned(Set<URI> toBeDeleted) {
        HashSet<N4JSExternalProject> allProjectsToClean = new HashSet<N4JSExternalProject>();
        HashSet<N4JSExternalProject> projectsToClean = new HashSet<N4JSExternalProject>();
        for (URI toBeDeletedLocation : toBeDeleted) {
            N4JSExternalProject project = this.projectProvider.getProject(toBeDeletedLocation);
            if (project == null) continue;
            projectsToClean.add(project);
        }
        allProjectsToClean.addAll(projectsToClean);
        allProjectsToClean.addAll(Sets.newHashSet((Iterable)this.collector.getExtProjectsDependendingOn(projectsToClean)));
        return allProjectsToClean;
    }

    private void wipeIndex(IProgressMonitor monitor, Set<URI> toBeDeleted, Set<N4JSExternalProject> allProjectsToClean) {
        HashSet<URI> toBeWiped = new HashSet<URI>(toBeDeleted);
        for (N4JSExternalProject project : allProjectsToClean) {
            toBeWiped.add(URIUtils.toFileUri((java.net.URI)project.getLocationURI()));
        }
        this.builder.wipeURIsFromIndex(monitor, toBeWiped);
    }

    private ExternalLibraryWorkspace.RegisterResult registerProjectsInternal(IProgressMonitor monitor, Set<URI> toBeUpdated) {
        LinkedList<IProject> extPrjBuilt = new LinkedList<IProject>();
        if (!ExternalLibrariesActivator.requiresInfrastructureForLibraryManager()) {
            logger.warn((Object)"Built-in libraries and NPM support are disabled.");
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        Collection<N4JSExternalProject> projectsToBuild = this.getExternalProjects(toBeUpdated);
        HashSet<N4JSExternalProject> allProjectsToBuild = new HashSet<N4JSExternalProject>();
        allProjectsToBuild.addAll(projectsToBuild);
        allProjectsToBuild.addAll(this.collector.getExtProjectsDependendingOn(projectsToBuild));
        if (!Iterables.isEmpty(allProjectsToBuild)) {
            extPrjBuilt.addAll(this.builder.build(allProjectsToBuild, (IProgressMonitor)subMonitor.split(1)));
        }
        HashSet wsPrjAffected = Sets.newHashSet();
        HashSet<N4JSExternalProject> affectedProjects = new HashSet<N4JSExternalProject>();
        affectedProjects.addAll(allProjectsToBuild);
        wsPrjAffected.addAll(this.collector.getWSProjectsDependendingOn(affectedProjects));
        return new ExternalLibraryWorkspace.RegisterResult(extPrjBuilt.toArray(new IProject[0]), wsPrjAffected.toArray(new IProject[0]));
    }

    public void scheduleWorkspaceProjects(IProgressMonitor monitor, Set<URI> toBeScheduled) {
        HashSet scheduledProjects = Sets.newHashSet();
        for (URI scheduledURI : toBeScheduled) {
            IN4JSProject wsProject = (IN4JSProject)this.core.findProject(scheduledURI).orNull();
            if (!(wsProject instanceof N4JSEclipseProject)) continue;
            N4JSEclipseProject n4EclProject = (N4JSEclipseProject)wsProject;
            scheduledProjects.add(n4EclProject.getProject());
        }
        this.scheduler.scheduleBuildIfNecessary((Iterable)scheduledProjects);
    }

    private Collection<N4JSExternalProject> getExternalProjects(Set<URI> toBeUpdated) {
        HashSet<N4JSExternalProject> projectsToBeUpdated = new HashSet<N4JSExternalProject>();
        for (URI tbu : toBeUpdated) {
            N4JSExternalProject n4Prj = this.projectProvider.getProject(tbu);
            projectsToBeUpdated.add(n4Prj);
        }
        Set nonWSProjects = this.collector.filterNonWSProjects(projectsToBeUpdated);
        return nonWSProjects;
    }

    public Collection<N4JSExternalProject> getProjects() {
        return this.projectProvider.getProjects();
    }

    public boolean isNecessary(URI location) {
        return this.projectProvider.getAllProjectLocations().contains(location);
    }

    public List<Pair<URI, ProjectDescription>> computeProjectsIncludingUnnecessary() {
        return this.projectProvider.computeProjectsIncludingUnnecessary();
    }

    public Collection<URI> getAllProjectLocations() {
        return this.projectProvider.getAllProjectLocations();
    }

    public Map<String, VersionNumber> getProjectNameVersionMap() {
        HashMap<String, VersionNumber> externalLibs = new HashMap<String, VersionNumber>();
        for (N4JSExternalProject pd : this.getProjects()) {
            String name = pd.getIProject().getProjectName();
            VersionNumber version = pd.getIProject().getVersion();
            externalLibs.put(name, version);
        }
        return externalLibs;
    }

    public Collection<N4JSExternalProject> getProjectsIn(java.net.URI rootLocation) {
        return this.projectProvider.getProjectsIn(rootLocation);
    }

    public Collection<N4JSExternalProject> getProjectsIn(Collection<java.net.URI> rootLocations) {
        LinkedList<N4JSExternalProject> projects = new LinkedList<N4JSExternalProject>();
        for (java.net.URI rootLoc : rootLocations) {
            projects.addAll(this.getProjectsIn(rootLoc));
        }
        return projects;
    }

    public N4JSExternalProject getProject(String projectName) {
        return this.projectProvider.getProject(projectName);
    }

    public N4JSExternalProject getProject(URI projectLocation) {
        return this.projectProvider.getProject(projectLocation);
    }

    public IResource getResource(URI location) {
        File projectResource;
        String projectName;
        N4JSExternalProject project;
        URI projectLocation;
        String path = location.toFileString();
        if (path == null) {
            return null;
        }
        File nestedResource = new File(path);
        if (nestedResource.exists() && (projectLocation = this.findProjectWith(location)) != null && (project = this.getProject(projectName = ProjectDescriptionUtils.deriveN4JSProjectNameFromURI((URI)projectLocation))) instanceof ExternalProject && (projectResource = new File(project.getLocationURI())).isDirectory()) {
            Path nestedPath;
            Path projectPath = projectResource.toPath();
            if (projectPath.equals(nestedPath = nestedResource.toPath())) {
                return project;
            }
            Path relativePath = projectPath.relativize(nestedPath);
            IFile file = project.getFile(relativePath.toString());
            if (file.exists()) {
                return file;
            }
            IFolder folder = project.getFolder(relativePath.toString());
            if (folder.exists()) {
                return folder;
            }
        }
        return null;
    }

    public void updateState() {
        this.projectProvider.updateCache();
    }

    public List<Pair<URI, ProjectDescription>> getProjectsIncludingUnnecessary() {
        return this.projectProvider.getProjectsIncludingUnnecessary();
    }

    public List<N4JSExternalProject> getProjectsForName(String projectName) {
        return this.projectProvider.getProjectsForName(projectName);
    }

    public java.net.URI getRootLocationForResource(URI nestedLocation) {
        return EclipseExternalLibraryWorkspace.getRootLocationForResource(this.projectProvider.getAllRootLocations(), (URI)nestedLocation);
    }
}

