/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.formatting2;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.ui.editor.formatting2.ContentFormatter;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class FixedContentFormatter
extends ContentFormatter {
    protected TextEdit createTextEdit(List<ITextReplacement> replacements) {
        if (replacements.isEmpty()) {
            return new ReplaceEdit(0, 0, "");
        }
        ITextRegionAccess regionAccess = replacements.get(0).getTextRegionAccess();
        String newDocument = regionAccess.getRewriter().renderToString(replacements);
        return new ReplaceEdit(0, regionAccess.regionForDocument().getLength(), newDocument);
    }

    public void format(IDocument document, IRegion region) {
        ReplaceEdit r;
        IXtextDocument doc = (IXtextDocument)document;
        TextEdit e = (TextEdit)doc.priorityReadOnly((IUnitOfWork)new ContentFormatter.FormattingUnitOfWork((ContentFormatter)this, doc, region));
        if (e == null) {
            return;
        }
        if (e instanceof ReplaceEdit && (r = (ReplaceEdit)e).getOffset() == 0 && r.getLength() == 0 && r.getText().isEmpty()) {
            return;
        }
        try {
            e.apply(document);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
    }
}

