/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.events;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.eclipse.n4js.tester.events.TestEvent;

public class TestStartedEvent
extends TestEvent {
    private final String testId;
    private final Map<String, String> properties;
    private final long timeout;

    public TestStartedEvent(String sessionId, String testId, long timeout) {
        this(sessionId, testId, timeout, null);
    }

    public TestStartedEvent(String sessionId, String testId, long timeout, Map<String, String> properties) {
        super(sessionId);
        this.testId = testId;
        this.timeout = timeout;
        this.properties = properties == null ? Collections.emptyMap() : ImmutableMap.copyOf(properties);
    }

    public String getTestId() {
        return this.testId;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        return super.toString() + "TID:" + this.testId + "|";
    }
}

