/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.dependencies;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.io.File;
import java.nio.file.Path;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.n4js.ui.external.ExternalLibrariesActionsHelper;
import org.eclipse.n4js.ui.utils.AutobuildUtils;
import org.eclipse.n4js.ui.wizard.dependencies.InstallOptions;
import org.eclipse.n4js.utils.StatusHelper;

public class RunnableInstallDependencies
implements IRunnableWithProgress {
    private MultiStatus multistatus;
    private InstallOptions options;
    @Inject
    private StatusHelper statusHelper;
    @Inject
    private ExternalLibrariesActionsHelper librariesActionsHelper;

    public void setInstallOptions(InstallOptions options) {
        this.options = options;
    }

    public synchronized IStatus getResultStatus() {
        if (this.multistatus == null) {
            return this.statusHelper.createError(String.valueOf(this.getClass().getName()) + " was not called yet!");
        }
        MultiStatus result = this.statusHelper.createMultiStatus("result");
        result.merge((IStatus)this.multistatus);
        return result;
    }

    public synchronized void run(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)1);
        boolean wasAutoBuilding = AutobuildUtils.get();
        AutobuildUtils.turnOff();
        this.multistatus = this.statusHelper.createMultiStatus("Status of setting up dependencies.");
        this.librariesActionsHelper.cleanAndInstallAllDependencies(this.getParentPathOfNpmrc(this.options.npmrc), monitor, this.multistatus);
        if (!this.multistatus.isOK()) {
            return;
        }
        if (wasAutoBuilding) {
            AutobuildUtils.turnOn();
        }
    }

    private Optional<Path> getParentPathOfNpmrc(String npmrcPath) {
        File parent;
        File npmrcFile;
        if (!Strings.isNullOrEmpty((String)npmrcPath) && (npmrcFile = new File(npmrcPath)).isFile() && (parent = npmrcFile.getParentFile()) != null) {
            return Optional.of((Object)parent.toPath());
        }
        return Optional.absent();
    }
}

