/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.n4js.json.JSON.JSONArray;
import org.eclipse.n4js.json.JSON.JSONBooleanLiteral;
import org.eclipse.n4js.json.JSON.JSONNullLiteral;
import org.eclipse.n4js.json.JSON.JSONNumericLiteral;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONStringLiteral;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.json.ui.JSONUIModelUtils;
import org.eclipse.n4js.json.ui.labeling.JSONImageDescriptorCache;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;

public class JSONLabelProvider
extends DefaultEObjectLabelProvider {
    @Inject
    public JSONLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    StyledString text(NameValuePair pair) {
        JSONValue value = pair.getValue();
        String nameDescription = String.format("%s", pair.getName());
        if (!JSONUIModelUtils.isContainer(value)) {
            StyledString nameValueLabel = new StyledString(String.valueOf(nameDescription) + " : ");
            nameValueLabel = nameValueLabel.append(this.getText(pair.getValue()), StyledString.QUALIFIER_STYLER);
            return nameValueLabel;
        }
        return new StyledString(nameDescription);
    }

    StyledString text(JSONObject object) {
        return new StyledString("<object>", StyledString.QUALIFIER_STYLER);
    }

    StyledString text(JSONArray array) {
        return new StyledString("<array>", StyledString.QUALIFIER_STYLER);
    }

    String text(JSONNumericLiteral numericLiteral) {
        return numericLiteral.getValue().toString();
    }

    String text(JSONStringLiteral stringLiteral) {
        return String.format("\"%s\"", stringLiteral.getValue());
    }

    String text(JSONBooleanLiteral booleanLiteral) {
        return booleanLiteral.isBooleanValue() ? "true" : "false";
    }

    String text(JSONNullLiteral nullLiteral) {
        return "null";
    }

    ImageDescriptor image(JSONArray array) {
        return (ImageDescriptor)JSONImageDescriptorCache.ImageRef.JSON_ARRAY.asImageDescriptor().get();
    }

    ImageDescriptor image(JSONObject object) {
        return (ImageDescriptor)JSONImageDescriptorCache.ImageRef.JSON_OBJECT.asImageDescriptor().get();
    }

    public Object image(Object element) {
        return JSONImageDescriptorCache.ImageRef.JSON_VALUE.asImageDescriptor().get();
    }

    ImageDescriptor image(NameValuePair pair) {
        JSONValue value = pair.getValue();
        if (value instanceof JSONArray) {
            return this.image((JSONArray)value);
        }
        if (value instanceof JSONObject) {
            return this.image((JSONObject)value);
        }
        return (ImageDescriptor)JSONImageDescriptorCache.ImageRef.JSON_VALUE_PAIR.asImageDescriptor().get();
    }
}

