/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.json.JSON.JSONArray;
import org.eclipse.n4js.json.JSON.JSONBooleanLiteral;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONNullLiteral;
import org.eclipse.n4js.json.JSON.JSONNumericLiteral;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONPackage;
import org.eclipse.n4js.json.JSON.JSONStringLiteral;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.json.services.JSONGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;

public class JSONSemanticSequencer
extends AbstractDelegatingSemanticSequencer {
    @Inject
    private JSONGrammarAccess grammarAccess;

    public void sequence(ISerializationContext context, EObject semanticObject) {
        EPackage epackage = semanticObject.eClass().getEPackage();
        ParserRule rule = context.getParserRule();
        Action action = context.getAssignedAction();
        Set parameters = context.getEnabledBooleanParameters();
        if (epackage == JSONPackage.eINSTANCE) {
            switch (semanticObject.eClass().getClassifierID()) {
                case 3: {
                    this.sequence_JSONArray(context, (JSONArray)semanticObject);
                    return;
                }
                case 7: {
                    this.sequence_JSONBooleanLiteral(context, (JSONBooleanLiteral)semanticObject);
                    return;
                }
                case 0: {
                    this.sequence_JSONDocument(context, (JSONDocument)semanticObject);
                    return;
                }
                case 8: {
                    this.sequence_JSONNullLiteral(context, (JSONNullLiteral)semanticObject);
                    return;
                }
                case 6: {
                    this.sequence_JSONNumericLiteral(context, (JSONNumericLiteral)semanticObject);
                    return;
                }
                case 2: {
                    this.sequence_JSONObject(context, (JSONObject)semanticObject);
                    return;
                }
                case 5: {
                    this.sequence_JSONStringLiteral(context, (JSONStringLiteral)semanticObject);
                    return;
                }
                case 4: {
                    this.sequence_NameValuePair(context, (NameValuePair)semanticObject);
                    return;
                }
            }
        }
        if (this.errorAcceptor != null) {
            this.errorAcceptor.accept(this.diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
        }
    }

    protected void sequence_JSONArray(ISerializationContext context, JSONArray semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_JSONBooleanLiteral(ISerializationContext context, JSONBooleanLiteral semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_JSONDocument(ISerializationContext context, JSONDocument semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_JSONNullLiteral(ISerializationContext context, JSONNullLiteral semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_JSONNumericLiteral(ISerializationContext context, JSONNumericLiteral semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)JSONPackage.Literals.JSON_NUMERIC_LITERAL__VALUE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)JSONPackage.Literals.JSON_NUMERIC_LITERAL__VALUE));
        }
        SequenceFeeder feeder = this.createSequencerFeeder(context, (EObject)semanticObject);
        feeder.accept(this.grammarAccess.getJSONNumericLiteralAccess().getValueNUMBERTerminalRuleCall_0(), (Object)semanticObject.getValue());
        feeder.finish();
    }

    protected void sequence_JSONObject(ISerializationContext context, JSONObject semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_JSONStringLiteral(ISerializationContext context, JSONStringLiteral semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)JSONPackage.Literals.JSON_STRING_LITERAL__VALUE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)JSONPackage.Literals.JSON_STRING_LITERAL__VALUE));
        }
        SequenceFeeder feeder = this.createSequencerFeeder(context, (EObject)semanticObject);
        feeder.accept(this.grammarAccess.getJSONStringLiteralAccess().getValueSTRINGTerminalRuleCall_0(), (Object)semanticObject.getValue());
        feeder.finish();
    }

    protected void sequence_NameValuePair(ISerializationContext context, NameValuePair semanticObject) {
        if (this.errorAcceptor != null) {
            if (this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)JSONPackage.Literals.NAME_VALUE_PAIR__NAME) == ITransientValueService.ValueTransient.YES) {
                this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)JSONPackage.Literals.NAME_VALUE_PAIR__NAME));
            }
            if (this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)JSONPackage.Literals.NAME_VALUE_PAIR__VALUE) == ITransientValueService.ValueTransient.YES) {
                this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)JSONPackage.Literals.NAME_VALUE_PAIR__VALUE));
            }
        }
        SequenceFeeder feeder = this.createSequencerFeeder(context, (EObject)semanticObject);
        feeder.accept(this.grammarAccess.getNameValuePairAccess().getNameSTRINGTerminalRuleCall_0_0(), (Object)semanticObject.getName());
        feeder.accept(this.grammarAccess.getNameValuePairAccess().getValueJSONValueParserRuleCall_2_0(), (Object)semanticObject.getValue());
        feeder.finish();
    }
}

