/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.graph;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.n4js.smith.ui.graph.Point;
import org.eclipse.n4js.smith.ui.graph.Rectangle;
import org.eclipse.n4js.smith.ui.graph.VisualisationGraph;
import org.eclipse.n4js.smith.ui.graph.VisualisationNode;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class VisualisationCanvas
extends Canvas {
    protected VisualisationGraph graph = null;
    protected boolean graphNeedsLayout = true;
    protected int offsetX = 0;
    protected int offsetY = 0;
    protected float scale = 1.0f;
    protected boolean hawkEye_active = false;
    protected Point hawkEye_target = null;
    protected int hawkEye_oldOffsetX = 0;
    protected int hawkEye_oldOffsetY = 0;
    protected float hawkEye_oldScale = 1.0f;
    protected boolean mousePressed = false;
    protected boolean mouseDragged = false;
    protected int mouseDragStartX;
    protected int mouseDragStartY;
    protected int mouseDragBaseX;
    protected int mouseDragBaseY;
    protected VisualisationNode hoveredNode = null;
    protected final Set<VisualisationNode> selectedNodes = new HashSet<VisualisationNode>();
    protected DefaultToolTip toolTip;

    public VisualisationCanvas(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                VisualisationCanvas.this.doPaint(event.gc, event);
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                VisualisationCanvas.this.onMouseDown(e);
            }

            public void mouseUp(MouseEvent e) {
                VisualisationCanvas.this.onMouseUp(e);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                VisualisationCanvas.this.onMouseWheel(e);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                VisualisationCanvas.this.onMouseMove(e);
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                VisualisationCanvas.this.onMouseEnter(e);
            }

            public void mouseExit(MouseEvent e) {
                VisualisationCanvas.this.onMouseExit(e);
            }

            public void mouseHover(MouseEvent e) {
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (this.isCtrlAlt(e)) {
                    VisualisationCanvas.this.setHawkEyeMode(true);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (this.isCtrlAlt(e)) {
                    VisualisationCanvas.this.setHawkEyeMode(false);
                }
            }

            private final boolean isCtrlAlt(KeyEvent e) {
                return e.keyCode == 262144 && (e.stateMask & 0x10000) != 0 || e.keyCode == 65536 && (e.stateMask & 0x40000) != 0;
            }
        });
        this.toolTip = new DefaultToolTip((Control)this, 0, true);
        this.toolTip.setText("Hello tool tip!");
    }

    public VisualisationGraph getGraph() {
        return this.graph;
    }

    public void clear() {
        this.setGraph(null);
    }

    public void setGraph(VisualisationGraph vis) {
        if (vis != this.graph) {
            this.clearSelection();
            if (this.graph == null || vis == null) {
                this.offsetX = 0;
                this.offsetY = 0;
            }
            this.graph = vis;
            this.graphNeedsLayout = true;
            this.redraw();
        }
    }

    public Point screenToGraph(int screenX, int screenY) {
        return new Point((float)(this.offsetX + screenX) / this.scale, (float)(this.offsetY + screenY) / this.scale);
    }

    public void setScrollOffset(int offsetX, int offsetY) {
        if (offsetX != this.offsetX || offsetY != this.offsetY) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.redraw();
        }
    }

    public void setScrollOffset(float graphX, float graphY, int screenX, int screenY) {
        this.setScrollOffset(Math.round(graphX * this.scale - (float)screenX), Math.round(graphY * this.scale - (float)screenY));
    }

    public void zoom(int screenX, int screenY, float deltaScale) {
        if (deltaScale != 0.0f) {
            Point pFix = this.screenToGraph(screenX, screenY);
            this.scale += deltaScale;
            this.setScrollOffset(pFix.x, pFix.y, screenX, screenY);
            this.redraw();
        }
    }

    public void setHawkEyeMode(boolean active) {
        if (active && !this.hawkEye_active && this.graph != null) {
            int border = 5;
            float w = this.getSize().x;
            float h = this.getSize().y;
            Rectangle b = this.graph.getBounds();
            int newOffsetX = 5;
            int newOffsetY = 5;
            float newScale = Math.min((w - 10.0f) / b.width, (h - 10.0f) / b.height);
            if (newScale < 1.0f) {
                this.hawkEye_oldOffsetX = this.offsetX;
                this.hawkEye_oldOffsetY = this.offsetY;
                this.hawkEye_oldScale = this.scale;
                this.offsetX = 5;
                this.offsetY = 5;
                this.scale = newScale;
                this.hawkEye_target = null;
                this.hawkEye_active = true;
                this.redraw();
            }
        } else if (!active && this.hawkEye_active) {
            if (this.hawkEye_target != null) {
                Point pCenter = this.screenToGraph(Math.round(this.hawkEye_target.x), Math.round(this.hawkEye_target.y));
                this.scale = this.hawkEye_oldScale;
                this.setScrollOffset(pCenter.x, pCenter.y, this.getSize().x / 2, this.getSize().y / 2);
                this.hawkEye_target = null;
            } else {
                this.offsetX = this.hawkEye_oldOffsetX;
                this.offsetY = this.hawkEye_oldOffsetY;
                this.scale = this.hawkEye_oldScale;
            }
            this.hawkEye_active = false;
            this.redraw();
        }
    }

    protected void setHawkEyeTarget(Point screenPos) {
        if (this.hawkEye_active) {
            if (screenPos != null) {
                if (this.hawkEye_target == null || this.hawkEye_target.x != screenPos.x || this.hawkEye_target.y != screenPos.y) {
                    this.hawkEye_target = screenPos;
                    this.redraw();
                }
            } else if (this.hawkEye_target != null) {
                this.hawkEye_target = null;
                this.redraw();
            }
        } else {
            this.hawkEye_target = null;
        }
    }

    public void setSelectedNodes(VisualisationNode ... nodes) {
        HashSet<VisualisationNode> newNodes = new HashSet<VisualisationNode>();
        VisualisationNode[] visualisationNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            VisualisationNode n3 = visualisationNodeArray[n2];
            if (n3 != null) {
                newNodes.add(n3);
            }
            ++n2;
        }
        if (!this.selectedNodes.equals(newNodes)) {
            this.selectedNodes.clear();
            this.selectedNodes.addAll(newNodes);
            this.redraw();
        }
    }

    public void toggleSelection(VisualisationNode node) {
        if (this.selectedNodes.contains(node)) {
            this.selectedNodes.remove(node);
        } else {
            this.selectedNodes.add(node);
        }
        this.redraw();
    }

    public void clearSelection() {
        if (!this.selectedNodes.isEmpty()) {
            this.selectedNodes.clear();
            this.redraw();
        }
    }

    public VisualisationNode getNodeAt(int screenX, int screenY) {
        Point p = this.screenToGraph(screenX, screenY);
        return this.graph != null ? this.graph.getNodeAt(p.x, p.y) : null;
    }

    protected void onMouseEnter(MouseEvent event) {
        if (this.hawkEye_active) {
            this.setHawkEyeTarget(new Point(event.x, event.y));
        }
    }

    protected void onMouseExit(MouseEvent event) {
        if (this.hawkEye_active) {
            this.setHawkEyeTarget(null);
        }
    }

    protected void onMouseDown(MouseEvent event) {
        this.mousePressed = true;
        this.mouseDragged = false;
        this.mouseDragStartX = event.x;
        this.mouseDragStartY = event.y;
        this.mouseDragBaseX = this.offsetX;
        this.mouseDragBaseY = this.offsetY;
    }

    protected void onMouseMove(MouseEvent event) {
        if (this.hawkEye_active) {
            this.setHawkEyeTarget(new Point(event.x, event.y));
        }
        VisualisationNode mNode = this.getNodeAt(event.x, event.y);
        if (!this.mousePressed) {
            this.setHoveredNode(mNode);
        }
        if (this.mousePressed) {
            this.mouseDragged |= Math.abs(event.x - this.mouseDragStartX) > 3 || Math.abs(event.y - this.mouseDragStartY) > 3;
            if (this.mouseDragged) {
                this.onMouseDrag(event);
            }
        }
    }

    protected void onMouseDrag(MouseEvent event) {
        this.setScrollOffset(this.mouseDragBaseX - event.x + this.mouseDragStartX, this.mouseDragBaseY - event.y + this.mouseDragStartY);
        this.redraw();
    }

    protected void onMouseUp(MouseEvent event) {
        if (!this.mouseDragged) {
            this.onClick(event);
        }
        this.mousePressed = false;
        this.mouseDragged = false;
        this.mouseDragStartX = 0;
        this.mouseDragStartY = 0;
    }

    protected void onClick(MouseEvent event) {
        boolean shiftPressed;
        VisualisationNode mNode = this.getNodeAt(event.x, event.y);
        boolean bl = shiftPressed = (event.stateMask & 0x20000) != 0;
        if (!shiftPressed) {
            if (mNode == null) {
                this.clearSelection();
            } else {
                this.setSelectedNodes(mNode);
            }
        } else if (mNode != null) {
            this.toggleSelection(mNode);
        }
    }

    protected void onMouseWheel(MouseEvent event) {
        this.zoom(event.x, event.y, 0.01f * (float)event.count);
    }

    protected void setHoveredNode(VisualisationNode node) {
        if (node != this.hoveredNode) {
            this.hoveredNode = node;
            if (this.hoveredNode != null && this.hoveredNode.getDescription() != null) {
                this.toolTip.setText(this.hoveredNode.getDescription());
                this.toolTip.show(new org.eclipse.swt.graphics.Point(4, 4));
            } else {
                this.toolTip.hide();
            }
            this.redraw();
        }
    }

    protected void doPaint(GC gc, PaintEvent event) {
        gc.setBackground(Display.getDefault().getSystemColor(1));
        gc.setForeground(Display.getDefault().getSystemColor(2));
        gc.fillRectangle(event.x, event.y, event.width, event.height);
        if (this.graph != null) {
            Transform tf = new Transform(gc.getDevice());
            tf.translate((float)(-this.offsetX), (float)(-this.offsetY));
            tf.scale(this.scale, this.scale);
            gc.setTransform(tf);
            if (this.graphNeedsLayout) {
                this.graph.layout();
                this.graphNeedsLayout = false;
            }
            this.graph.getNodes().forEach(n -> n.paint(gc));
            gc.setForeground(Display.getDefault().getSystemColor(9));
            gc.setTransform(null);
            tf.dispose();
            if (this.hawkEye_active && this.hawkEye_target != null) {
                int w = Math.round((float)this.getSize().x / this.hawkEye_oldScale * this.scale);
                int h = Math.round((float)this.getSize().y / this.hawkEye_oldScale * this.scale);
                gc.setBackground(Display.getDefault().getSystemColor(9));
                gc.setAlpha(64);
                gc.fillRectangle((int)this.hawkEye_target.x - w / 2, (int)this.hawkEye_target.y - h / 2, w, h);
                gc.setAlpha(255);
            }
        }
    }
}

