/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.server.resources.tests;

import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import javax.servlet.ServletException;
import org.eclipse.n4js.tester.TesterEventBus;
import org.eclipse.n4js.tester.UrlDecoderService;
import org.eclipse.n4js.tester.events.TestEvent;
import org.eclipse.n4js.tester.server.resources.BaseResource;
import org.eclipse.n4js.tester.server.resources.ClientResourceException;

abstract class TestResource
extends BaseResource {
    @Inject
    private TesterEventBus bus;
    @Inject
    private UrlDecoderService urlDecoder;

    TestResource() {
    }

    @Override
    protected int doHandle(String body, String pathInfo) throws ServletException {
        TestResourceParameters parameters = this.getParametersFromPathInfo(pathInfo);
        if (parameters != null && this.sessionExists(parameters.sessionId)) {
            try {
                this.bus.post(this.createEvent(parameters.sessionId, parameters.testId, body));
            }
            catch (Exception e) {
                Throwable rootCause = Throwables.getRootCause((Throwable)e);
                if (rootCause instanceof ClientResourceException) {
                    throw (ClientResourceException)((Object)rootCause);
                }
                LOGGER.error((Object)("Error while creating event for test session. [Session ID: " + parameters.sessionId + "]"), (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            return 200;
        }
        return 404;
    }

    protected abstract TestEvent createEvent(String var1, String var2, String var3) throws ServletException;

    private String unescapeTestId(String testId) {
        return this.urlDecoder.decode(testId);
    }

    protected final TestResourceParameters getParametersFromPathInfo(String pathInfo) {
        ArrayList pathValues = Lists.newArrayList((Iterable)Splitter.on((String)"/").omitEmptyStrings().split((CharSequence)pathInfo));
        if (4 != pathValues.size()) {
            return null;
        }
        String sessionId = (String)pathValues.get(0);
        String unescapedTestId = this.unescapeTestId((String)pathValues.get(2));
        return new TestResourceParameters(sessionId, unescapedTestId);
    }

    protected static final class TestResourceParameters {
        public final String sessionId;
        public final String testId;

        private TestResourceParameters(String sessionID, String testID) {
            this.sessionId = sessionID;
            this.testId = testID;
        }
    }
}

